/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.human.EntranceRegistBeanInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.EntranceCardVo;

public class EntranceCardAction
extends PlatformHumanAction {
    public static final String CMD_SELECT = "PF1191";
    public static final String CMD_SEARCH = "PF1192";
    public static final String CMD_REGIST = "PF1196";
    public static final String CMD_DELETE = "PF1197";
    public static final String CMD_TRANSFER = "PF1199";

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SELECT)) {
            this.prepareVo(true, false);
            this.select();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_REGIST)) {
            this.prepareVo();
            this.regist();
        } else if (this.mospParams.getCommand().equals(CMD_DELETE)) {
            this.prepareVo();
            this.delete();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new EntranceCardVo();
    }

    protected void select() throws MospException {
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValues();
        this.setEntranceInfo();
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValues();
        this.setEntranceInfo();
    }

    protected void regist() throws MospException {
        EntranceRegistBeanInterface regist = this.platform().entranceRegist();
        EntranceDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.regist(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertMessage();
        this.setEntranceInfo();
    }

    protected void delete() throws MospException {
        EntranceRegistBeanInterface regist = this.platform().entranceRegist();
        EntranceDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.delete(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addDeleteFailedMessage();
            return;
        }
        this.commit();
        this.addDeleteMessage();
        this.setDefaultValues();
    }

    protected void transfer() {
        EntranceCardVo vo = (EntranceCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        }
    }

    protected void setEntranceInfo() throws MospException {
        EntranceCardVo vo = (EntranceCardVo)this.mospParams.getVo();
        this.setVoFields(this.reference().entrance().getEntranceInfo(vo.getPersonalId()));
    }

    protected void setDefaultValues() {
        EntranceCardVo vo = (EntranceCardVo)this.mospParams.getVo();
        vo.setRecordId(0L);
        vo.setTxtEntranceYear("");
        vo.setTxtEntranceMonth("");
        vo.setTxtEntranceDay("");
    }

    protected void setDtoFields(EntranceDtoInterface dto) {
        EntranceCardVo vo = (EntranceCardVo)this.mospParams.getVo();
        dto.setPfaHumanEntranceId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setEntranceDate(this.getEntranceDate());
    }

    protected void setVoFields(EntranceDtoInterface dto) {
        if (dto == null) {
            return;
        }
        EntranceCardVo vo = (EntranceCardVo)this.mospParams.getVo();
        vo.setRecordId(dto.getPfaHumanEntranceId());
        vo.setPersonalId(dto.getPersonalId());
        vo.setTxtEntranceYear(this.getStringYear(dto.getEntranceDate()));
        vo.setTxtEntranceMonth(this.getStringMonth(dto.getEntranceDate()));
        vo.setTxtEntranceDay(this.getStringDay(dto.getEntranceDate()));
    }

    protected Date getEntranceDate() {
        EntranceCardVo vo = (EntranceCardVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtEntranceYear(), vo.getTxtEntranceMonth(), vo.getTxtEntranceDay());
    }
}

