/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.human.action;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.HumanHistoryRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;
import jp.mosp.platform.human.action.BasicListAction;
import jp.mosp.platform.human.action.HumanInfoAction;
import jp.mosp.platform.human.base.PlatformHumanAction;
import jp.mosp.platform.human.vo.BasicCardVo;
import jp.mosp.platform.utils.InputCheckUtility;
import jp.mosp.platform.utils.PlatformMessageUtility;

public class BasicCardAction
extends PlatformHumanAction {
    public static final String CMD_SET_ACTIVATION_DATE = "PF1131";
    public static final String CMD_SEARCH = "PF1132";
    public static final String CMD_RE_SEARCH = "PF1133";
    public static final String CMD_ADD_SELECT = "PF1136";
    public static final String CMD_ADD = "PF1138";
    public static final String CMD_EDIT_SELECT = "PF1156";
    public static final String CMD_UPDATE = "PF1158";
    public static final String CMD_TRANSFER = "PF1159";

    public BasicCardAction() {
        this.topicPathCommand = CMD_RE_SEARCH;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SET_ACTIVATION_DATE)) {
            this.prepareVo();
            this.setActivationDate();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SEARCH)) {
            this.prepareVo(true, false);
            this.reSearch();
        } else if (this.mospParams.getCommand().equals(CMD_ADD_SELECT)) {
            this.prepareVo(true, false);
            this.addSelect();
        } else if (this.mospParams.getCommand().equals(CMD_ADD)) {
            this.prepareVo();
            this.add();
        } else if (this.mospParams.getCommand().equals(CMD_EDIT_SELECT)) {
            this.prepareVo(false, false);
            this.editSelect();
        } else if (this.mospParams.getCommand().equals(CMD_UPDATE)) {
            this.prepareVo();
            this.update();
        } else if (this.mospParams.getCommand().equals(CMD_TRANSFER)) {
            this.prepareVo(true, false);
            this.transfer();
        } else {
            this.throwInvalidCommandException();
        }
    }

    protected BaseVo getSpecificVo() {
        return new BasicCardVo();
    }

    protected void setActivationDate() throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setModeActivateDate("fixed");
            this.setPulldown();
            this.setPostPulldown();
            this.setPersonalInfo(vo.getPersonalId(), this.getActivateDate(), false);
        } else if (vo.getModeActivateDate().equals("fixed")) {
            vo.setModeActivateDate("chaning");
            this.setPulldown();
            this.setPostPulldown();
        }
    }

    protected void search() throws MospException {
        this.searchHumanCommonInfo();
        this.setDefaultValue();
    }

    protected void reSearch() throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        this.setHumanCommonInfo(vo.getPersonalId(), vo.getTargetDate());
        if (vo.getModeCardEdit().equals("add")) {
            vo.setTxtActivateYear("");
            vo.setTxtActivateMonth("");
            vo.setTxtActivateDay("");
            vo.setModeActivateDate("chaning");
        } else if (vo.getModeCardEdit().equals("edit")) {
            vo.setModeActivateDate("fixed");
        }
        this.setPulldown();
        this.setPersonalInfo(vo.getPersonalId(), vo.getTargetDate(), false);
    }

    protected void addSelect() throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        vo.setNeedPost(this.mospParams.getApplicationPropertyBool("UsePost"));
        this.setPlatformHumanSettings(CMD_SEARCH, "noActiveDate");
        this.setTargetHumanCommonInfo();
        this.setDefaultValue();
        vo.setJsChangeEmployCode(Boolean.valueOf(this.mospParams.getApplicationPropertyBool("ChangeEmployCode")));
    }

    protected void add() throws MospException {
        this.validate();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        HumanRegistBeanInterface regist = this.platform().humanRegist();
        HumanDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.add(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.registPost();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addInsertHistoryMessage();
        this.setHumanCommonInfo(dto.getPersonalId(), dto.getActivateDate());
        this.setPersonalInfo(dto.getPersonalId(), dto.getActivateDate(), true);
    }

    protected void editSelect() throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        vo.setNeedPost(this.mospParams.getApplicationPropertyBool("UsePost"));
        this.setPlatformHumanSettings(CMD_SEARCH, "codeAndName");
        this.setTargetHumanCommonInfo();
        vo.setModeActivateDate("fixed");
        vo.setModeCardEdit("edit");
        this.setPersonalInfo(vo.getPersonalId(), vo.getTargetDate(), true);
        this.setPulldown();
        this.setPostPulldown();
        vo.setJsChangeEmployCode(Boolean.valueOf(this.mospParams.getApplicationPropertyBool("ChangeEmployCode")));
    }

    protected void update() throws MospException {
        this.validate();
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        HumanRegistBeanInterface regist = this.platform().humanRegist();
        HumanDtoInterface dto = regist.getInitDto();
        this.setDtoFields(dto);
        regist.update(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addUpdateFailedMessage();
            return;
        }
        this.registUpdatePost(dto);
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addUpdateHistoryMessage();
        this.setPersonalInfo(dto.getPersonalId(), dto.getActivateDate(), true);
    }

    protected void transfer() {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        String actionName = this.getTransferredAction();
        this.setTargetPersonalId(vo.getPersonalId());
        this.setTargetDate(vo.getTargetDate());
        if (actionName.equals(HumanInfoAction.class.getName())) {
            this.mospParams.setNextCommand("PF1121");
        } else if (actionName.equals(BasicListAction.class.getName())) {
            this.mospParams.setNextCommand("PF1146");
        }
    }

    private void setPulldown() throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltSection(this.getInputActivateDatePulldown());
            vo.setAryPltPosition(this.getInputActivateDatePulldown());
            vo.setAryPltEmployment(this.getInputActivateDatePulldown());
            vo.setAryPltWorkPlaceName(this.getInputActivateDatePulldown());
            return;
        }
        Date targetDate = this.getActivateDate();
        vo.setAryPltSection(this.reference().section().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltPosition(this.reference().position().getCodedSelectArray(targetDate, true, null));
        vo.setAryPltEmployment(this.reference().employmentContract().getCodedAbbrSelectArray(targetDate, true, null));
        vo.setAryPltWorkPlaceName(this.reference().workPlace().getCodedAbbrSelectArray(targetDate, true, null));
    }

    protected void setPostPulldown() throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        if (!vo.getNeedPost()) {
            return;
        }
        if (vo.getModeActivateDate().equals("chaning")) {
            vo.setAryPltPostName(this.getInputActivateDatePulldown());
            return;
        }
        vo.setAryPltPostName(this.reference().naming().getCodedSelectArray("post", this.getActivateDate(), true));
    }

    private void setPersonalInfo(String personalId, Date activateDate, boolean isActiveDate) throws MospException {
        HumanDtoInterface humanDto = this.reference().human().getHumanInfo(personalId, activateDate);
        if (humanDto == null) {
            List humanList = this.reference().human().getHistory(personalId);
            if (humanList.isEmpty()) {
                PlatformMessageUtility.addErrorEmployeeNotExist((MospParams)this.mospParams);
                if (this.mospParams.hasErrorMessage()) {
                    this.mospParams.setNextCommand("PF0040");
                }
                throw new MospException("FWW0101");
            }
            humanDto = (HumanDtoInterface)humanList.get(0);
        }
        this.setVoFields(humanDto, isActiveDate);
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        if (!vo.getNeedPost()) {
            return;
        }
        HumanHistoryDtoInterface postDto = this.reference().humanHistory().findForInfo(personalId, "post", activateDate);
        this.setVoFieldsPost(postDto);
    }

    protected void setDtoFields(HumanDtoInterface dto) throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        dto.setPfmHumanId(vo.getRecordId());
        dto.setPersonalId(vo.getPersonalId());
        dto.setActivateDate(this.getActivateDate());
        dto.setEmployeeCode(vo.getTxtEmployeeCode());
        dto.setLastName(vo.getTxtLastName());
        dto.setFirstName(vo.getTxtFirstName());
        dto.setLastKana(vo.getTxtLastKana());
        dto.setFirstKana(vo.getTxtFirstKana());
        dto.setEmploymentContractCode(vo.getPltEmploymentName());
        dto.setSectionCode(vo.getPltSectionName());
        dto.setPositionCode(vo.getPltPositionName());
        dto.setWorkPlaceCode(vo.getPltWorkPlaceName());
        dto.setMail("");
    }

    protected void setVoFields(HumanDtoInterface humanDto, boolean isActiveDate) {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        vo.setRecordId(humanDto.getPfmHumanId());
        vo.setPersonalId(humanDto.getPersonalId());
        vo.setTxtEmployeeCode(humanDto.getEmployeeCode());
        vo.setTxtLastName(humanDto.getLastName());
        vo.setTxtFirstName(humanDto.getFirstName());
        vo.setTxtLastKana(humanDto.getLastKana());
        vo.setTxtFirstKana(humanDto.getFirstKana());
        vo.setPltSectionName(humanDto.getSectionCode());
        vo.setPltPositionName(humanDto.getPositionCode());
        vo.setPltEmploymentName(humanDto.getEmploymentContractCode());
        vo.setPltWorkPlaceName(humanDto.getWorkPlaceCode());
        if (isActiveDate) {
            vo.setTxtActivateYear(this.getStringYear(humanDto.getActivateDate()));
            vo.setTxtActivateMonth(this.getStringMonth(humanDto.getActivateDate()));
            vo.setTxtActivateDay(this.getStringDay(humanDto.getActivateDate()));
        }
    }

    protected void setVoFieldsPost(HumanHistoryDtoInterface postDto) throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        if (!vo.getNeedPost()) {
            return;
        }
        if (postDto == null) {
            vo.setPltPostName("");
            return;
        }
        vo.setPltPostName(postDto.getHumanItemValue());
    }

    protected void registPost() throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        if (!vo.getNeedPost()) {
            return;
        }
        if (vo.getPltPostName() == null || vo.getPltPostName().isEmpty()) {
            return;
        }
        HumanHistoryRegistBeanInterface historyRegist = this.platform().humanHistoryRegist();
        HumanHistoryDtoInterface humanHistoryDto = historyRegist.getInitDto();
        humanHistoryDto.setActivateDate(this.getActivateDate());
        humanHistoryDto.setPersonalId(vo.getPersonalId());
        humanHistoryDto.setHumanItemType("post");
        humanHistoryDto.setHumanItemValue(vo.getPltPostName());
        historyRegist.add(humanHistoryDto);
    }

    protected void registUpdatePost(HumanDtoInterface dto) throws MospException {
        HumanHistoryRegistBeanInterface historyRegist = this.platform().humanHistoryRegist();
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        if (!vo.getNeedPost()) {
            return;
        }
        HumanHistoryDtoInterface historyDto = this.reference().humanHistory().findForKey(dto.getPersonalId(), "post", dto.getActivateDate());
        if (historyDto == null) {
            this.registPost();
            return;
        }
        if (vo.getPltPostName() == null || vo.getPltPostName().isEmpty()) {
            historyRegist.delete(historyDto);
            return;
        }
        historyDto.setHumanItemValue(vo.getPltPostName());
        historyRegist.update(historyDto);
    }

    protected Date getActivateDate() {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        return this.getDate(vo.getTxtActivateYear(), vo.getTxtActivateMonth(), vo.getTxtActivateDay());
    }

    protected void setDefaultValue() throws MospException {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        vo.setModeActivateDate("chaning");
        vo.setModeCardEdit("add");
        this.setPulldown();
        this.setPostPulldown();
        this.setPersonalInfo(vo.getPersonalId(), vo.getTargetDate(), false);
        vo.setTxtActivateYear("");
        vo.setTxtActivateMonth("");
        vo.setTxtActivateDay("");
    }

    private void validate() {
        BasicCardVo vo = (BasicCardVo)this.mospParams.getVo();
        String[] aryActivateYear = new String[]{this.mospParams.getName("ActivateDate", new String[]{"FrontParentheses", "Year", "BackParentheses"})};
        String[] aryActivateMonth = new String[]{this.mospParams.getName("ActivateDate", new String[]{"FrontParentheses", "Month", "BackParentheses"})};
        String[] aryActivateDay = new String[]{this.mospParams.getName("ActivateDate", new String[]{"FrontParentheses", "Day", "BackParentheses"})};
        InputCheckUtility.checkRequired((String)vo.getTxtActivateYear(), (String[])aryActivateYear, (MospParams)this.mospParams);
        InputCheckUtility.checkRequired((String)vo.getTxtActivateMonth(), (String[])aryActivateMonth, (MospParams)this.mospParams);
        InputCheckUtility.checkRequired((String)vo.getTxtActivateDay(), (String[])aryActivateDay, (MospParams)this.mospParams);
        InputCheckUtility.checkNumber((String)vo.getTxtActivateYear(), (String[])aryActivateYear, (MospParams)this.mospParams);
        InputCheckUtility.checkNumber((String)vo.getTxtActivateMonth(), (String[])aryActivateMonth, (MospParams)this.mospParams);
        InputCheckUtility.checkNumber((String)vo.getTxtActivateDay(), (String[])aryActivateDay, (MospParams)this.mospParams);
        InputCheckUtility.checkDate((String)vo.getTxtActivateYear(), (String)vo.getTxtActivateMonth(), (String)vo.getTxtActivateDay(), (String[])new String[]{this.mospParams.getName("ActivateDate"), this.mospParams.getName("CorrectDate")}, (MospParams)this.mospParams);
        if (this.mospParams.getCommand().equals(CMD_ADD) || this.mospParams.getCommand().equals(CMD_UPDATE)) {
            String[] aryEmployeeCode = new String[]{this.mospParams.getName("Employee", new String[]{"Code"})};
            String[] aryLastName = new String[]{this.mospParams.getName("LastName")};
            InputCheckUtility.checkRequired((String)vo.getTxtEmployeeCode(), (String[])aryEmployeeCode, (MospParams)this.mospParams);
            InputCheckUtility.checkRequired((String)vo.getTxtLastName(), (String[])aryLastName, (MospParams)this.mospParams);
            InputCheckUtility.checkCode((String)vo.getTxtEmployeeCode(), (String[])aryEmployeeCode, (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getTxtEmployeeCode(), (int)10, (String)this.mospParams.getName("Employee", new String[]{"Code"}), (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getTxtLastName(), (int)10, (String)this.mospParams.getName("LastName"), (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getTxtFirstName(), (int)10, (String)this.mospParams.getName("FirstName"), (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getTxtLastKana(), (int)10, (String)this.mospParams.getName("LastName", new String[]{"FrontParentheses", "Kana", "BackParentheses"}), (MospParams)this.mospParams);
            InputCheckUtility.checkLength((String)vo.getTxtFirstKana(), (int)10, (String)this.mospParams.getName("FirstName", new String[]{"FrontParentheses", "Kana", "BackParentheses"}), (MospParams)this.mospParams);
        }
    }
}

