/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.file.base;

import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.BaseVo;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.bean.file.ImportSearchBeanInterface;
import jp.mosp.platform.comparator.file.ImportMasterImportCodeComparator;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.file.vo.ImportListVo;

public abstract class ImportListAction
extends PlatformAction {
    public static final String PRM_FIL_IMPORT = "filImport";

    protected BaseVo getSpecificVo() {
        return new ImportListVo();
    }

    protected void search() throws MospException {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        ImportSearchBeanInterface search = this.reference().importSearch();
        search.setCode(vo.getTxtSearchCode());
        search.setName(vo.getTxtSearchName());
        search.setTable(vo.getPltSearchTable());
        search.setType(vo.getPltSearchType());
        search.setHeader(vo.getPltSearchHeader());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        search.setTableTypeArray(this.getCodeArray(vo.getTableTypeCodeKey(), false));
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(ImportMasterImportCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        vo.setRadSelect("");
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        String[] aryLblCode = new String[list.size()];
        String[] aryLblName = new String[list.size()];
        String[] aryLblTable = new String[list.size()];
        String[] aryLblType = new String[list.size()];
        String[] aryLblHeader = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ImportDtoInterface dto = (ImportDtoInterface)list.get(i);
            aryLblCode[i] = dto.getImportCode();
            aryLblName[i] = dto.getImportName();
            aryLblTable[i] = this.getCodeName(dto.getImportTable(), vo.getTableTypeCodeKey());
            aryLblType[i] = this.getCodeName(dto.getType(), "FileType");
            aryLblHeader[i] = this.getCodeName(dto.getHeader(), "HeaderType");
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryLblCode(aryLblCode);
        vo.setAryLblName(aryLblName);
        vo.setAryLblTable(aryLblTable);
        vo.setAryLblType(aryLblType);
        vo.setAryLblHeader(aryLblHeader);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void initImportListVoFields() {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        vo.setTxtSearchCode("");
        vo.setTxtSearchName("");
        vo.setPltSearchTable("");
        vo.setPltSearchHeader("");
        vo.setRadSelect("");
        vo.setPltSearchType("1");
        vo.setPltSearchInactivate(String.valueOf(0));
        vo.setAryPltTableType(this.getCodeArray(vo.getTableTypeCodeKey(), true));
        vo.setComparatorName(ImportMasterImportCodeComparator.class.getName());
    }
}

