/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.file.base;

import java.util.List;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.bean.file.ExportSearchBeanInterface;
import jp.mosp.platform.comparator.file.ExportMasterExportCodeComparator;
import jp.mosp.platform.dto.file.ExportDtoInterface;
import jp.mosp.platform.file.base.ExportListVo;

public abstract class ExportListAction
extends PlatformAction {
    public static final String PATH_EXPORT_LIST_JSP = "/jsp/platform/file/exportList.jsp";
    public static final String PATH_EXPORT_LIST_JS = "/pub/platform/file/js/exportList.js";
    public static final String PATH_EXPORT_LIST_CSS = "/pub/platform/file/css/exportList.css";

    protected void addBaseJsCssFiles() {
        super.addBaseJsCssFiles();
        this.mospParams.addJsFile(PATH_EXPORT_LIST_JS);
        this.mospParams.addCssFile(PATH_EXPORT_LIST_CSS);
    }

    protected void search() throws MospException {
        ExportListVo vo = (ExportListVo)this.mospParams.getVo();
        ExportSearchBeanInterface search = this.reference().exportSearch();
        search.setCode(vo.getTxtSearchCode());
        search.setName(vo.getTxtSearchName());
        search.setTable(vo.getPltSearchTable());
        search.setType(vo.getPltSearchType());
        search.setHeader(vo.getPltSearchHeader());
        search.setInactivateFlag(vo.getPltSearchInactivate());
        search.setTableTypeArray(this.getCodeArray(vo.getTableTypeCodeKey(), false));
        List list = search.getSearchList();
        vo.setList(list);
        vo.setComparatorName(ExportMasterExportCodeComparator.class.getName());
        vo.setAscending(false);
        this.sort();
        vo.setRadSelect("");
        if (list.size() == 0) {
            this.addNoSearchResultMessage();
        }
    }

    protected void sort() throws MospException {
        this.setVoList(this.sortList(this.getTransferredSortKey()));
    }

    protected void page() {
        this.setVoList(this.pageList());
    }

    protected void setExport() throws MospException {
        ExportListVo vo = (ExportListVo)this.mospParams.getVo();
        vo.setRadSelect(this.getTransferredCode());
    }

    protected void setVoList(List<? extends BaseDtoInterface> list) {
        ExportListVo vo = (ExportListVo)this.mospParams.getVo();
        String[] aryLblCode = new String[list.size()];
        String[] aryLblName = new String[list.size()];
        String[] aryLblTable = new String[list.size()];
        String[] aryLblType = new String[list.size()];
        String[] aryLblHeader = new String[list.size()];
        String[] aryLblInactivate = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ExportDtoInterface dto = (ExportDtoInterface)list.get(i);
            aryLblCode[i] = dto.getExportCode();
            aryLblName[i] = dto.getExportName();
            aryLblTable[i] = this.getCodeName(dto.getExportTable(), vo.getTableTypeCodeKey());
            aryLblType[i] = this.getCodeName(dto.getType(), "FileType");
            aryLblHeader[i] = this.getCodeName(dto.getHeader(), "HeaderType");
            aryLblInactivate[i] = this.getInactivateFlagName(dto.getInactivateFlag());
        }
        vo.setAryLblCode(aryLblCode);
        vo.setAryLblName(aryLblName);
        vo.setAryLblTable(aryLblTable);
        vo.setAryLblType(aryLblType);
        vo.setAryLblHeader(aryLblHeader);
        vo.setAryLblInactivate(aryLblInactivate);
    }

    protected void initExportListVoFields() {
        ExportListVo vo = (ExportListVo)this.mospParams.getVo();
        vo.setTxtSearchCode("");
        vo.setTxtSearchName("");
        vo.setPltSearchTable("");
        vo.setPltSearchHeader("");
        vo.setRadSelect("");
        vo.setPltSearchType("1");
        vo.setPltSearchInactivate(String.valueOf(0));
        vo.setAryPltTableType(this.getCodeArray(vo.getTableTypeCodeKey(), true));
        vo.setComparatorName(ExportMasterExportCodeComparator.class.getName());
    }
}

