/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.file.action;

import jp.mosp.framework.base.MospException;
import jp.mosp.platform.bean.file.HumanImportBeanInterface;
import jp.mosp.platform.bean.file.ImportBeanInterface;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.file.base.ImportListAction;
import jp.mosp.platform.file.vo.ImportListVo;

public class HumanImportListAction
extends ImportListAction {
    public static final String CMD_SHOW = "PF1310";
    public static final String CMD_SEARCH = "PF1312";
    public static final String CMD_RE_SHOW = "PF1313";
    public static final String CMD_EXECUTION = "PF1315";
    public static final String CMD_SORT = "PF1318";
    public static final String CMD_PAGE = "PF1319";
    public static final String CMD_TEMP_OUTPUT = "PF1386";

    public HumanImportListAction() {
        this.topicPathCommand = CMD_RE_SHOW;
    }

    public void action() throws MospException {
        if (this.mospParams.getCommand().equals(CMD_SHOW)) {
            this.prepareVo(false, false);
            this.show();
        } else if (this.mospParams.getCommand().equals(CMD_SEARCH)) {
            this.prepareVo();
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_RE_SHOW)) {
            this.prepareVo(true, false);
            this.search();
        } else if (this.mospParams.getCommand().equals(CMD_EXECUTION)) {
            this.prepareVo();
            this.execution();
        } else if (this.mospParams.getCommand().equals(CMD_SORT)) {
            this.prepareVo();
            this.sort();
        } else if (this.mospParams.getCommand().equals(CMD_PAGE)) {
            this.prepareVo();
            this.page();
        }
    }

    protected void setImportListInfo() {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        vo.setTableTypeCodeKey("HumanImportTableType");
        vo.setReShowCommand(CMD_RE_SHOW);
        vo.setSearchCommand(CMD_SEARCH);
        vo.setSortCommand(CMD_SORT);
        vo.setExecuteCommand(CMD_EXECUTION);
        this.setPageInfo(CMD_PAGE, this.getListLength());
    }

    protected void show() throws MospException {
        this.setImportListInfo();
        this.initImportListVoFields();
    }

    protected void execution() throws MospException {
        ImportListVo vo = (ImportListVo)this.mospParams.getVo();
        ImportDtoInterface importDto = this.reference().importRefer().findForKey(vo.getRadSelect());
        if (importDto == null) {
            this.addInsertFailedMessage();
            return;
        }
        ImportBeanInterface importBean = this.getImportBean(importDto);
        if (importBean == null) {
            this.addInsertFailedMessage();
            return;
        }
        int count = importBean.importFile(importDto, this.mospParams.getRequestFile("filImport"));
        if (this.mospParams.hasErrorMessage()) {
            this.addInsertFailedMessage();
            return;
        }
        this.commit();
        this.addImportMessage(count);
    }

    protected ImportBeanInterface getImportBean(ImportDtoInterface importDto) throws MospException {
        HumanImportBeanInterface importBean = null;
        if (importDto.getImportTable().equals("pfm_human")) {
            importBean = this.platform().humanImport();
        } else if (importDto.getImportTable().equals("pfm_user")) {
            importBean = this.platform().userImport();
        } else if (importDto.getImportTable().equals("pfm_section")) {
            importBean = this.platform().sectionImport();
        } else if (importDto.getImportTable().equals("pfa_user_password")) {
            importBean = this.platform().userPasswordImport();
        } else if (importDto.getImportTable().equals("unit_section")) {
            importBean = this.platform().unitSectionImport();
        } else if (importDto.getImportTable().equals("unit_person")) {
            importBean = this.platform().unitPersonImport();
        }
        return importBean;
    }
}

