/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.entity;

import java.util.Date;
import java.util.List;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.entity.EmployeeEntityInterface;

public class EmployeeEntity
implements EmployeeEntityInterface {
    protected String personalId;
    protected List<HumanDtoInterface> humanList;
    protected EntranceDtoInterface entranceDto;
    protected RetirementDtoInterface retirementDto;
    protected List<SuspensionDtoInterface> suspensionList;
    protected List<ConcurrentDtoInterface> concurrentList;

    public EmployeeEntity(String personalId) {
        this.personalId = personalId;
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public List<HumanDtoInterface> getHumanList() {
        return this.humanList;
    }

    public EntranceDtoInterface getEntranceDto() {
        return this.entranceDto;
    }

    public List<ConcurrentDtoInterface> getConcurrentList() {
        return this.concurrentList;
    }

    public List<SuspensionDtoInterface> getSuspensionList() {
        return this.suspensionList;
    }

    public RetirementDtoInterface getRetirementDto() {
        return this.retirementDto;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public void setHumanList(List<HumanDtoInterface> humanList) {
        this.humanList = humanList;
    }

    public void setEntranceDto(EntranceDtoInterface entranceDto) {
        this.entranceDto = entranceDto;
    }

    public void setConcurrentList(List<ConcurrentDtoInterface> concurrentList) {
        this.concurrentList = concurrentList;
    }

    public void setSuspensionList(List<SuspensionDtoInterface> suspensionList) {
        this.suspensionList = suspensionList;
    }

    public void setRetirementDto(RetirementDtoInterface retirementDto) {
        this.retirementDto = retirementDto;
    }

    public HumanDtoInterface getHumenDto(Date targetDate) {
        for (int i = this.humanList.size(); i > 0; --i) {
            HumanDtoInterface dto = (HumanDtoInterface)this.humanList.get(i - 1);
            if (targetDate.before(dto.getActivateDate())) continue;
            return dto;
        }
        return null;
    }

    public String getEmployeeCode(Date targetDate) {
        HumanDtoInterface dto = this.getHumenDto(targetDate);
        return dto == null ? "" : dto.getEmployeeCode();
    }

    public Date getRetirementDate() {
        return this.retirementDto == null ? null : this.retirementDto.getRetirementDate();
    }

    public SuspensionDtoInterface getSuspensionDto(Date targetDate) {
        for (SuspensionDtoInterface dto : this.suspensionList) {
            Date endDate = dto.getEndDate();
            if (endDate == null) {
                endDate = dto.getScheduleEndDate();
            }
            if (!DateUtility.isTermContain((Date)targetDate, (Date)dto.getStartDate(), (Date)endDate)) continue;
            return dto;
        }
        return null;
    }
}

