/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.system.impl;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.system.PositionDaoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmPositionDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PfmPositionDao
extends PlatformDao
implements PositionDaoInterface {
    public static final String TABLE = "pfm_position";
    public static final String COL_PFM_POSITION_ID = "pfm_position_id";
    public static final String COL_POSITION_CODE = "position_code";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_POSITION_NAME = "position_name";
    public static final String COL_POSITION_ABBR = "position_abbr";
    public static final String COL_POSITION_GRADE = "position_grade";
    public static final String COL_POSITION_LEVEL = "position_level";
    public static final String COL_INACTIVATE_FLAG = "inactivate_flag";
    public static final String KEY_1 = "pfm_position_id";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        PfmPositionDto dto = new PfmPositionDto();
        dto.setPfmPositionId(this.getLong("pfm_position_id"));
        dto.setPositionCode(this.getString("position_code"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setPositionName(this.getString("position_name"));
        dto.setPositionAbbr(this.getString("position_abbr"));
        dto.setPositionGrade(this.getInt("position_grade"));
        dto.setPositionLevel(this.getInt("position_level"));
        dto.setInactivateFlag(this.getInt("inactivate_flag"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<PositionDtoInterface> mappingAll() throws MospException {
        ArrayList<PositionDtoInterface> all = new ArrayList<PositionDtoInterface>();
        while (this.next()) {
            all.add(this.castDto((BaseDtoInterface)this.mapping()));
        }
        return all;
    }

    public List<PositionDtoInterface> findForActivateDate(Date targetDate, String[] rangeArray) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_position", "position_code", "activate_date"));
            sb.append(PfmPositionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.equal((String)"inactivate_flag", (long)0L));
            sb.append(this.getQueryForRange(rangeArray, "position_code"));
            sb.append(PfmPositionDao.getOrderByColumn((String)"position_code"));
            this.prepareStatement(sb.toString());
            this.index = this.setParamsForMaxActivateDate(this.index, targetDate, this.ps);
            this.index = this.setParamsForRange(this.index, rangeArray, targetDate, this.ps);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<PositionDtoInterface> findForHistory(String positionCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmPositionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.equal((String)"position_code"));
            sb.append(PfmPositionDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, positionCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public PositionDtoInterface findForInfo(String positionCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmPositionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.equal((String)"position_code"));
            sb.append(PfmPositionDao.and());
            sb.append("activate_date");
            sb.append(" <= ?");
            sb.append(PfmPositionDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, positionCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            PositionDtoInterface dto = null;
            if (this.rs.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            PositionDtoInterface positionDtoInterface = dto;
            return positionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<PositionDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            Date activateDate = (Date)param.get("activateDate");
            String positionCode = this.getSearchParam(param, "positionCode");
            String positionName = this.getSearchParam(param, "positionName");
            String positionAbbr = this.getSearchParam(param, "positionAbbr");
            String positionGrade = this.getSearchParam(param, "positionGrade");
            String positionLevel = this.getSearchParam(param, "positionLevel");
            String inactivateFlag = this.getSearchParam(param, "inactivateFlag");
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            if (activateDate != null) {
                sb.append(this.getQueryForMaxActivateDate("pfm_position", "position_code", "activate_date"));
            }
            sb.append(PfmPositionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.like((String)"position_code"));
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.like((String)"position_name"));
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.like((String)"position_abbr"));
            if (!positionGrade.isEmpty()) {
                sb.append(PfmPositionDao.and());
                sb.append(PfmPositionDao.equal((String)"position_grade"));
            }
            if (!positionLevel.isEmpty()) {
                sb.append(PfmPositionDao.and());
                sb.append(PfmPositionDao.equal((String)"position_level"));
            }
            if (!inactivateFlag.isEmpty()) {
                sb.append(PfmPositionDao.and());
                sb.append(PfmPositionDao.equal((String)"inactivate_flag"));
            }
            this.prepareStatement(sb.toString());
            if (activateDate != null) {
                this.index = this.setParamsForMaxActivateDate(this.index, activateDate, this.ps);
            }
            this.setParam(this.index++, PfmPositionDao.startWithParam((String)positionCode));
            this.setParam(this.index++, PfmPositionDao.containsParam((String)positionName));
            this.setParam(this.index++, PfmPositionDao.containsParam((String)positionAbbr));
            if (!positionGrade.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(positionGrade));
            }
            if (!positionLevel.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(positionLevel));
            }
            if (!inactivateFlag.isEmpty()) {
                this.setParam(this.index++, Integer.parseInt(inactivateFlag));
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            PositionDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmPositionId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            PositionDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmPositionId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        PositionDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPfmPositionId());
        this.setParam(this.index++, dto.getPositionCode());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getPositionName());
        this.setParam(this.index++, dto.getPositionAbbr());
        this.setParam(this.index++, dto.getPositionGrade());
        this.setParam(this.index++, dto.getPositionLevel());
        this.setParam(this.index++, dto.getInactivateFlag());
        this.setCommonParams(baseDto, isInsert);
    }

    public Map<String, Object> getParamsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    public PositionDtoInterface findForKey(String positionCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmPositionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.equal((String)"position_code"));
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, positionCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            PositionDtoInterface dto = null;
            if (this.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            PositionDtoInterface positionDtoInterface = dto;
            return positionDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public String getQueryForPositionName(String targetColumn) {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmPositionDao.and());
        sb.append(targetColumn);
        sb.append(PfmPositionDao.in());
        sb.append(PfmPositionDao.leftParenthesis());
        sb.append(PfmPositionDao.select());
        sb.append("position_code");
        sb.append(PfmPositionDao.from((String)"pfm_position"));
        sb.append(this.getQueryForMaxActivateDate("pfm_position", "position_code", "activate_date"));
        sb.append(PfmPositionDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmPositionDao.and());
        sb.append(PfmPositionDao.leftParenthesis());
        sb.append(PfmPositionDao.like((String)"position_name"));
        sb.append(PfmPositionDao.or());
        sb.append(PfmPositionDao.like((String)"position_abbr"));
        sb.append(PfmPositionDao.rightParenthesis());
        sb.append(PfmPositionDao.rightParenthesis());
        return sb.toString();
    }

    public int setParamsForPositionName(int index, String positionName, Date targetDate, PreparedStatement ps) throws MospException {
        int idx = index;
        this.setParam(idx++, targetDate, false, ps);
        this.setParam(idx++, PfmPositionDao.containsParam((String)positionName), ps);
        this.setParam(idx++, PfmPositionDao.containsParam((String)positionName), ps);
        return idx;
    }

    public StringBuffer getQueryForLowerPosition() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmPositionDao.select());
        sb.append("position_code");
        sb.append(PfmPositionDao.from((String)"pfm_position"));
        sb.append(this.getQueryForMaxActivateDate("pfm_position", "position_code", "activate_date"));
        sb.append(PfmPositionDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmPositionDao.and());
        if (this.hasLowGradeAdvantage()) {
            sb.append(PfmPositionDao.greater((String)"position_grade"));
        } else {
            sb.append(PfmPositionDao.less((String)"position_grade"));
        }
        return sb;
    }

    public String getQueryForRange(String[] rangeArray, String targetColumn) {
        StringBuffer sb = new StringBuffer();
        int rangeArrayLength = rangeArray.length;
        if (rangeArrayLength == 0) {
            return sb.toString();
        }
        String gradeCondition = PfmPositionDao.less();
        if (this.hasLowGradeAdvantage()) {
            gradeCondition = PfmPositionDao.greater();
        }
        sb.append(PfmPositionDao.and());
        sb.append(PfmPositionDao.leftParenthesis());
        for (int i = 0; i < rangeArrayLength; ++i) {
            sb.append(targetColumn);
            sb.append(PfmPositionDao.in());
            sb.append(PfmPositionDao.leftParenthesis());
            sb.append(PfmPositionDao.select());
            sb.append("position_code");
            sb.append(PfmPositionDao.from((String)"pfm_position"));
            sb.append(this.getQueryForMaxActivateDate("pfm_position", "position_code", "activate_date"));
            sb.append(PfmPositionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmPositionDao.and());
            sb.append("position_grade");
            sb.append(gradeCondition);
            sb.append(PfmPositionDao.leftParenthesis());
            sb.append(PfmPositionDao.select());
            sb.append("position_grade");
            sb.append(PfmPositionDao.from((String)"pfm_position"));
            sb.append(this.getQueryForMaxActivateDate("pfm_position", "position_code", "activate_date"));
            sb.append(PfmPositionDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmPositionDao.and());
            sb.append(PfmPositionDao.equal((String)"position_code"));
            sb.append(PfmPositionDao.rightParenthesis());
            sb.append(PfmPositionDao.rightParenthesis());
            if (i >= rangeArrayLength - 1) continue;
            sb.append(PfmPositionDao.or());
        }
        sb.append(PfmPositionDao.rightParenthesis());
        return sb.toString();
    }

    public int setParamsForRange(int index, String[] rangeArray, Date targetDate, PreparedStatement ps) throws MospException {
        int idx = index;
        for (String range : rangeArray) {
            this.setParam(idx++, targetDate, false, ps);
            this.setParam(idx++, targetDate, false, ps);
            this.setParam(idx++, range, ps);
        }
        return idx;
    }

    public String getQueryForApprover(String targetColumn) {
        String grade = this.mospParams.getApplicationProperty("ApproverPositionGrade");
        if (grade == null || grade.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(PfmPositionDao.and());
        sb.append(targetColumn);
        sb.append(PfmPositionDao.in());
        sb.append(PfmPositionDao.leftParenthesis());
        sb.append(PfmPositionDao.select());
        sb.append("position_code");
        sb.append(PfmPositionDao.from((String)"pfm_position"));
        sb.append(this.getQueryForMaxActivateDate("pfm_position", "position_code", "activate_date"));
        sb.append(PfmPositionDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmPositionDao.and());
        if (this.hasLowGradeAdvantage()) {
            sb.append(PfmPositionDao.less((String)"position_grade"));
        } else {
            sb.append(PfmPositionDao.greater((String)"position_grade"));
        }
        sb.append(PfmPositionDao.rightParenthesis());
        return sb.toString();
    }

    public int setParamsForApprover(int index, Date targetDate, PreparedStatement ps) throws MospException {
        int idx = index;
        String grade = this.mospParams.getApplicationProperty("ApproverPositionGrade");
        if (grade == null || grade.isEmpty()) {
            return idx;
        }
        this.setParam(idx++, targetDate, false, ps);
        this.setParam(idx++, this.mospParams.getApplicationProperty("ApproverPositionGrade", 0), ps);
        return idx;
    }

    public boolean hasLowGradeAdvantage() {
        String advantage = this.mospParams.getApplicationProperty("PositionGradeAdvantage");
        return advantage != null && advantage.equals("Low");
    }

    protected PositionDtoInterface castDto(BaseDtoInterface baseDto) {
        return (PositionDtoInterface)baseDto;
    }
}

