/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.human.impl;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.impl.PfmHumanDto;

/*
 * Exception performing whole class analysis ignored.
 */
public class PfmHumanDao
extends PlatformDao
implements HumanDaoInterface {
    public static final String TABLE = "pfm_human";
    public static final String COL_PFM_HUMAN_ID = "pfm_human_id";
    public static final String COL_PERSONAL_ID = "personal_id";
    public static final String COL_ACTIVATE_DATE = "activate_date";
    public static final String COL_EMPLOYEE_CODE = "employee_code";
    public static final String COL_LAST_NAME = "last_name";
    public static final String COL_FIRST_NAME = "first_name";
    public static final String COL_LAST_KANA = "last_kana";
    public static final String COL_FIRST_KANA = "first_kana";
    public static final String COL_EMPLOYMENT_CONTRACT_CODE = "employment_contract_code";
    public static final String COL_SECTION_CODE = "section_code";
    public static final String COL_POSITION_CODE = "position_code";
    public static final String COL_WORK_PLACE_CODE = "work_place_code";
    public static final String COL_MAIL = "mail";
    public static final String KEY_1 = "pfm_human_id";
    public static final String SEQUENCE = "pfm_human_personal_id_seq";

    public void initDao() {
    }

    public BaseDto mapping() throws MospException {
        PfmHumanDto dto = new PfmHumanDto();
        dto.setPfmHumanId(this.getLong("pfm_human_id"));
        dto.setPersonalId(this.getString("personal_id"));
        dto.setActivateDate(this.getDate("activate_date"));
        dto.setEmployeeCode(this.getString("employee_code"));
        dto.setLastName(this.getString("last_name"));
        dto.setFirstName(this.getString("first_name"));
        dto.setLastKana(this.getString("last_kana"));
        dto.setFirstKana(this.getString("first_kana"));
        dto.setEmploymentContractCode(this.getString("employment_contract_code"));
        dto.setSectionCode(this.getString("section_code"));
        dto.setPositionCode(this.getString("position_code"));
        dto.setWorkPlaceCode(this.getString("work_place_code"));
        dto.setMail(this.getString("mail"));
        this.mappingCommonInfo((BaseDto)dto);
        return dto;
    }

    public List<HumanDtoInterface> mappingAll() throws MospException {
        ArrayList<HumanDtoInterface> all = new ArrayList<HumanDtoInterface>();
        while (this.next()) {
            all.add(this.castDto((BaseDtoInterface)this.mapping()));
        }
        return all;
    }

    public HumanDtoInterface findForKey(String personalId, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmHumanDao.and());
            sb.append(PfmHumanDao.equal((String)"personal_id"));
            sb.append(PfmHumanDao.and());
            sb.append(PfmHumanDao.equal((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            HumanDtoInterface dto = null;
            if (this.rs.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            HumanDtoInterface humanDtoInterface = dto;
            return humanDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HumanDtoInterface> findForActivateDate(Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = new StringBuffer();
            sb.append(this.getSelectQuery(this.getClass()));
            sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmHumanDao.getOrderByColumn((String)"employee_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public HumanDtoInterface findForEmployeeCode(String employeeCode, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmHumanDao.and());
            sb.append(PfmHumanDao.equal((String)"employee_code"));
            sb.append(PfmHumanDao.and());
            sb.append(PfmHumanDao.lessEqual((String)"activate_date"));
            sb.append(PfmHumanDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.index = this.setParamsForMaxActivateDate(this.index, activateDate, this.ps);
            this.setParam(this.index++, employeeCode);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            HumanDtoInterface dto = null;
            if (this.rs.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            HumanDtoInterface humanDtoInterface = dto;
            return humanDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HumanDtoInterface> findForEmployeeCode(String employeeCode) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmHumanDao.and());
            sb.append(PfmHumanDao.equal((String)"employee_code"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, employeeCode);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HumanDtoInterface> findForHistory(String personalId) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmHumanDao.and());
            sb.append(PfmHumanDao.equal((String)"personal_id"));
            sb.append(PfmHumanDao.getOrderByColumn((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public HumanDtoInterface findForInfo(String personalId, Date activateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmHumanDao.and());
            sb.append(PfmHumanDao.equal((String)"personal_id"));
            sb.append(PfmHumanDao.and());
            sb.append(PfmHumanDao.lessEqual((String)"activate_date"));
            sb.append(PfmHumanDao.getOrderByColumnDescLimit1((String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, personalId);
            this.setParam(this.index++, activateDate);
            this.executeQuery();
            HumanDtoInterface dto = null;
            if (this.rs.next()) {
                dto = this.castDto((BaseDtoInterface)this.mapping());
            }
            HumanDtoInterface humanDtoInterface = dto;
            return humanDtoInterface;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public Map<String, String> findForEmployeeCodeMap(Date activateDate, String ... personalIds) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = new StringBuffer();
            sb.append(PfmHumanDao.select());
            sb.append("personal_id").append(",");
            sb.append("employee_code");
            sb.append(PfmHumanDao.from((String)"pfm_human"));
            sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmHumanDao.in((String)"personal_id", (int)personalIds.length));
            this.prepareStatement(sb.toString());
            this.setParam(this.index++, activateDate);
            this.setParamsIn(personalIds);
            this.executeQuery();
            HashMap<String, String> map = new HashMap<String, String>();
            while (this.next()) {
                map.put(this.getString("personal_id"), this.getString("employee_code"));
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HumanDtoInterface> findAll() throws MospException {
        try {
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(PfmHumanDao.getOrderByColumn((String)"employee_code", (String)"activate_date"));
            this.prepareStatement(sb.toString());
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public List<HumanDtoInterface> findForTerm(Date fromActivateDate, Date toActivateDate) throws MospException {
        try {
            this.index = 1;
            StringBuffer sb = this.getSelectQuery(this.getClass());
            sb.append(PfmHumanDao.where());
            sb.append(this.deleteFlagOff());
            if (fromActivateDate != null) {
                sb.append(PfmHumanDao.and());
                sb.append(PfmHumanDao.greater((String)"activate_date"));
            }
            if (toActivateDate != null) {
                sb.append(PfmHumanDao.and());
                sb.append(PfmHumanDao.less((String)"activate_date"));
            }
            sb.append(PfmHumanDao.getOrderByColumn((String)"employee_code", (String)"activate_date"));
            this.prepareStatement(sb.toString());
            if (fromActivateDate != null) {
                this.setParam(this.index++, fromActivateDate);
            }
            if (toActivateDate != null) {
                this.setParam(this.index++, toActivateDate);
            }
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public long nextPersonalId() throws MospException {
        return this.nextValue("pfm_human_personal_id_seq");
    }

    public int update(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getUpdateQuery(this.getClass()));
            this.setParams(baseDto, false);
            HumanDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmHumanId());
            this.executeUpdate();
            this.chkUpdate(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public int delete(BaseDtoInterface baseDto) throws MospException {
        try {
            this.index = 1;
            this.prepareStatement(this.getDeleteQuery(this.getClass()));
            HumanDtoInterface dto = this.castDto(baseDto);
            this.setParam(this.index++, dto.getPfmHumanId());
            this.executeUpdate();
            this.chkDelete(1);
            int n = this.cnt;
            return n;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
        HumanDtoInterface dto = this.castDto(baseDto);
        this.setParam(this.index++, dto.getPfmHumanId());
        this.setParam(this.index++, dto.getPersonalId());
        this.setParam(this.index++, dto.getActivateDate());
        this.setParam(this.index++, dto.getEmployeeCode());
        this.setParam(this.index++, dto.getLastName());
        this.setParam(this.index++, dto.getFirstName());
        this.setParam(this.index++, dto.getLastKana());
        this.setParam(this.index++, dto.getFirstKana());
        this.setParam(this.index++, dto.getEmploymentContractCode());
        this.setParam(this.index++, dto.getSectionCode());
        this.setParam(this.index++, dto.getPositionCode());
        this.setParam(this.index++, dto.getWorkPlaceCode());
        this.setParam(this.index++, dto.getMail());
        this.setCommonParams(baseDto, isInsert);
    }

    public String getQueryForEmployeeCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmHumanDao.select());
        sb.append("personal_id");
        sb.append(PfmHumanDao.from((String)"pfm_human"));
        sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
        sb.append(PfmHumanDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmHumanDao.and());
        sb.append(PfmHumanDao.like((String)"employee_code"));
        return sb.toString();
    }

    protected String getQueryForEmployeeName() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmHumanDao.and());
        sb.append(PfmHumanDao.leftParenthesis());
        sb.append(PfmHumanDao.like((String)"last_name"));
        sb.append(PfmHumanDao.or());
        sb.append(PfmHumanDao.like((String)"first_name"));
        sb.append(PfmHumanDao.or());
        sb.append(PfmHumanDao.like((String)PfmHumanDao.concat((String)"last_name", (String)"first_name")));
        sb.append(PfmHumanDao.or());
        sb.append(PfmHumanDao.like((String)PfmHumanDao.concat((String)"last_name", (String)PfmHumanDao.blank(), (String)"first_name")));
        sb.append(PfmHumanDao.rightParenthesis());
        return sb.toString();
    }

    protected int setParamsForEmployeeName(int index, String employeeName, PreparedStatement ps) throws MospException {
        int idx = index;
        this.setParam(idx++, PfmHumanDao.containsParam((String)employeeName), ps);
        this.setParam(idx++, PfmHumanDao.containsParam((String)employeeName), ps);
        this.setParam(idx++, PfmHumanDao.containsParam((String)employeeName), ps);
        this.setParam(idx++, PfmHumanDao.containsParam((String)employeeName), ps);
        return idx;
    }

    public String getQueryForEmployeeName(String targetColumn) {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmHumanDao.and());
        sb.append(targetColumn);
        sb.append(PfmHumanDao.in());
        sb.append(PfmHumanDao.leftParenthesis());
        sb.append(PfmHumanDao.select());
        sb.append("personal_id");
        sb.append(PfmHumanDao.from((String)"pfm_human"));
        sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
        sb.append(PfmHumanDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(this.getQueryForEmployeeName());
        sb.append(PfmHumanDao.rightParenthesis());
        return sb.toString();
    }

    public int setParamsForEmployeeName(int index, String employeeName, Date targetDate, PreparedStatement ps) throws MospException {
        int idx = index;
        this.setParam(idx++, targetDate, false, ps);
        idx = this.setParamsForEmployeeName(idx, employeeName, ps);
        return idx;
    }

    public String getQueryForWorkPlaceCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmHumanDao.select());
        sb.append("personal_id");
        sb.append(PfmHumanDao.from((String)"pfm_human"));
        sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
        sb.append(PfmHumanDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmHumanDao.and());
        sb.append(PfmHumanDao.equal((String)"work_place_code"));
        return sb.toString();
    }

    public String getQueryForEmploymentContractCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmHumanDao.select());
        sb.append("personal_id");
        sb.append(PfmHumanDao.from((String)"pfm_human"));
        sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
        sb.append(PfmHumanDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmHumanDao.and());
        sb.append(PfmHumanDao.equal((String)"employment_contract_code"));
        return sb.toString();
    }

    public String getQueryForSectionCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmHumanDao.select());
        sb.append("personal_id");
        sb.append(PfmHumanDao.from((String)"pfm_human"));
        sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
        sb.append(PfmHumanDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmHumanDao.and());
        sb.append(PfmHumanDao.equal((String)"section_code"));
        return sb.toString();
    }

    public String getQueryForSectionName() throws MospException {
        SectionDaoInterface sectionDao = (SectionDaoInterface)this.loadDao(SectionDaoInterface.class);
        StringBuffer sb = new StringBuffer();
        sb.append(PfmHumanDao.select());
        sb.append("personal_id");
        sb.append(PfmHumanDao.from((String)"pfm_human"));
        sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
        sb.append(PfmHumanDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmHumanDao.and());
        sb.append("section_code");
        sb.append(PfmHumanDao.in());
        sb.append(PfmHumanDao.leftParenthesis());
        sb.append(sectionDao.getQueryForSectionName());
        sb.append(PfmHumanDao.rightParenthesis());
        return sb.toString();
    }

    public String getQueryForPositionCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(PfmHumanDao.select());
        sb.append("personal_id");
        sb.append(PfmHumanDao.from((String)"pfm_human"));
        sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
        sb.append(PfmHumanDao.where());
        sb.append(this.deleteFlagOff());
        sb.append(PfmHumanDao.and());
        sb.append(PfmHumanDao.equal((String)"position_code"));
        return sb.toString();
    }

    protected String getQueryForRange(String[] rangeArray, String targetColumn) {
        StringBuffer sb = new StringBuffer();
        int rangeArrayLength = rangeArray.length;
        if (rangeArrayLength == 0) {
            return sb.toString();
        }
        sb.append(PfmHumanDao.and());
        sb.append(PfmHumanDao.leftParenthesis());
        for (int i = 0; i < rangeArrayLength; ++i) {
            sb.append(PfmHumanDao.equal((String)targetColumn));
            if (i >= rangeArrayLength - 1) continue;
            sb.append(PfmHumanDao.or());
        }
        sb.append(PfmHumanDao.rightParenthesis());
        return sb.toString();
    }

    protected int setParamsForRange(int index, String[] rangeArray, PreparedStatement ps) throws MospException {
        int idx = index;
        for (String range : rangeArray) {
            this.setParam(idx++, range, ps);
        }
        return idx;
    }

    protected HumanDtoInterface castDto(BaseDtoInterface baseDto) {
        return (HumanDtoInterface)baseDto;
    }
}

