/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.dao.human.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.platform.dao.human.ConcurrentDaoInterface;
import jp.mosp.platform.dao.human.EntranceDaoInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dao.human.HumanHistoryDaoInterface;
import jp.mosp.platform.dao.human.HumanSearchDaoInterface;
import jp.mosp.platform.dao.human.RetirementDaoInterface;
import jp.mosp.platform.dao.human.SuspensionDaoInterface;
import jp.mosp.platform.dao.human.impl.PfmHumanDao;
import jp.mosp.platform.dao.system.EmploymentContractDaoInterface;
import jp.mosp.platform.dao.system.PositionDaoInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dao.system.WorkPlaceDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;

/*
 * Exception performing whole class analysis ignored.
 */
public class HumanSearchDao
extends PfmHumanDao
implements HumanSearchDaoInterface {
    HumanDaoInterface humanDao;
    HumanHistoryDaoInterface humanHistoryDao;
    SectionDaoInterface sectionDao;
    PositionDaoInterface positionDao;
    ConcurrentDaoInterface concurrentDao;
    SuspensionDaoInterface suspensionDao;
    RetirementDaoInterface retirementDao;
    EntranceDaoInterface entranceDao;
    UserMasterDaoInterface userDao;
    private Date targetDate;
    private String employeeCode;
    private String fromEmployeeCode;
    private String toEmployeeCode;
    private String employeeCodeType;
    private String lastName;
    private String lastNameType;
    private String firstName;
    private String firstNameType;
    private String lastKana;
    private String lastKanaType;
    private String firstKana;
    private String firstKanaType;
    private String employeeName;
    private String workPlaceCode;
    private String employmentContractCode;
    private String sectionCode;
    private boolean needLowerSection;
    private String positionCode;
    private boolean needConcurrent;
    private String employeeState;
    private String unnecessaryPersonalId;
    private boolean needApproverRole;
    private Date startDate;
    private Date endDate;

    public List<HumanDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
        try {
            this.setDaoInstances();
            this.setSearchParams(param);
            this.prepareStatement(this.getQueryForSearch(param));
            this.setParamsForSearch(param);
            this.executeQuery();
            List list = this.mappingAll();
            return list;
        }
        catch (Throwable e) {
            throw new MospException(e);
        }
        finally {
            this.releaseResultSet();
            this.releasePreparedStatement();
        }
    }

    public Map<String, Object> getParamsMap() {
        return new HashMap<String, Object>();
    }

    protected void setDaoInstances() throws MospException {
        this.humanDao = (HumanDaoInterface)this.loadDao(HumanDaoInterface.class);
        this.humanHistoryDao = (HumanHistoryDaoInterface)this.loadDao(HumanHistoryDaoInterface.class);
        this.sectionDao = (SectionDaoInterface)this.loadDao(SectionDaoInterface.class);
        this.positionDao = (PositionDaoInterface)this.loadDao(PositionDaoInterface.class);
        this.concurrentDao = (ConcurrentDaoInterface)this.loadDao(ConcurrentDaoInterface.class);
        this.suspensionDao = (SuspensionDaoInterface)this.loadDao(SuspensionDaoInterface.class);
        this.retirementDao = (RetirementDaoInterface)this.loadDao(RetirementDaoInterface.class);
        this.userDao = (UserMasterDaoInterface)this.loadDao(UserMasterDaoInterface.class);
        this.entranceDao = (EntranceDaoInterface)this.loadDao(EntranceDaoInterface.class);
    }

    protected void setSearchParams(Map<String, Object> param) {
        this.targetDate = (Date)param.get("targetDate");
        this.employeeCode = this.getSearchParam(param, "employeeCode");
        this.fromEmployeeCode = this.getSearchParam(param, "fromEmployeeCode");
        this.toEmployeeCode = this.getSearchParam(param, "toEmployeeCode");
        this.employeeCodeType = this.getSearchParam(param, "employeeCodeType");
        this.lastName = this.getSearchParam(param, "lastName");
        this.lastNameType = this.getSearchParam(param, "lastNameType");
        this.firstName = this.getSearchParam(param, "firstName");
        this.firstNameType = this.getSearchParam(param, "firstNameType");
        this.lastKana = this.getSearchParam(param, "lastKana");
        this.lastKanaType = this.getSearchParam(param, "lastKanaType");
        this.firstKana = this.getSearchParam(param, "firstKana");
        this.firstKanaType = this.getSearchParam(param, "firstKanaType");
        this.employeeName = this.getSearchParam(param, "employeeName");
        this.workPlaceCode = this.getSearchParam(param, "workPlaceCode");
        this.employmentContractCode = this.getSearchParam(param, "employmentContractCode");
        this.sectionCode = this.getSearchParam(param, "sectionCode");
        this.needLowerSection = this.getSearchBoolParam(param, "needLowerSection");
        this.positionCode = this.getSearchParam(param, "positionCode");
        this.needConcurrent = this.getSearchBoolParam(param, "needConcurrent");
        this.employeeState = this.getSearchParam(param, "employeeState");
        this.unnecessaryPersonalId = this.getSearchParam(param, "unnecessary");
        this.needApproverRole = this.getSearchBoolParam(param, "needApproverRole");
        this.startDate = (Date)param.get("startDate");
        this.endDate = (Date)param.get("endDate");
    }

    protected String getQueryForSearch(Map<String, Object> param) throws MospException {
        StringBuffer sb = new StringBuffer(this.getSelectQuery(this.getClass()));
        sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
        sb.append(HumanSearchDao.where());
        sb.append(this.deleteFlagOff());
        if (!this.employeeCode.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(this.getSubQueryCondition((Object)this.employeeCodeType, "employee_code"));
        }
        if (!this.fromEmployeeCode.isEmpty() || !this.toEmployeeCode.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(HumanSearchDao.leftParenthesis());
            if (!this.fromEmployeeCode.isEmpty() && !this.toEmployeeCode.isEmpty()) {
                sb.append(HumanSearchDao.greaterEqual((String)"employee_code"));
                sb.append(HumanSearchDao.and());
                sb.append(HumanSearchDao.lessEqual((String)"employee_code"));
            }
            if (!this.fromEmployeeCode.isEmpty() && this.toEmployeeCode.isEmpty()) {
                sb.append(HumanSearchDao.greaterEqual((String)"employee_code"));
            }
            if (this.fromEmployeeCode.isEmpty() && !this.toEmployeeCode.isEmpty()) {
                sb.append(HumanSearchDao.lessEqual((String)"employee_code"));
            }
            sb.append(HumanSearchDao.rightParenthesis());
        }
        if (!this.employeeName.isEmpty()) {
            sb.append(this.getQueryForEmployeeName());
        }
        if (!this.lastName.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(this.getSubQueryCondition((Object)this.lastNameType, "last_name"));
        }
        if (!this.lastKana.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(this.getSubQueryCondition((Object)this.lastKanaType, "last_kana"));
        }
        if (!this.firstName.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(this.getSubQueryCondition((Object)this.firstNameType, "first_name"));
        }
        if (!this.firstKana.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(this.getSubQueryCondition((Object)this.firstKanaType, "first_kana"));
        }
        if (!this.workPlaceCode.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(HumanSearchDao.equal((String)"work_place_code"));
        }
        if (!this.employmentContractCode.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(HumanSearchDao.equal((String)"employment_contract_code"));
        }
        if (!this.sectionCode.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(HumanSearchDao.leftParenthesis());
            if (this.needLowerSection) {
                sb.append(this.sectionDao.getQueryForLowerSection("section_code"));
            } else {
                sb.append(HumanSearchDao.equal((String)"section_code"));
            }
            if (this.needConcurrent) {
                sb.append(HumanSearchDao.or());
                sb.append(this.concurrentDao.getQueryForSection("personal_id", this.needLowerSection));
            }
            sb.append(HumanSearchDao.rightParenthesis());
        }
        if (!this.positionCode.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(HumanSearchDao.equal((String)"position_code"));
            if (this.needConcurrent) {
                sb.append(HumanSearchDao.or());
                sb.append(this.concurrentDao.getQueryForPosition("personal_id"));
            }
            sb.append(HumanSearchDao.rightParenthesis());
        }
        if (!this.unnecessaryPersonalId.isEmpty()) {
            sb.append(HumanSearchDao.and());
            sb.append(HumanSearchDao.notEqual((String)"personal_id"));
        }
        if (this.needApproverRole) {
            sb.append(this.userDao.getQueryForApprover("personal_id"));
            sb.append(this.positionDao.getQueryForApprover("position_code"));
        }
        sb.append(this.getQueryForEmployeeState());
        sb.append(this.getQueryForRange(param, "personal_id"));
        sb.append(this.getAdditionalQuery(param));
        sb.append(this.getOrderByColumnForParam(param));
        return sb.toString();
    }

    protected void setParamsForSearch(Map<String, Object> param) throws MospException {
        this.index = 1;
        this.index = this.setParamsForMaxActivateDate(this.index, this.targetDate, this.ps);
        if (!this.employeeCode.isEmpty()) {
            this.setParam(this.index++, this.getSetParamCondition((Object)this.employeeCodeType, this.employeeCode));
        }
        if (!this.fromEmployeeCode.isEmpty() || !this.toEmployeeCode.isEmpty()) {
            if (!this.fromEmployeeCode.isEmpty() && !this.toEmployeeCode.isEmpty()) {
                this.setParam(this.index++, this.fromEmployeeCode);
                this.setParam(this.index++, this.toEmployeeCode);
            }
            if (!this.fromEmployeeCode.isEmpty() && this.toEmployeeCode.isEmpty()) {
                this.setParam(this.index++, this.fromEmployeeCode);
            }
            if (this.fromEmployeeCode.isEmpty() && !this.toEmployeeCode.isEmpty()) {
                this.setParam(this.index++, this.toEmployeeCode);
            }
        }
        if (!this.employeeName.isEmpty()) {
            this.index = this.setParamsForEmployeeName(this.index, this.employeeName, this.ps);
        }
        if (!this.lastName.isEmpty()) {
            this.setParam(this.index++, this.getSetParamCondition((Object)this.lastNameType, this.lastName));
        }
        if (!this.lastKana.isEmpty()) {
            this.setParam(this.index++, this.getSetParamCondition((Object)this.lastKanaType, this.lastKana));
        }
        if (!this.firstName.isEmpty()) {
            this.setParam(this.index++, this.getSetParamCondition((Object)this.firstNameType, this.firstName));
        }
        if (!this.firstKana.isEmpty()) {
            this.setParam(this.index++, this.getSetParamCondition((Object)this.firstKanaType, this.firstKana));
        }
        if (!this.workPlaceCode.isEmpty()) {
            this.setParam(this.index++, this.workPlaceCode);
        }
        if (!this.employmentContractCode.isEmpty()) {
            this.setParam(this.index++, this.employmentContractCode);
        }
        if (!this.sectionCode.isEmpty()) {
            if (this.needLowerSection) {
                this.index = this.sectionDao.setParamsForLowerSection(this.index, this.sectionCode, this.targetDate, this.ps);
            } else {
                this.setParam(this.index++, this.sectionCode);
            }
            if (this.needConcurrent) {
                this.index = this.concurrentDao.setParamsForSection(this.index, this.sectionCode, this.targetDate, this.needLowerSection, this.ps);
            }
        }
        if (!this.positionCode.isEmpty()) {
            this.setParam(this.index++, this.positionCode);
            if (this.needConcurrent) {
                this.index = this.concurrentDao.setParamsForPosition(this.index, this.positionCode, this.targetDate, this.ps);
            }
        }
        if (!this.unnecessaryPersonalId.isEmpty()) {
            this.setParam(this.index++, this.unnecessaryPersonalId);
        }
        if (this.needApproverRole) {
            this.index = this.userDao.setParamsForApprover(this.index, this.targetDate, this.ps);
            this.index = this.positionDao.setParamsForApprover(this.index, this.targetDate, this.ps);
        }
        this.setParamsForEmployeeState();
        this.setParamsForRange(param);
    }

    protected String getQueryForEmployeeState() {
        StringBuffer sb = new StringBuffer();
        if (this.employeeState.isEmpty()) {
            return sb.toString();
        }
        if (this.employeeState.equals("presence")) {
            sb.append(HumanSearchDao.and());
            sb.append("personal_id");
            sb.append(HumanSearchDao.in());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(this.entranceDao.getQueryForEntrancedPerson());
            sb.append(HumanSearchDao.rightParenthesis());
            sb.append(HumanSearchDao.and());
            sb.append("personal_id");
            sb.append(HumanSearchDao.notIn());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(this.retirementDao.getQueryForRetiredPerson());
            sb.append(HumanSearchDao.rightParenthesis());
            sb.append(HumanSearchDao.and());
            sb.append("personal_id");
            sb.append(HumanSearchDao.notIn());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(this.suspensionDao.getQueryForSuspendedPerson());
            sb.append(HumanSearchDao.rightParenthesis());
        } else if (this.employeeState.equals("suspend")) {
            sb.append(HumanSearchDao.and());
            sb.append("personal_id");
            sb.append(HumanSearchDao.in());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(this.suspensionDao.getQueryForSuspendedPerson());
            sb.append(HumanSearchDao.rightParenthesis());
        } else if (this.employeeState.equals("retire")) {
            sb.append(HumanSearchDao.and());
            sb.append("personal_id");
            sb.append(HumanSearchDao.in());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(this.retirementDao.getQueryForRetiredPerson());
            sb.append(HumanSearchDao.rightParenthesis());
        }
        return sb.toString();
    }

    protected void setParamsForEmployeeState() throws MospException {
        if (this.employeeState.isEmpty()) {
            return;
        }
        if (this.employeeState.equals("presence")) {
            if (this.startDate != null && this.endDate != null) {
                this.setParam(this.index++, this.endDate);
                this.setParam(this.index++, this.startDate);
                this.setParam(this.index++, this.startDate);
                this.setParam(this.index++, this.endDate);
                this.setParam(this.index++, this.endDate);
            } else {
                this.setParam(this.index++, this.targetDate);
                this.setParam(this.index++, this.targetDate);
                this.setParam(this.index++, this.targetDate);
                this.setParam(this.index++, this.targetDate);
                this.setParam(this.index++, this.targetDate);
            }
        } else if (this.employeeState.equals("suspend")) {
            if (this.startDate != null && this.endDate != null) {
                this.setParam(this.index++, this.startDate);
                this.setParam(this.index++, this.endDate);
                this.setParam(this.index++, this.endDate);
            } else {
                this.setParam(this.index++, this.targetDate);
                this.setParam(this.index++, this.targetDate);
                this.setParam(this.index++, this.targetDate);
            }
        } else if (this.employeeState.equals("retire")) {
            if (this.endDate != null) {
                this.setParam(this.index++, this.startDate);
            } else {
                this.setParam(this.index++, this.targetDate);
            }
        }
    }

    protected String getQueryForRange(Map<String, Object> param, String targetColumn) throws MospException {
        StringBuffer sb = new StringBuffer();
        if (!this.isRangeEmployeeSetted(param) && !this.isRangeMasterSetted(param)) {
            return sb.toString();
        }
        WorkPlaceDaoInterface workPlaceDao = (WorkPlaceDaoInterface)this.loadDao(WorkPlaceDaoInterface.class);
        String[] rangeWorkPlace = this.getSearchParams(param, "rangeWorkPlace");
        EmploymentContractDaoInterface employmentContractDao = (EmploymentContractDaoInterface)this.loadDao(EmploymentContractDaoInterface.class);
        String[] rangeEmploymentContract = this.getSearchParams(param, "rangeEmploymentContract");
        String[] rangeSection = this.getSearchParams(param, "rangeSection");
        PositionDaoInterface positionDao = (PositionDaoInterface)this.loadDao(PositionDaoInterface.class);
        String[] rangePosition = this.getSearchParams(param, "rangePosition");
        String[] rangeEmployee = this.getSearchParams(param, "rangeEmployee");
        String[][][] rangeConcurrent = this.getSearchArrayParams(param, "rangeConcurrent");
        sb.append(HumanSearchDao.and());
        sb.append(HumanSearchDao.leftParenthesis());
        if (this.isRangeEmployeeSetted(param)) {
            sb.append(targetColumn);
            sb.append(HumanSearchDao.in());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(HumanSearchDao.select());
            sb.append("personal_id");
            sb.append(HumanSearchDao.from((String)"pfm_human"));
            sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
            sb.append(HumanSearchDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(this.getQueryForRange(rangeEmployee, "personal_id"));
            sb.append(HumanSearchDao.rightParenthesis());
        }
        if (this.isRangeMasterSetted(param)) {
            if (this.isRangeEmployeeSetted(param)) {
                sb.append(HumanSearchDao.or());
            }
            sb.append(targetColumn);
            sb.append(HumanSearchDao.in());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(HumanSearchDao.select());
            sb.append("personal_id");
            sb.append(HumanSearchDao.from((String)"pfm_human"));
            sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
            sb.append(HumanSearchDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(workPlaceDao.getQueryForRange(rangeWorkPlace, "work_place_code"));
            sb.append(employmentContractDao.getQueryForRange(rangeEmploymentContract, "employment_contract_code"));
            sb.append(this.sectionDao.getQueryForRange(rangeSection, "section_code"));
            sb.append(positionDao.getQueryForRange(rangePosition, "position_code"));
            sb.append(HumanSearchDao.rightParenthesis());
        }
        for (String[][] concurrent : rangeConcurrent) {
            sb.append(HumanSearchDao.or());
            sb.append(targetColumn);
            sb.append(HumanSearchDao.in());
            sb.append(HumanSearchDao.leftParenthesis());
            sb.append(HumanSearchDao.select());
            sb.append("personal_id");
            sb.append(HumanSearchDao.from((String)"pfm_human"));
            sb.append(this.getQueryForMaxActivateDate("pfm_human", "personal_id", "activate_date"));
            sb.append(HumanSearchDao.where());
            sb.append(this.deleteFlagOff());
            sb.append(this.sectionDao.getQueryForRange(concurrent[0], "section_code"));
            sb.append(positionDao.getQueryForRange(concurrent[1], "position_code"));
            sb.append(HumanSearchDao.rightParenthesis());
        }
        sb.append(HumanSearchDao.rightParenthesis());
        return sb.toString();
    }

    protected void setParamsForRange(Map<String, Object> param) throws MospException {
        if (!this.isRangeEmployeeSetted(param) && !this.isRangeMasterSetted(param)) {
            return;
        }
        WorkPlaceDaoInterface workPlaceDao = (WorkPlaceDaoInterface)this.loadDao(WorkPlaceDaoInterface.class);
        String[] rangeWorkPlace = this.getSearchParams(param, "rangeWorkPlace");
        EmploymentContractDaoInterface employmentContractDao = (EmploymentContractDaoInterface)this.loadDao(EmploymentContractDaoInterface.class);
        String[] rangeEmploymentContract = this.getSearchParams(param, "rangeEmploymentContract");
        String[] rangeSection = this.getSearchParams(param, "rangeSection");
        PositionDaoInterface positionDao = (PositionDaoInterface)this.loadDao(PositionDaoInterface.class);
        String[] rangePosition = this.getSearchParams(param, "rangePosition");
        String[] rangeEmployee = this.getSearchParams(param, "rangeEmployee");
        String[][][] rangeConcurrent = this.getSearchArrayParams(param, "rangeConcurrent");
        if (this.isRangeEmployeeSetted(param)) {
            this.index = this.setParamsForMaxActivateDate(this.index, this.targetDate, this.ps);
            this.index = this.setParamsForRange(this.index, rangeEmployee, this.ps);
        }
        if (this.isRangeMasterSetted(param)) {
            this.index = this.setParamsForMaxActivateDate(this.index, this.targetDate, this.ps);
            this.index = workPlaceDao.setParamsForRange(this.index, rangeWorkPlace, this.ps);
            this.index = employmentContractDao.setParamsForRange(this.index, rangeEmploymentContract, this.ps);
            this.index = this.sectionDao.setParamsForRange(this.index, rangeSection, this.targetDate, this.ps);
            this.index = positionDao.setParamsForRange(this.index, rangePosition, this.targetDate, this.ps);
        }
        for (String[][] concurrent : rangeConcurrent) {
            this.index = this.setParamsForMaxActivateDate(this.index, this.targetDate, this.ps);
            this.index = this.sectionDao.setParamsForRange(this.index, concurrent[0], this.targetDate, this.ps);
            this.index = positionDao.setParamsForRange(this.index, concurrent[1], this.targetDate, this.ps);
        }
    }

    protected String[][][] getSearchArrayParams(Map<String, Object> searchParams, String key) {
        Object obj = searchParams.get(key);
        if (obj instanceof String[][][]) {
            return (String[][][])obj;
        }
        return new String[0][][];
    }

    protected boolean isRangeMasterSetted(Map<String, Object> param) {
        if (this.getSearchParams(param, "rangeWorkPlace").length > 0) {
            return true;
        }
        if (this.getSearchParams(param, "rangeEmploymentContract").length > 0) {
            return true;
        }
        if (this.getSearchParams(param, "rangeSection").length > 0) {
            return true;
        }
        return this.getSearchParams(param, "rangePosition").length > 0;
    }

    protected boolean isRangeEmployeeSetted(Map<String, Object> param) {
        return this.getSearchParams(param, "rangeEmployee").length > 0;
    }

    protected String getSubQueryCondition(Object queryType, String column) {
        String retString = "";
        if (queryType.equals("forward")) {
            retString = HumanSearchDao.like((String)column);
        } else if (queryType.equals("broad")) {
            retString = HumanSearchDao.like((String)column);
        } else if (queryType.equals("exact")) {
            retString = HumanSearchDao.equal((String)column);
        }
        return retString;
    }

    protected String getSetParamCondition(Object queryType, String value) {
        String retString = "";
        if (queryType.equals("forward")) {
            retString = HumanSearchDao.startWithParam((String)value);
        } else if (queryType.equals("broad")) {
            retString = HumanSearchDao.containsParam((String)value);
        } else if (queryType.equals("exact")) {
            retString = value;
        }
        return retString;
    }

    protected String getAdditionalQuery(Map<String, Object> param) {
        return "";
    }

    protected String getOrderByColumnForParam(Map<String, Object> param) {
        return HumanSearchDao.getOrderByColumn((String)"employee_code");
    }
}

