/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.workflow.WorkflowReferenceBeanInterface;
import jp.mosp.platform.dao.workflow.WorkflowDaoInterface;
import jp.mosp.platform.dto.workflow.WorkflowDtoInterface;

public class WorkflowReferenceBean
extends PlatformBean
implements WorkflowReferenceBeanInterface {
    private WorkflowDaoInterface dao;

    public WorkflowReferenceBean() {
    }

    public WorkflowReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (WorkflowDaoInterface)this.createDao(WorkflowDaoInterface.class);
    }

    public WorkflowDtoInterface getLatestWorkflowInfo(long workflow) throws MospException {
        return this.dao.findForKey(workflow);
    }

    public List<WorkflowDtoInterface> getListForApproverId(String functionCode, String approverId) throws MospException {
        return this.dao.findForApproverId(functionCode, approverId);
    }

    public List<WorkflowDtoInterface> getListForRoute(int workflowStage, String workflowStatus, String routeCode, String functionCode) throws MospException {
        return this.dao.findForRoute(workflowStage, workflowStatus, routeCode, functionCode);
    }

    public List<WorkflowDtoInterface> getListForRoute(String workflowStatus, String routeCode, String functionCode) throws MospException {
        return this.dao.findForRoute(workflowStatus, routeCode, functionCode);
    }

    public WorkflowDtoInterface findForId(long id) throws MospException {
        BaseDto baseDto = this.findForKey((BaseDaoInterface)this.dao, id, false);
        if (baseDto != null) {
            return (WorkflowDtoInterface)baseDto;
        }
        return null;
    }

    public List<WorkflowDtoInterface> getApprovableList(Set<String> functionCodeSet) throws MospException {
        return this.dao.findApprovable(functionCodeSet);
    }

    public List<WorkflowDtoInterface> getCancelableList(Set<String> functionCodeSet) throws MospException {
        return this.dao.findForCondition(null, null, functionCodeSet, this.getCancelAppliedSet());
    }

    public List<WorkflowDtoInterface> getEffectiveList(Date fromDate, Date toDate, Set<String> functionCodeSet) throws MospException {
        return this.dao.findForCondition(fromDate, toDate, functionCodeSet, this.getEffectiveSet());
    }

    public List<WorkflowDtoInterface> getCompletedList(Date fromDate, Date toDate, Set<String> functionCodeSet) throws MospException {
        return this.dao.findForCondition(fromDate, toDate, functionCodeSet, this.getCompletedSet());
    }

    public List<WorkflowDtoInterface> getCompletedList(String personalId, Date fromDate, Date toDate, Set<String> functionCodeSet) throws MospException {
        return this.dao.findForCondition(personalId, fromDate, toDate, functionCodeSet, this.getCompletedSet());
    }

    public List<WorkflowDtoInterface> getNonApprovedList(Date fromDate, Date toDate, Set<String> functionCodeSet) throws MospException {
        return this.dao.findForCondition(fromDate, toDate, functionCodeSet, this.getNonApprovedSet());
    }

    public List<WorkflowDtoInterface> getRevertedList(Date fromDate, Date toDate, Set<String> functionCodeSet) throws MospException {
        return this.dao.findForCondition(fromDate, toDate, functionCodeSet, this.getRevertedSet());
    }

    public List<WorkflowDtoInterface> getCancelAppliedList(Date fromDate, Date toDate, Set<String> functionCodeSet) throws MospException {
        return this.dao.findForCondition(fromDate, toDate, functionCodeSet, this.getCancelAppliedSet());
    }

    protected Set<String> getEffectiveSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        set.add("4");
        set.add("9");
        set.add("6");
        return set;
    }

    protected Set<String> getRevertedSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("3");
        return set;
    }

    protected Set<String> getCompletedSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("9");
        return set;
    }

    protected Set<String> getNonApprovedSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        return set;
    }

    protected Set<String> getCancelAppliedSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("6");
        return set;
    }

    public List<WorkflowDtoInterface> getPersonalList(String personalId, Date startDate, Date endDate, Set<String> functionCodeSet) throws MospException {
        return this.dao.findForCondition(personalId, startDate, endDate, functionCodeSet);
    }
}

