/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanSearchBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteRegistBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalRouteUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.RouteApplicationReferenceSearchBeanInterface;
import jp.mosp.platform.bean.workflow.WorkflowIntegrateBeanInterface;
import jp.mosp.platform.comparator.human.HumanPositionGradeComparator;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteUnitDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationDtoInterface;
import jp.mosp.platform.dto.workflow.RouteApplicationReferenceDtoInterface;
import jp.mosp.platform.dto.workflow.impl.RouteApplicationReferenceDto;

public class RouteApplicationReferenceSearchBean
extends PlatformBean
implements RouteApplicationReferenceSearchBeanInterface {
    protected Date activateDate;
    private String employeeCode;
    private String employeeName;
    private String workPlaceCode;
    private String employmentCode;
    private String sectionCode;
    private String positionCode;
    protected int workflowType;
    private String routeApplicationCode;
    private String routeApplicationName;
    protected String routeCode;
    protected String routeName;
    private String approverCode;
    private String approverName;
    protected HumanSearchBeanInterface humanSearch;
    protected RouteApplicationReferenceBeanInterface routeApplicationRefer;
    private ApprovalRouteReferenceBeanInterface routeRefer;
    protected ApprovalRouteRegistBeanInterface routeRegist;
    private ApprovalRouteUnitReferenceBeanInterface approvalUnitRefer;
    protected WorkflowIntegrateBeanInterface workflowIntegrate;

    public void initBean() throws MospException {
        this.humanSearch = (HumanSearchBeanInterface)this.createBean(HumanSearchBeanInterface.class);
        this.routeApplicationRefer = (RouteApplicationReferenceBeanInterface)this.createBean(RouteApplicationReferenceBeanInterface.class);
        this.approvalUnitRefer = (ApprovalRouteUnitReferenceBeanInterface)this.createBean(ApprovalRouteUnitReferenceBeanInterface.class);
        this.routeRefer = (ApprovalRouteReferenceBeanInterface)this.createBean(ApprovalRouteReferenceBeanInterface.class);
        this.routeRegist = (ApprovalRouteRegistBeanInterface)this.createBean(ApprovalRouteRegistBeanInterface.class);
        this.workflowIntegrate = (WorkflowIntegrateBeanInterface)this.createBean(WorkflowIntegrateBeanInterface.class);
    }

    public List<RouteApplicationReferenceDtoInterface> getSearchList() throws MospException {
        ArrayList<RouteApplicationReferenceDtoInterface> list = new ArrayList<RouteApplicationReferenceDtoInterface>();
        HashMap<String, RouteApplicationReferenceDto> seachedMap = new HashMap<String, RouteApplicationReferenceDto>();
        HumanPositionGradeComparator comparator = this.workflowIntegrate.getPositionGradeComparator(this.activateDate);
        List humanList = this.getHumanList();
        for (HumanDtoInterface humanDto : humanList) {
            List routeApproverList;
            RouteApplicationDtoInterface routeApplicationDto = this.routeApplicationRefer.findForPerson(humanDto.getPersonalId(), this.activateDate, this.workflowType);
            if (!this.isRouteApplicationMatch(routeApplicationDto)) continue;
            if (this.isApplicationSearched(seachedMap, routeApplicationDto)) {
                list.add(this.copyRouteApplicationDto(humanDto, routeApplicationDto, seachedMap));
                continue;
            }
            ApprovalRouteDtoInterface routeDto = this.getApprovalRouteDto(routeApplicationDto);
            if (!this.isRouteMatch(routeDto) || !this.isApproverMatch(routeApproverList = this.getRouteApproverList(routeDto, comparator))) continue;
            RouteApplicationReferenceDto dto = this.getRouteApplicationReferenceDto();
            this.setRouteApplicationReferenceDto((RouteApplicationReferenceDtoInterface)dto, humanDto, routeApplicationDto, routeDto);
            this.setApproverName((RouteApplicationReferenceDtoInterface)dto, routeApproverList);
            list.add((RouteApplicationReferenceDtoInterface)dto);
            seachedMap.put(dto.getRouteApplicationCode(), dto);
        }
        return list;
    }

    protected List<HumanDtoInterface> getHumanList() throws MospException {
        this.humanSearch.setTargetDate(this.activateDate);
        this.humanSearch.setEmployeeCode(this.employeeCode);
        this.humanSearch.setEmployeeName(this.employeeName);
        this.humanSearch.setWorkPlaceCode(this.workPlaceCode);
        this.humanSearch.setSectionCode(this.sectionCode);
        this.humanSearch.setPositionCode(this.positionCode);
        this.humanSearch.setEmploymentContractCode(this.employmentCode);
        this.humanSearch.setEmployeeCodeType("forward");
        this.humanSearch.setNeedLowerSection(true);
        this.humanSearch.setNeedConcurrent(true);
        this.humanSearch.setStateType("presence");
        return this.humanSearch.search();
    }

    protected ApprovalRouteDtoInterface getApprovalRouteDto(RouteApplicationDtoInterface routeApplicationDto) throws MospException {
        ApprovalRouteDtoInterface routeDto = null;
        if (routeApplicationDto == null) {
            return routeDto;
        }
        if (routeApplicationDto.getRouteCode().equals("SELF_APPRO")) {
            routeDto = this.routeRegist.getInitDto();
            routeDto.setRouteCode("");
            routeDto.setRouteName(this.getNameSelfApproval());
            routeDto.setApprovalCount(0);
        } else {
            routeDto = this.routeRefer.getApprovalRouteInfo(routeApplicationDto.getRouteCode(), this.activateDate);
        }
        return routeDto;
    }

    protected List<List<HumanDtoInterface>> getRouteApproverList(ApprovalRouteDtoInterface approvalRouteDto, HumanPositionGradeComparator comparator) throws MospException {
        ArrayList<List<HumanDtoInterface>> routeApproverList = new ArrayList<List<HumanDtoInterface>>();
        if (approvalRouteDto == null || approvalRouteDto.getRouteCode().isEmpty()) {
            return routeApproverList;
        }
        List routeUnitList = new ArrayList();
        routeUnitList = this.approvalUnitRefer.getApprovalRouteUnitList(approvalRouteDto.getRouteCode(), this.activateDate);
        for (ApprovalRouteUnitDtoInterface routeUnitDto : routeUnitList) {
            List unitApproverList = this.workflowIntegrate.getUnitApproverList(routeUnitDto.getUnitCode(), this.activateDate);
            Collections.sort(unitApproverList, comparator);
            routeApproverList.add(unitApproverList);
        }
        return routeApproverList;
    }

    protected void setRouteApplicationReferenceDto(RouteApplicationReferenceDtoInterface dto, HumanDtoInterface humanDto, RouteApplicationDtoInterface routeApplicationDto, ApprovalRouteDtoInterface approvalRouteDto) {
        dto.setPersonalId(humanDto.getPersonalId());
        dto.setEmployeeCode(humanDto.getEmployeeCode());
        dto.setFirstName(humanDto.getFirstName());
        dto.setLastName(humanDto.getLastName());
        dto.setEmployeeName(MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName()));
        if (routeApplicationDto != null) {
            dto.setActivateDate(routeApplicationDto.getActivateDate());
            dto.setRouteApplicationCode(routeApplicationDto.getRouteApplicationCode());
            dto.setRouteApplicationName(routeApplicationDto.getRouteApplicationName());
        }
        if (approvalRouteDto != null) {
            dto.setRouteCode(approvalRouteDto.getRouteCode());
            dto.setRouteName(approvalRouteDto.getRouteName());
            dto.setRouteStage(String.valueOf(approvalRouteDto.getApprovalCount()));
        }
    }

    protected void setApproverName(RouteApplicationReferenceDtoInterface dto, List<List<HumanDtoInterface>> routeApproverList) throws MospException {
        List<HumanDtoInterface> endApproverList;
        if (routeApproverList.isEmpty()) {
            return;
        }
        List<HumanDtoInterface> firstApproverList = routeApproverList.get(0);
        if (!firstApproverList.isEmpty()) {
            HumanDtoInterface firstApprover = firstApproverList.get(0);
            dto.setFirstApprovalName(MospUtility.getHumansName((String)firstApprover.getFirstName(), (String)firstApprover.getLastName()));
        }
        if (!(endApproverList = routeApproverList.get(routeApproverList.size() - 1)).isEmpty()) {
            HumanDtoInterface lastApprover = endApproverList.get(0);
            dto.setEndApprovalName(MospUtility.getHumansName((String)lastApprover.getFirstName(), (String)lastApprover.getLastName()));
        }
    }

    protected boolean isRouteMatch(ApprovalRouteDtoInterface routeDto) throws MospException {
        if (!this.routeCode.isEmpty()) {
            if (routeDto == null) {
                return false;
            }
            if (!this.isForwardMatch(this.routeCode, routeDto.getRouteCode())) {
                return false;
            }
        }
        if (!this.routeName.isEmpty()) {
            if (routeDto == null) {
                return false;
            }
            if (!this.isBroadMatch(this.routeName, routeDto.getRouteName())) {
                return false;
            }
        }
        return true;
    }

    protected boolean isRouteApplicationMatch(RouteApplicationDtoInterface routeApplicationDto) throws MospException {
        if (!this.routeApplicationCode.isEmpty()) {
            if (routeApplicationDto == null) {
                return false;
            }
            if (!this.isForwardMatch(this.routeApplicationCode, routeApplicationDto.getRouteApplicationCode())) {
                return false;
            }
        }
        if (!this.routeApplicationName.isEmpty()) {
            if (routeApplicationDto == null) {
                return false;
            }
            if (!this.isBroadMatch(this.routeApplicationName, routeApplicationDto.getRouteApplicationName())) {
                return false;
            }
        }
        return true;
    }

    protected boolean isApproverMatch(List<List<HumanDtoInterface>> routeApproverList) throws MospException {
        if (this.approverName.isEmpty() && this.approverCode.isEmpty()) {
            return true;
        }
        for (List<HumanDtoInterface> approverList : routeApproverList) {
            for (HumanDtoInterface approverDto : approverList) {
                if (!this.isApproverMatch(approverDto)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isApproverMatch(HumanDtoInterface approverDto) throws MospException {
        if (!this.approverCode.isEmpty()) {
            if (approverDto == null) {
                return false;
            }
            if (!this.isForwardMatch(this.approverCode, approverDto.getEmployeeCode())) {
                return false;
            }
        }
        if (!this.approverName.isEmpty()) {
            if (approverDto == null) {
                return false;
            }
            if (!this.isHumanNameMatch(this.approverName, approverDto.getFirstName(), approverDto.getLastName())) {
                return false;
            }
        }
        return true;
    }

    protected boolean isApplicationSearched(Map<String, RouteApplicationReferenceDtoInterface> seachedMap, RouteApplicationDtoInterface routeApplicationDto) {
        String routeApplicationCode = "";
        if (routeApplicationDto != null) {
            routeApplicationCode = routeApplicationDto.getRouteApplicationCode();
        }
        return seachedMap.containsKey(routeApplicationCode);
    }

    protected RouteApplicationReferenceDtoInterface copyRouteApplicationDto(HumanDtoInterface humanDto, RouteApplicationDtoInterface routeApplicationDto, Map<String, RouteApplicationReferenceDtoInterface> seachedMap) {
        String routeApplicationCode = "";
        if (routeApplicationDto != null) {
            routeApplicationCode = routeApplicationDto.getRouteApplicationCode();
        }
        RouteApplicationReferenceDtoInterface seachedDto = seachedMap.get(routeApplicationCode);
        RouteApplicationReferenceDto newDto = this.getRouteApplicationReferenceDto();
        newDto.setRouteApplicationCode(seachedDto.getRouteApplicationCode());
        newDto.setActivateDate(seachedDto.getActivateDate());
        newDto.setRouteApplicationCode(seachedDto.getRouteApplicationCode());
        newDto.setRouteApplicationName(seachedDto.getRouteApplicationName());
        newDto.setRouteCode(seachedDto.getRouteCode());
        newDto.setRouteName(seachedDto.getRouteName());
        newDto.setRouteStage(seachedDto.getRouteStage());
        newDto.setFirstApprovalName(seachedDto.getFirstApprovalName());
        newDto.setEndApprovalName(seachedDto.getEndApprovalName());
        newDto.setPersonalId(humanDto.getPersonalId());
        newDto.setEmployeeCode(humanDto.getEmployeeCode());
        newDto.setFirstName(humanDto.getFirstName());
        newDto.setLastName(humanDto.getLastName());
        newDto.setEmployeeName(MospUtility.getHumansName((String)humanDto.getFirstName(), (String)humanDto.getLastName()));
        return newDto;
    }

    protected RouteApplicationReferenceDto getRouteApplicationReferenceDto() {
        RouteApplicationReferenceDto dto = new RouteApplicationReferenceDto();
        dto.setActivateDate(null);
        dto.setEmployeeCode("");
        dto.setEmployeeName("");
        dto.setWorkflowType(0);
        dto.setRouteApplicationName("");
        dto.setRouteApplicationCode("");
        dto.setRouteCode("");
        dto.setRouteName("");
        dto.setRouteStage("");
        dto.setFirstApprovalName("");
        dto.setEndApprovalName("");
        dto.setApproverCode("");
        dto.setApproverName("");
        dto.setSectionCode("");
        dto.setPositionCode("");
        dto.setPersonalId("");
        dto.setEmploymentContractCode("");
        dto.setFirstName("");
        dto.setLastName("");
        dto.setWorkPlaceCode("");
        return dto;
    }

    protected String getNameSelfApproval() {
        return this.mospParams.getName("SelfApproval");
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = activateDate;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setWorkPlaceCode(String workPlaceCode) {
        this.workPlaceCode = workPlaceCode;
    }

    public void setEmploymentCode(String employmentCode) {
        this.employmentCode = employmentCode;
    }

    public void setSectionCode(String sectionCode) {
        this.sectionCode = sectionCode;
    }

    public void setPositionCode(String positionCode) {
        this.positionCode = positionCode;
    }

    public void setRouteApplicationCode(String routeApplicationCode) {
        this.routeApplicationCode = routeApplicationCode;
    }

    public void setRouteApplicationName(String routeApplicationName) {
        this.routeApplicationName = routeApplicationName;
    }

    public void setRouteCode(String routeCode) {
        this.routeCode = routeCode;
    }

    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }

    public void setApproverCode(String approverCode) {
        this.approverCode = approverCode;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public void setWorkflowType(int workflowType) {
        this.workflowType = workflowType;
    }
}

