/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.workflow.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.bean.workflow.ApprovalUnitReferenceBeanInterface;
import jp.mosp.platform.bean.workflow.ApprovalUnitRegistBeanInterface;
import jp.mosp.platform.dao.workflow.ApprovalRouteUnitDaoInterface;
import jp.mosp.platform.dao.workflow.ApprovalUnitDaoInterface;
import jp.mosp.platform.dto.workflow.ApprovalRouteUnitDtoInterface;
import jp.mosp.platform.dto.workflow.ApprovalUnitDtoInterface;
import jp.mosp.platform.dto.workflow.impl.PfmApprovalUnitDto;

public class ApprovalUnitRegistBean
extends PlatformHumanBean
implements ApprovalUnitRegistBeanInterface {
    protected static final int LEN_CODE = 10;
    protected static final int LEN_UNIT_NAME = 50;
    private ApprovalUnitDaoInterface dao;
    protected ApprovalUnitReferenceBeanInterface unitReference;

    public ApprovalUnitRegistBean() {
    }

    public ApprovalUnitRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (ApprovalUnitDaoInterface)this.createDao(ApprovalUnitDaoInterface.class);
        this.unitReference = (ApprovalUnitReferenceBeanInterface)this.createBean(ApprovalUnitReferenceBeanInterface.class);
    }

    public ApprovalUnitDtoInterface getInitDto() {
        return new PfmApprovalUnitDto();
    }

    public void add(ApprovalUnitDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmApprovalUnitId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(ApprovalUnitDtoInterface dto) throws MospException {
        dto.setPfmApprovalUnitId(this.getRecordID(dto));
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmApprovalUnitId());
    }

    public void insert(ApprovalUnitDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmApprovalUnitId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(ApprovalUnitDtoInterface dto) throws MospException {
        dto.setPfmApprovalUnitId(this.getRecordID(dto));
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmApprovalUnitId());
        dto.setPfmApprovalUnitId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            ApprovalUnitDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto, null);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmApprovalUnitId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto, null);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmApprovalUnitId());
            dto.setPfmApprovalUnitId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void regist(ApprovalUnitDtoInterface dto) throws MospException {
        List list = this.unitReference.getApprovalUnitHistory(dto.getUnitCode());
        if (list.isEmpty()) {
            this.insert(dto);
            return;
        }
        for (ApprovalUnitDtoInterface approvalDto : list) {
            if (dto.getActivateDate().compareTo(approvalDto.getActivateDate()) != 0) continue;
            this.update(dto);
            return;
        }
        this.add(dto);
    }

    public void validate(ApprovalUnitDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getUnitCode(), this.getNameUnitCode(), row);
        this.checkRequired((Object)dto.getActivateDate(), this.getNameActivateDate(), row);
        this.checkRequired((Object)dto.getUnitType(), this.getNameUnitCode(), row);
        this.checkLength(dto.getUnitCode(), 10, this.getNameUnitCode(), row);
        this.checkLength(dto.getUnitName(), 50, this.getNameUnitName(), row);
        this.checkLength(dto.getApproverSectionCode(), 10, this.getNameApproverPositionCode(), row);
        this.checkLength(dto.getApproverPositionCode(), 10, this.getNameApproverSectionCode(), row);
        this.checkTypeCode(dto.getUnitCode(), this.getNameUnitCode(), row);
        this.checkInactivateFlag(dto.getInactivateFlag(), row);
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (dto.getUnitType().equals("section")) {
            this.checkRequired((Object)dto.getApproverSectionCode(), this.getNameApproverSectionCode(), row);
            this.checkRequired((Object)dto.getApproverPositionCode(), this.getNameApproverPositionCode(), row);
            this.checkMaster(dto, row);
        }
        if (dto.getUnitType().equals("person")) {
            this.checkRequired((Object)dto.getApproverPersonalId(), this.getNameApproverEmployeeCode(), row);
        }
        this.checkRequired((Object)dto.getUnitName(), this.getNameUnitName(), row);
    }

    protected void checkMaster(ApprovalUnitDtoInterface dto, Integer row) throws MospException {
        List list = this.unitReference.getApprovalUnitHistory(dto.getUnitCode());
        Date startDate = dto.getActivateDate();
        Date endDate = this.getEffectiveLastDate(dto.getActivateDate(), list);
        this.checkSection(dto.getApproverSectionCode(), startDate, endDate, row);
        this.checkPosition(dto.getApproverPositionCode(), startDate, endDate, row);
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            ApprovalUnitDtoInterface dto = (ApprovalUnitDtoInterface)this.dao.findForKey(id, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getUnitCode());
        }
        return list;
    }

    private void checkAdd(ApprovalUnitDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getUnitCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getUnitCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List routeList = this.getApprovalRouteListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getUnitCode(), routeList);
    }

    private void checkDelete(ApprovalUnitDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmApprovalUnitId());
        this.checkMasterDelete(dto);
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmApprovalUnitId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getUnitCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List routeUnitList = this.getApprovalRouteListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getUnitCode(), routeUnitList);
    }

    private void checkMasterDelete(ApprovalUnitDtoInterface dto) throws MospException {
        ApprovalUnitDtoInterface beforeDto = this.unitReference.getApprovalUnitInfo(dto.getUnitCode(), DateUtility.addDay((Date)dto.getActivateDate(), (int)-1));
        if (beforeDto == null || beforeDto.getInactivateFlag() == 1) {
            return;
        }
        List list = this.unitReference.getApprovalUnitHistory(dto.getUnitCode());
        Date startDate = beforeDto.getActivateDate();
        Date endDate = this.getEffectiveLastDate(dto.getActivateDate(), list);
        this.masterCheck.isCheckSection(beforeDto.getApproverSectionCode(), startDate, endDate);
        this.masterCheck.isCheckPosition(beforeDto.getApproverPositionCode(), startDate, endDate);
    }

    private void checkInsert(ApprovalUnitDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getUnitCode()));
    }

    private void checkUpdate(ApprovalUnitDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmApprovalUnitId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmApprovalUnitId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getUnitCode());
        List routeUnitList = this.getApprovalRouteListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getUnitCode(), routeUnitList);
    }

    private long getRecordID(ApprovalUnitDtoInterface dto) throws MospException {
        ApprovalUnitDtoInterface subDto = this.dao.findForKey(dto.getUnitCode(), dto.getActivateDate());
        return subDto.getPfmApprovalUnitId();
    }

    protected void checkCodeIsUsed(String code, List<ApprovalRouteUnitDtoInterface> list) {
        String codeAdded = "";
        for (ApprovalRouteUnitDtoInterface dto : list) {
            if (!code.equals(dto.getUnitCode()) || !this.isDtoActivate((BaseDtoInterface)dto) || codeAdded.equals(dto.getRouteCode())) continue;
            this.addUnitCodeIsUsedMessage(code, dto);
            codeAdded = dto.getRouteCode();
        }
    }

    protected List<ApprovalRouteUnitDtoInterface> getApprovalRouteListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        ApprovalRouteUnitDaoInterface routeUnitDao = (ApprovalRouteUnitDaoInterface)this.createDao(ApprovalRouteUnitDaoInterface.class);
        List routeUnitList = routeUnitDao.findForActivateDate(dto.getActivateDate());
        routeUnitList.addAll(routeUnitDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return routeUnitList;
    }

    protected void addUnitCodeIsUsedMessage(String code, ApprovalRouteUnitDtoInterface dto) {
        this.mospParams.addErrorMessage("PFW0222", new String[]{code, dto.getRouteCode()});
    }

    protected String getNameUnitCode() {
        return this.mospParams.getName("WorkflowUnit", new String[]{"Code"});
    }

    protected String getNameUnitName() {
        return this.mospParams.getName("WorkflowUnit", new String[]{"Name"});
    }

    protected String getNameUnitType() {
        return this.mospParams.getName("WorkflowUnit", new String[]{"Type"});
    }

    protected String getNameApproverSectionCode() {
        return this.mospParams.getName("Approver", new String[]{"Section", "Code"});
    }

    protected String getNameApproverPositionCode() {
        return this.mospParams.getName("Approver", new String[]{"Position", "Code"});
    }

    protected String getNameApproverEmployeeCode() {
        return this.mospParams.getName("Approver", new String[]{"Employee", "Code"});
    }
}

