/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.RoleProperty;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterRegistBeanInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dao.system.UserPasswordDaoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmUserDto;

public class UserMasterRegistBean
extends PlatformFileBean
implements UserMasterRegistBeanInterface {
    protected static final int LEN_USER_ID = 50;
    protected UserMasterDaoInterface dao;
    protected UserPasswordDaoInterface userPasswordDao;
    protected RoleReferenceBeanInterface roleRefer;

    public UserMasterRegistBean() {
    }

    public UserMasterRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (UserMasterDaoInterface)this.createDao(UserMasterDaoInterface.class);
        this.userPasswordDao = (UserPasswordDaoInterface)this.createDao(UserPasswordDaoInterface.class);
        this.roleRefer = (RoleReferenceBeanInterface)this.createBean(RoleReferenceBeanInterface.class);
    }

    public UserMasterDtoInterface getInitDto() {
        return new PfmUserDto();
    }

    public void insert(UserMasterDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmUserId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(UserMasterDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmUserId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        this.checkUserExist();
    }

    public void update(UserMasterDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmUserId());
        dto.setPfmUserId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
        this.checkUserExist();
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getUserIdList(idArray)) {
            UserMasterDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto, null);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmUserId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto, null);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmUserId());
            dto.setPfmUserId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        this.checkUserExist();
    }

    public void update(long[] idArray, Date activateDate, String roleCode) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getUserIdList(idArray)) {
            UserMasterDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setRoleCode(roleCode);
                this.validate(dto, null);
                this.checkAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmUserId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setRoleCode(roleCode);
            this.validate(dto, null);
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmUserId());
            dto.setPfmUserId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
        this.checkUserExist();
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            List list;
            UserMasterDtoInterface dto = (UserMasterDtoInterface)this.dao.findForKey(id, true);
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
            UserPasswordDtoInterface userPasswordDto = this.userPasswordDao.findForInfo(dto.getUserId());
            if (userPasswordDto == null || !(list = this.dao.findForHistory(dto.getUserId())).isEmpty()) continue;
            this.logicalDelete((BaseDaoInterface)this.userPasswordDao, userPasswordDto.getPfaUserPasswordId());
        }
        this.checkUserExist();
    }

    public List<String> getUserIdList(long[] recordIdArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long recordId : recordIdArray) {
            UserMasterDtoInterface dto = (UserMasterDtoInterface)this.dao.findForKey(recordId, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getUserId());
        }
        return list;
    }

    protected void checkInsert(UserMasterDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getUserId()));
    }

    protected void checkAdd(UserMasterDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getUserId(), dto.getActivateDate()));
    }

    protected void checkUpdate(UserMasterDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmUserId());
    }

    protected void checkDelete(UserMasterDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmUserId());
    }

    protected void checkUser(UserMasterDtoInterface dto) throws MospException {
        UserCheckBeanInterface userCheck = (UserCheckBeanInterface)this.createBean(UserCheckBeanInterface.class);
        userCheck.checkRoleExist(dto.getRoleCode(), dto.getActivateDate());
        userCheck.checkUserEmployee(dto.getPersonalId(), dto.getActivateDate());
    }

    protected void checkUserExist() throws MospException {
        List list = this.dao.findForRole(this.getNeededRole(), this.getSystemDate());
        if (list.isEmpty()) {
            this.addDisappearNeededRoleMessage();
        }
    }

    protected String getNeededRole() {
        for (Map.Entry entry : this.mospParams.getProperties().getRoleProperties().entrySet()) {
            RoleProperty roleProperty = (RoleProperty)entry.getValue();
            if (!roleProperty.isNeeded()) continue;
            return roleProperty.getKey();
        }
        return "";
    }

    protected void addDisappearNeededRoleMessage() {
        this.mospParams.addErrorMessage("PFW0211", new String[]{this.getNeededRole()});
    }

    public void validate(UserMasterDtoInterface dto, Integer row) throws MospException {
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            this.checkUser(dto);
        }
        this.checkRequired((Object)dto.getUserId(), this.getNameUserId(), row);
        this.checkUserId(dto.getUserId(), this.getNameUserId(), row);
        this.checkRequired((Object)dto.getActivateDate(), this.getNameActivateDate(), row);
        this.checkLength(dto.getUserId(), 50, this.getNameUserId(), row);
        this.checkRole(dto.getRoleCode(), dto.getActivateDate(), row);
    }

    protected void checkRole(String roleCode, Date targetDate, Integer row) throws MospException {
        String[][] aryRole;
        for (String[] role : aryRole = this.roleRefer.getSelectArray(targetDate, false)) {
            if (!role[0].equals(roleCode)) continue;
            return;
        }
        this.addRoleNotExistMessage(roleCode, row);
    }

    protected void addRoleNotExistMessage(String roleCode, Integer row) {
        String[] rep = new String[]{this.getRowedFieldName(this.getNameRole(), row), roleCode};
        this.mospParams.addErrorMessage("PFW0214", rep);
    }

    protected String getNameUserId() {
        return this.mospParams.getName("User") + this.mospParams.getName("Id");
    }

    protected String getNameRole() {
        return this.mospParams.getName("Role");
    }
}

