/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.bean.file.PlatformFileBean;
import jp.mosp.platform.bean.system.SectionRegistBeanInterface;
import jp.mosp.platform.dao.system.SectionDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;
import jp.mosp.platform.dto.system.impl.PfmSectionDto;

public class SectionRegistBean
extends PlatformFileBean
implements SectionRegistBeanInterface {
    protected static final int LEN_SECTION_CODE = 10;
    protected static final int LEN_SECTION_NAME = 40;
    protected static final int LEN_SECTION_ABBR = 6;
    protected static final int LEN_SECTION_DISPLAY = 16;
    protected SectionDaoInterface dao;

    public SectionRegistBean() {
    }

    public SectionRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (SectionDaoInterface)this.createDao(SectionDaoInterface.class);
    }

    public SectionDtoInterface getInitDto() {
        return new PfmSectionDto();
    }

    public void insert(SectionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmSectionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(SectionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        this.checkClassRouteForAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmSectionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(SectionDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        this.checkClassRouteForUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmSectionId());
        dto.setPfmSectionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(long[] idArray, Date activateDate, int inactivateFlag) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            SectionDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setInactivateFlag(inactivateFlag);
                this.validate(dto, null);
                this.checkAdd(dto);
                this.checkClassRouteForAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmSectionId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setInactivateFlag(inactivateFlag);
            this.validate(dto, null);
            this.checkUpdate(dto);
            this.checkClassRouteForUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmSectionId());
            dto.setPfmSectionId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void update(long[] idArray, Date activateDate, String classRoute) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (String code : this.getCodeList(idArray)) {
            SectionDtoInterface dto = this.dao.findForKey(code, activateDate);
            if (dto == null) {
                dto = this.dao.findForInfo(code, activateDate);
                if (dto == null) {
                    this.addNoCodeBeforeActivateDateMessage(code);
                    continue;
                }
                dto.setActivateDate(activateDate);
                dto.setClassRoute(classRoute);
                this.validate(dto, null);
                this.checkAdd(dto);
                this.checkClassRouteForAdd(dto);
                if (this.mospParams.hasErrorMessage()) continue;
                dto.setPfmSectionId(this.dao.nextRecordId());
                this.dao.insert((BaseDtoInterface)dto);
                continue;
            }
            dto.setClassRoute(classRoute);
            this.validate(dto, null);
            this.checkUpdate(dto);
            this.checkClassRouteForUpdate(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmSectionId());
            dto.setPfmSectionId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            SectionDtoInterface dto = (SectionDtoInterface)this.dao.findForKey(id, true);
            this.checkDelete(dto);
            this.checkClassRouteForDelete(dto);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void checkInsert(SectionDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getSectionCode()));
    }

    protected void checkAdd(SectionDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getSectionCode(), dto.getActivateDate()));
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        if (!this.needCheckTermForAdd((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getSectionCode(), humanList);
    }

    protected void checkUpdate(SectionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmSectionId());
        if (this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)this.dao.findForKey(dto.getPfmSectionId(), true))) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getSectionCode(), humanList);
    }

    protected void checkDelete(SectionDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmSectionId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        if (!this.needCheckTermForDelete((PlatformDtoInterface)dto, list)) {
            return;
        }
        List humanList = this.getHumanListForCheck((PlatformDtoInterface)dto, list);
        this.checkCodeIsUsed(dto.getSectionCode(), humanList);
    }

    protected void checkClassRouteForAdd(SectionDtoInterface dto) throws MospException {
        this.checkClassRouteContainSelf(dto);
        SectionDtoInterface beforeDto = this.dao.findForInfo(dto.getSectionCode(), dto.getActivateDate());
        if (beforeDto == null || !this.isDtoActivate((BaseDtoInterface)beforeDto)) {
            return;
        }
        if (!this.isDtoActivate((BaseDtoInterface)beforeDto) && !this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        if (this.isDtoActivate((BaseDtoInterface)beforeDto) && this.isDtoActivate((BaseDtoInterface)dto) && beforeDto.getClassRoute().equals(dto.getClassRoute())) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        this.checkCodeIsUsedAsClassRoute(dto.getSectionCode(), this.getSectionListForCheck((PlatformDtoInterface)dto, list));
    }

    protected void checkClassRouteForUpdate(SectionDtoInterface dto) throws MospException {
        SectionDtoInterface currentDto = this.dao.findForKey(dto.getSectionCode(), dto.getActivateDate());
        if (!this.isDtoActivate((BaseDtoInterface)currentDto) && !this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        this.checkClassRouteContainSelf(dto);
        if (this.isDtoActivate((BaseDtoInterface)currentDto) && this.isDtoActivate((BaseDtoInterface)dto) && currentDto.getClassRoute().equals(dto.getClassRoute())) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        this.checkCodeIsUsedAsClassRoute(dto.getSectionCode(), this.getSectionListForCheck((PlatformDtoInterface)dto, list));
    }

    protected void checkClassRouteForDelete(SectionDtoInterface dto) throws MospException {
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        SectionDtoInterface beforeDto = this.dao.findForInfo(dto.getSectionCode(), DateUtility.addDay((Date)dto.getActivateDate(), (int)-1));
        if (beforeDto != null && this.isDtoActivate((BaseDtoInterface)beforeDto) && beforeDto.getClassRoute().equals(dto.getClassRoute())) {
            return;
        }
        List list = this.dao.findForHistory(dto.getSectionCode());
        this.checkCodeIsUsedAsClassRoute(dto.getSectionCode(), this.getSectionListForCheck((PlatformDtoInterface)dto, list));
    }

    protected List<SectionDtoInterface> getSectionListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        List sectionList = this.dao.findForActivateDate(dto.getActivateDate(), new String[0]);
        sectionList.addAll(this.dao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return sectionList;
    }

    protected List<String> getCodeList(long[] idArray) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (long id : idArray) {
            SectionDtoInterface dto = (SectionDtoInterface)this.dao.findForKey(id, false);
            this.checkExclusive((BaseDtoInterface)dto);
            list.add(dto.getSectionCode());
        }
        return list;
    }

    protected void checkCodeIsUsed(String code, List<HumanDtoInterface> list) {
        for (HumanDtoInterface dto : list) {
            if (!code.equals(dto.getSectionCode())) continue;
            this.addCodeIsUsedMessage(code, dto);
        }
    }

    protected void checkCodeIsUsedAsClassRoute(String code, List<?> list) {
        String classRoute = "," + code + ",";
        for (int i = 0; i < list.size(); ++i) {
            SectionDtoInterface dto = (SectionDtoInterface)list.get(i);
            if (dto.getClassRoute().indexOf(classRoute) == -1) continue;
            this.mospParams.addErrorMessage("PFW0208", new String[]{code, dto.getSectionCode()});
        }
    }

    protected void checkClassRouteContainSelf(SectionDtoInterface dto) {
        String classRoute = "," + dto.getSectionCode() + ",";
        if (dto.getClassRoute().indexOf(classRoute) != -1) {
            this.mospParams.addErrorMessage("PFW0209", new String[0]);
        }
    }

    protected void validate(SectionDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getSectionCode(), this.getNameSectionCode(), row);
        this.checkRequired((Object)dto.getActivateDate(), this.getNameActivateDate(), row);
        this.checkLength(dto.getSectionCode(), 10, this.getNameSectionCode(), row);
        this.checkLength(dto.getSectionName(), 40, this.getNameSectionName(), row);
        this.checkLength(dto.getSectionDisplay(), 16, this.getNameSectionDisplay(), row);
        this.checkByteLength(dto.getSectionAbbr(), 6, this.getNameSectionAbbr(), row);
        this.checkTypeCode(dto.getSectionCode(), this.getNameSectionCode(), row);
        this.checkInactivateFlag(dto.getCloseFlag(), row);
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
        this.checkRequired((Object)dto.getSectionName(), this.getNameSectionName(), row);
        this.checkRequired((Object)dto.getSectionAbbr(), this.getNameSectionAbbr(), row);
    }

    protected String getNameSectionCode() {
        return this.mospParams.getName("Section") + this.mospParams.getName("Code");
    }

    protected String getNameSectionName() {
        return this.mospParams.getName("Section") + this.mospParams.getName("Name");
    }

    protected String getNameSectionAbbr() {
        return this.mospParams.getName("Section") + this.mospParams.getName("Abbreviation");
    }

    protected String getNameSectionDisplay() {
        return this.mospParams.getName("Section") + this.mospParams.getName("Display") + this.mospParams.getName("Name");
    }
}

