/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.RangeProperty;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.ConcurrentReferenceBeanInterface;
import jp.mosp.platform.bean.system.PositionReferenceBeanInterface;
import jp.mosp.platform.comparator.base.PositionCodeComparator;
import jp.mosp.platform.comparator.system.PositionMasterGradeLevelComparator;
import jp.mosp.platform.dao.system.PositionDaoInterface;
import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;

public class PositionReferenceBean
extends PlatformBean
implements PositionReferenceBeanInterface {
    private PositionDaoInterface dao;

    public PositionReferenceBean() {
    }

    protected PositionReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (PositionDaoInterface)this.createDao(PositionDaoInterface.class);
    }

    public List<PositionDtoInterface> getPositionHistory(String positionCode) throws MospException {
        return this.dao.findForHistory(positionCode);
    }

    public PositionDtoInterface getPositionInfo(String positionCode, Date targetDate) throws MospException {
        return this.dao.findForInfo(positionCode, targetDate);
    }

    public String getPositionName(String positionCode, Date targetDate) throws MospException {
        PositionDtoInterface dto = this.getPositionInfo(positionCode, targetDate);
        if (dto == null) {
            return "";
        }
        return dto.getPositionName();
    }

    public String getPositionAbbr(String positionCode, Date targetDate) throws MospException {
        PositionDtoInterface dto = this.getPositionInfo(positionCode, targetDate);
        if (dto == null) {
            return "";
        }
        return dto.getPositionAbbr();
    }

    public List<PositionDtoInterface> getPositionList(Date targetDate, String operationType) throws MospException {
        String[] rangeArray = new String[]{};
        if (operationType != null && !operationType.isEmpty()) {
            rangeArray = this.getRangePosition(operationType, targetDate);
        }
        return this.dao.findForActivateDate(targetDate, rangeArray);
    }

    public Map<String, PositionDtoInterface> getPositionMap(Date targetDate, String operationType) throws MospException {
        return this.getMap(this.getPositionList(targetDate, operationType));
    }

    public PositionDtoInterface findForkey(long id) throws MospException {
        BaseDto dto = this.findForKey((BaseDaoInterface)this.dao, id, false);
        if (dto != null) {
            return (PositionDtoInterface)dto;
        }
        return null;
    }

    public boolean hasAdvantage(PositionDtoInterface dto, int grade) {
        return grade > dto.getPositionGrade() == this.hasLowGradeAdvantage();
    }

    public boolean hasLowGradeAdvantage() {
        return this.dao.hasLowGradeAdvantage();
    }

    public String[][] getSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, false, false, false);
    }

    public String[][] getNameSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, true, false, false);
    }

    public String[][] getCodedSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, true, true, true);
    }

    public String[][] getCodedAbbrSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, false, true, true);
    }

    public String[][] getGradedSelectArray(Date targetDate, boolean needBlank, String operationType) throws MospException {
        return this.getSelectArray(targetDate, needBlank, operationType, true, false, true);
    }

    protected String[][] getSelectArray(Date targetDate, boolean needBlank, String operationType, boolean isName, boolean viewCode, boolean viewGrade) throws MospException {
        String[] rangeArray = this.getRangePosition(operationType, targetDate);
        List list = this.dao.findForActivateDate(targetDate, rangeArray = this.addConcurrentPosition(operationType, targetDate, rangeArray));
        if (list.size() == 0) {
            return this.getNoObjectDataPulldown();
        }
        this.sortList(list, PositionCodeComparator.class, false);
        if (viewGrade) {
            this.sortList(list, PositionMasterGradeLevelComparator.class, this.hasLowGradeAdvantage());
        }
        int codeLength = this.getMaxCodeLength(list, viewCode);
        int gradeLength = this.getMaxGradeLength(list, viewGrade);
        String[][] array = this.prepareSelectArray(list.size(), needBlank);
        int idx = needBlank ? 1 : 0;
        for (PositionDtoInterface dto : list) {
            array[idx][0] = dto.getPositionCode();
            if (isName && viewCode && viewGrade) {
                array[idx++][1] = this.getCodedName(dto.getPositionCode(), dto.getPositionGrade(), dto.getPositionName(), codeLength, gradeLength);
                continue;
            }
            if (isName && viewCode) {
                array[idx++][1] = this.getCodedName(dto.getPositionCode(), dto.getPositionName(), codeLength);
                continue;
            }
            if (isName && viewGrade) {
                array[idx++][1] = this.getCodedName(String.valueOf(dto.getPositionGrade()), dto.getPositionName(), gradeLength);
                continue;
            }
            if (isName) {
                array[idx++][1] = dto.getPositionName();
                continue;
            }
            if (viewCode && viewGrade) {
                array[idx++][1] = this.getCodedName(dto.getPositionCode(), dto.getPositionGrade(), dto.getPositionAbbr(), codeLength, gradeLength);
                continue;
            }
            if (viewCode) {
                array[idx++][1] = this.getCodedName(dto.getPositionCode(), dto.getPositionAbbr(), codeLength);
                continue;
            }
            if (viewGrade) {
                array[idx++][1] = this.getCodedName(String.valueOf(dto.getPositionGrade()), dto.getPositionAbbr(), gradeLength);
                continue;
            }
            array[idx++][1] = dto.getPositionAbbr();
        }
        return array;
    }

    protected String[] addConcurrentPosition(String operationType, Date targetDate, String[] rangeArray) throws MospException {
        if (operationType == null) {
            return rangeArray;
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return rangeArray;
        }
        String rangePosition = range.getPosition();
        if (rangePosition == null || rangePosition.isEmpty()) {
            return rangeArray;
        }
        List rangePositionList = this.asList(rangePosition, ",");
        if (!rangePositionList.contains("RangeMyself")) {
            return rangeArray;
        }
        ArrayList<String> rangeList = new ArrayList<String>(MospUtility.asList((String[])rangeArray));
        ConcurrentReferenceBeanInterface concurrentRefer = (ConcurrentReferenceBeanInterface)this.createBean(ConcurrentReferenceBeanInterface.class);
        List concurrentList = concurrentRefer.getConcurrentList(this.mospParams.getUser().getPersonalId(), targetDate);
        for (ConcurrentDtoInterface concurrent : concurrentList) {
            rangeList.add(concurrent.getPositionCode());
        }
        return rangeList.toArray(rangeArray);
    }

    protected int getMaxCodeLength(List<PositionDtoInterface> list, boolean viewCode) {
        if (!viewCode) {
            return 0;
        }
        int length = 0;
        for (PositionDtoInterface dto : list) {
            if (dto.getPositionCode().length() <= length) continue;
            length = dto.getPositionCode().length();
        }
        return length;
    }

    protected int getMaxGradeLength(List<PositionDtoInterface> list, boolean viewGrade) {
        if (!viewGrade) {
            return 0;
        }
        int length = 0;
        for (PositionDtoInterface dto : list) {
            if (String.valueOf(dto.getPositionGrade()).length() <= length) continue;
            length = String.valueOf(dto.getPositionGrade()).length();
        }
        return length;
    }

    protected String getCodedName(String code, int grade, String name, int codeLength, int gradeLength) {
        int i;
        StringBuffer sb = new StringBuffer();
        int codeDoubleBytes = (codeLength - code.length()) / 2;
        int codeSingleBytes = (codeLength - code.length()) % 2;
        int doubleBytes = (gradeLength - String.valueOf(grade).length() + 1) / 2;
        int singleBytes = (gradeLength - String.valueOf(grade).length() + 1) % 2;
        sb.append(code);
        for (i = 0; i < codeDoubleBytes; ++i) {
            sb.append("\u3000");
        }
        for (i = 0; i < codeSingleBytes; ++i) {
            sb.append(" ");
        }
        sb.append(this.mospParams.getName("LeftSquareBracket"));
        sb.append(grade);
        sb.append(this.mospParams.getName("RightSquareBracket"));
        for (i = 0; i < doubleBytes; ++i) {
            sb.append("\u3000");
        }
        for (i = 0; i < singleBytes; ++i) {
            sb.append(" ");
        }
        sb.append(name);
        return sb.toString();
    }

    protected Map<String, PositionDtoInterface> getMap(List<PositionDtoInterface> list) {
        HashMap<String, PositionDtoInterface> map = new HashMap<String, PositionDtoInterface>();
        for (PositionDtoInterface dto : list) {
            map.put(dto.getPositionCode(), dto);
        }
        return map;
    }
}

