/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.IcCardReferenceBeanInterface;
import jp.mosp.platform.bean.system.IcCardSearchBeanInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.system.IcCardDtoInterface;

public class IcCardSearchBean
extends PlatformBean
implements IcCardSearchBeanInterface {
    private Date activateDate;
    private String employeeCode;
    private String employeeName;
    private String cardId;
    private String inactivateFlag;
    private HumanReferenceBeanInterface humanRefer;
    private IcCardReferenceBeanInterface icCardRefer;

    public void initBean() throws MospException {
        this.humanRefer = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.icCardRefer = (IcCardReferenceBeanInterface)this.createBean(IcCardReferenceBeanInterface.class);
    }

    public List<IcCardDtoInterface> getSearchList() throws MospException {
        ArrayList<IcCardDtoInterface> list = new ArrayList<IcCardDtoInterface>();
        List cardList = this.icCardRefer.findForActivateDate(this.activateDate);
        for (IcCardDtoInterface cardDto : cardList) {
            if (!this.isIcCardIdMatch(cardDto)) continue;
            list.add(cardDto);
        }
        return list;
    }

    protected boolean isIcCardIdMatch(IcCardDtoInterface icCardDto) throws MospException {
        if (!this.cardId.isEmpty()) {
            if (icCardDto == null) {
                return false;
            }
            if (!this.isForwardMatch(this.cardId, icCardDto.getIcCardId())) {
                return false;
            }
        }
        if (!this.inactivateFlag.isEmpty() && !this.inactivateFlag.equals(String.valueOf(icCardDto.getInactivateFlag()))) {
            return false;
        }
        if (this.employeeCode.isEmpty() && this.employeeName.isEmpty()) {
            return true;
        }
        HumanDtoInterface humanDto = this.humanRefer.getHumanInfo(icCardDto.getPersonalId(), this.activateDate);
        if (humanDto == null) {
            return false;
        }
        if (!this.employeeCode.isEmpty() && !this.isForwardMatch(this.employeeCode, humanDto.getEmployeeCode())) {
            return false;
        }
        return this.employeeName.isEmpty() || this.isHumanNameMatch(this.employeeName, humanDto.getFirstName(), humanDto.getLastName());
    }

    public IcCardSearchBean() {
    }

    public IcCardSearchBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void setActivateDate(Date activateDate) {
        this.activateDate = activateDate;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public void setInactivateFlag(String inactivateFlag) {
        this.inactivateFlag = inactivateFlag;
    }

    public void setCardId(String cardId) {
        this.cardId = cardId;
    }
}

