/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.system.impl;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.system.GeneralRegistBeanInterface;
import jp.mosp.platform.dao.system.GeneralDaoInterface;
import jp.mosp.platform.dto.system.GeneralDtoInterface;
import jp.mosp.platform.dto.system.impl.GeneralDto;

public class GeneralRegistBean
extends PlatformBean
implements GeneralRegistBeanInterface {
    private GeneralDaoInterface dao;

    public GeneralRegistBean() {
    }

    public GeneralRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (GeneralDaoInterface)this.createDao(GeneralDaoInterface.class);
    }

    public GeneralDtoInterface getInitDto() {
        return new GeneralDto();
    }

    public void regist(GeneralDtoInterface dto) throws MospException {
        if (this.dao.findForKey(dto.getGeneralType(), dto.getGeneralCode(), dto.getGeneralDate()) == null) {
            this.insert(dto);
        } else {
            this.add(dto);
        }
    }

    public void insert(GeneralDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfgGeneralId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(GeneralDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfgGeneralId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(GeneralDtoInterface dto) throws MospException {
        this.validate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfgGeneralId());
        dto.setPfgGeneralId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(GeneralDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getGeneralType(), dto.getGeneralCode(), dto.getGeneralDate()));
    }

    protected void checkAdd(GeneralDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getGeneralType(), dto.getGeneralCode(), dto.getGeneralDate()));
    }

    public void validate(GeneralDtoInterface dto) {
    }

    public void checkDraft(GeneralDtoInterface dto) {
    }

    public void checkAppli(GeneralDtoInterface dto) {
    }

    public void delete(GeneralDtoInterface dto) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfgGeneralId());
    }

    public void checkApproval(GeneralDtoInterface dto) {
    }

    public void checkCancel(GeneralDtoInterface dto) {
    }

    public void checkTemporaryClosingFinal(GeneralDtoInterface dto) {
    }

    public void delete(String personalId, Date workDate) {
    }
}

