/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.portal.impl;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.human.EntranceReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.RetirementReferenceBeanInterface;
import jp.mosp.platform.bean.human.SuspensionReferenceBeanInterface;
import jp.mosp.platform.bean.portal.UserCheckBeanInterface;
import jp.mosp.platform.bean.system.RoleReferenceBeanInterface;
import jp.mosp.platform.dao.system.UserMasterDaoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;

public class UserCheckBean
extends PlatformBean
implements UserCheckBeanInterface {
    protected static final String APP_CHECK_USER = "CheckUser";
    protected static final String USER_CHECK_ENTRANCE = "Entrance";
    protected static final String USER_CHECK_RETIREMENT = "Retirement";
    protected static final String USER_CHECK_SUSPENSION = "Suspension";
    private UserMasterDaoInterface userMasterDao;

    public UserCheckBean() {
    }

    protected UserCheckBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.userMasterDao = (UserMasterDaoInterface)this.createDao(UserMasterDaoInterface.class);
    }

    public void checkUserEmployeeForUserId(String userId, Date targetDate) throws MospException {
        UserMasterDtoInterface dto = this.userMasterDao.findForInfo(userId, targetDate);
        if (dto == null || dto.getInactivateFlag() == 1) {
            this.addUserNotExistMessage();
            return;
        }
        this.checkUserEmployee(dto.getPersonalId(), targetDate);
    }

    public void checkUserEmployee(String personalId, Date targetDate) throws MospException {
        for (String userCheck : this.mospParams.getApplicationProperties(APP_CHECK_USER)) {
            if (userCheck.equals(USER_CHECK_ENTRANCE)) {
                this.checkEntrance(personalId, targetDate);
                continue;
            }
            if (userCheck.equals(USER_CHECK_RETIREMENT)) {
                this.checkRetire(personalId, targetDate);
                continue;
            }
            if (!userCheck.equals(USER_CHECK_SUSPENSION)) continue;
            this.checkSuspension(personalId, targetDate);
        }
    }

    public void checkUserRole(String userId, Date targetDate) throws MospException {
        UserMasterDtoInterface dto = this.userMasterDao.findForInfo(userId, targetDate);
        if (dto == null || dto.getInactivateFlag() == 1) {
            this.addUserNotExistMessage();
            return;
        }
        this.checkRoleExist(dto.getRoleCode(), targetDate);
    }

    public void checkRoleExist(String roleCode, Date targetDate) throws MospException {
        String[][] roleArray;
        RoleReferenceBeanInterface roleRefer = (RoleReferenceBeanInterface)this.createBean(RoleReferenceBeanInterface.class);
        for (String[] role : roleArray = roleRefer.getSelectArray(targetDate, false)) {
            if (!role[0].equals(roleCode)) continue;
            return;
        }
        this.addRoleNotExistMessage();
    }

    protected void checkEntrance(String personalId, Date targetDate) throws MospException {
        EntranceReferenceBeanInterface reference = (EntranceReferenceBeanInterface)this.createBean(EntranceReferenceBeanInterface.class);
        if (!reference.isEntered(personalId, targetDate)) {
            HumanReferenceBeanInterface humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
            this.addEmployeeNotEnteredMessage(humanReference.getEmployeeCode(personalId, targetDate));
        }
    }

    protected void checkRetire(String personalId, Date targetDate) throws MospException {
        RetirementReferenceBeanInterface reference = (RetirementReferenceBeanInterface)this.createBean(RetirementReferenceBeanInterface.class);
        if (reference.isRetired(personalId, targetDate)) {
            this.addEmployeeRetiredMessage();
        }
    }

    protected void checkSuspension(String personalId, Date targetDate) throws MospException {
        SuspensionReferenceBeanInterface reference = (SuspensionReferenceBeanInterface)this.createBean(SuspensionReferenceBeanInterface.class);
        if (reference.isSuspended(personalId, targetDate)) {
            this.addEmployeeSuspendedMessage();
        }
    }

    protected void addUserNotExistMessage() {
        this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("User")});
    }

    protected void addRoleNotExistMessage() {
        this.mospParams.addErrorMessage("PFW0201", new String[]{this.mospParams.getName("Role")});
    }

    protected void addEmployeeNotEnteredMessage(String employeeCode) {
        this.mospParams.addErrorMessage("PFW0212", new String[]{employeeCode});
    }
}

