/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.portal.impl;

import java.sql.Connection;
import java.util.Date;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.SeUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.PasswordCheckBeanInterface;
import jp.mosp.platform.dao.system.UserPasswordDaoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;

public class PasswordCheckBean
extends PlatformBean
implements PasswordCheckBeanInterface {
    protected static final String APP_PASSWORD_PERIOD = "PasswordPeriod";
    protected static final String APP_CHECK_PASSWORD = "CheckPassword";
    protected static final String APP_INITIAL_PASSWORD = "InitialPassword";
    protected static final String INITIAL_PASS_USER_ID = "UserId";
    protected static final String PASS_CHECK_INIT_INVALID = "initPasswordInvalid";
    private UserPasswordDaoInterface dao;

    public PasswordCheckBean() {
    }

    public PasswordCheckBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (UserPasswordDaoInterface)this.createDao(UserPasswordDaoInterface.class);
    }

    public void checkPasswordPeriod(String userId, Date targetDate) throws MospException {
        int passwordPeriod = this.mospParams.getApplicationProperty(APP_PASSWORD_PERIOD, Integer.MAX_VALUE);
        UserPasswordDtoInterface dto = this.dao.findForInfo(userId);
        Date periodDate = this.addDay(dto.getChangeDate(), passwordPeriod);
        if (targetDate.compareTo(periodDate) > 0) {
            this.mospParams.addErrorMessage("PFW9113", new String[0]);
        }
    }

    public void checkPasswordStrength(String userId) throws MospException {
        for (String passwordCheck : this.getPasswordCheckProperty()) {
            if (!passwordCheck.equals(PASS_CHECK_INIT_INVALID)) continue;
            this.checkInitInvalid(userId);
        }
    }

    public void checkPasswordChange(String userId, String oldPass, String newPass, String confirmPass) throws MospException {
        if (!confirmPass.equals(newPass)) {
            this.mospParams.addErrorMessage("PFW9115", new String[0]);
            return;
        }
        if (oldPass.equals(newPass)) {
            this.mospParams.addErrorMessage("PFW9112", new String[0]);
            return;
        }
        UserPasswordDtoInterface dto = this.dao.findForInfo(userId);
        if (dto == null || !dto.getPassword().equals(oldPass)) {
            this.mospParams.addErrorMessage("PFW9114", new String[0]);
            return;
        }
    }

    public String getInitialPassword(String userId) {
        String initialPassword = this.mospParams.getApplicationProperty(APP_INITIAL_PASSWORD);
        if (initialPassword == null || initialPassword.isEmpty() || initialPassword.equals(INITIAL_PASS_USER_ID)) {
            return userId;
        }
        return initialPassword;
    }

    public boolean isInitinalPasswordValid() {
        for (String passwordCheck : this.getPasswordCheckProperty()) {
            if (!passwordCheck.equals(PASS_CHECK_INIT_INVALID)) continue;
            return false;
        }
        return true;
    }

    protected void checkInitInvalid(String userId) throws MospException {
        UserPasswordDtoInterface dto = this.dao.findForInfo(userId);
        String initialPassword = SeUtility.encrypt((String)SeUtility.encrypt((String)this.getInitialPassword(userId)));
        if (dto.getPassword().equals(initialPassword)) {
            this.mospParams.addErrorMessage("PFW9117", new String[0]);
        }
    }

    protected String[] getPasswordCheckProperty() {
        String checkPassword = this.mospParams.getApplicationProperty(APP_CHECK_PASSWORD);
        if (checkPassword == null) {
            return new String[0];
        }
        return checkPassword.split(",");
    }
}

