/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.portal.impl;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.portal.HolidayBeanInterface;

public class HolidayBean
extends PlatformBean
implements HolidayBeanInterface {
    protected static final String NAM_COMING_OF_AGE_DAY = "ComingOfAgeDay";
    protected static final String NAM_MARINE_DAY = "MarineDay";
    protected static final String NAM_RESPECT_FOR_THE_AGED_DAY = "RespectForTheAgedDay";
    protected static final String NAM_SPORTS_DAY = "SportsDay";
    protected static final String NAM_VERNAL_EQUINOX_DAY = "VernalEquinoxDay";
    protected static final String NAM_AUTUMNAL_EQUINOX_DAY = "AutumnalEquinoxDay";
    protected static final String NAM_NEW_YEARS_DAY = "NewYearsDay";
    protected static final String NAM_NATIONAL_FOUNDATION_DAY = "NationalFoundationDay";
    protected static final String NAM_SHOWA_DAY = "ShowaDay";
    protected static final String NAM_CONSTITUTION_DAY = "ConstitutionDay";
    protected static final String NAM_GREENERY_DAY = "GreeneryDay";
    protected static final String NAM_CHILDRENS_DAY = "ChildrensDay";
    protected static final String NAM_CULTURE_DAY = "CultureDay";
    protected static final String NAM_LABOR_THANKSGIVING_DAY = "LaborThanksgivingDay";
    protected static final String NAM_EMPERORS_BIRTHDAY = "EmperorsBirthday";
    protected static final String NAM_PEOPLES_DAY = "PeoplesDay";
    protected static final String NAM_OBSERVED_HOLIDAY = "ObservedHoliday";
    protected Map<Date, String> holidayMap;
    protected int year;

    public HolidayBean() {
    }

    public HolidayBean(MospParams actionInfo, Connection connection) {
        super(actionInfo, connection);
    }

    public void initBean() {
    }

    public String getHolidayName(Date targetDate) {
        this.getHolidayMap(targetDate);
        return (String)this.holidayMap.get(targetDate);
    }

    public boolean isHoliday(Date targetDate) {
        this.getHolidayMap(targetDate);
        return this.holidayMap.get(targetDate) != null;
    }

    public Map<Date, String> getHolidayMap(Date targetDate) {
        int targetYear = DateUtility.getYear((Date)targetDate);
        if (this.year == targetYear) {
            return this.holidayMap;
        }
        this.year = targetYear;
        this.createHolidayMap();
        return this.holidayMap;
    }

    protected Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    protected void createHolidayMap() {
        this.addHolidayMap(this.getComingOfAgeDay(), this.mospParams.getName(NAM_COMING_OF_AGE_DAY));
        this.addHolidayMap(this.getMarineDay(), this.mospParams.getName(NAM_MARINE_DAY));
        this.addHolidayMap(this.getRespectForTheAgedDay(), this.mospParams.getName(NAM_RESPECT_FOR_THE_AGED_DAY));
        this.addHolidayMap(this.getSportsDay(), this.mospParams.getName(NAM_SPORTS_DAY));
        this.addHolidayMap(this.getVernalEquinoxDay(), this.mospParams.getName(NAM_VERNAL_EQUINOX_DAY));
        this.addHolidayMap(this.getAutumnalEquinoxDay(), this.mospParams.getName(NAM_AUTUMNAL_EQUINOX_DAY));
        this.addHolidayMap(this.getNewYearsDay(), this.mospParams.getName(NAM_NEW_YEARS_DAY));
        this.addHolidayMap(this.getNationalFoundationDay(), this.mospParams.getName(NAM_NATIONAL_FOUNDATION_DAY));
        this.addHolidayMap(this.getConstitutionDay(), this.mospParams.getName(NAM_CONSTITUTION_DAY));
        this.addHolidayMap(this.getChildrensDay(), this.mospParams.getName(NAM_CHILDRENS_DAY));
        this.addHolidayMap(this.getCultureDay(), this.mospParams.getName(NAM_CULTURE_DAY));
        this.addHolidayMap(this.getLaborThanksgivingDay(), this.mospParams.getName(NAM_LABOR_THANKSGIVING_DAY));
        this.addHolidayMap(this.getEmperorsBirthday(), this.mospParams.getName(NAM_EMPERORS_BIRTHDAY));
        int showaSwitchYear = 2007;
        String midoriName = this.mospParams.getName(NAM_GREENERY_DAY);
        String syouwaName = this.mospParams.getName(NAM_SHOWA_DAY);
        if (this.year < 2007) {
            midoriName = this.mospParams.getName(NAM_PEOPLES_DAY);
            syouwaName = this.mospParams.getName(NAM_GREENERY_DAY);
        }
        this.addHolidayMap(this.getShowaDay(), syouwaName);
        this.addHolidayMap(this.getGreeneryDay(), midoriName);
        this.addSubstituteDate();
    }

    protected void addHolidayMap(Date date, String name) {
        if (this.holidayMap == null) {
            this.holidayMap = new TreeMap();
        }
        this.holidayMap.put(date, name);
    }

    protected void addSubstituteDate() {
        int switchYear = 2006;
        Calendar cal = this.getCalendar();
        Set keySet = this.holidayMap.keySet();
        TreeMap<Date, String> addMap = new TreeMap<Date, String>();
        Date formerHoliday = null;
        for (Date date : keySet) {
            if (DateUtility.isSunday((Date)date)) {
                cal.setTime(date);
                cal.add(5, 1);
                if (this.year > 2006) {
                    while (this.holidayMap.containsKey(cal.getTime())) {
                        cal.add(5, 1);
                    }
                }
                if (!this.holidayMap.containsKey(cal.getTime())) {
                    addMap.put(cal.getTime(), this.mospParams.getName(NAM_OBSERVED_HOLIDAY));
                }
            }
            if (formerHoliday != null) {
                cal.setTime(formerHoliday);
                cal.add(5, 2);
                if (cal.getTime().compareTo(date) == 0) {
                    cal.add(5, -1);
                    addMap.put(cal.getTime(), this.mospParams.getName(NAM_PEOPLES_DAY));
                }
            }
            formerHoliday = date;
        }
        this.holidayMap.putAll(addMap);
    }

    protected Date getComingOfAgeDay() {
        int switchYear = 2000;
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 0);
        if (this.year < 2000) {
            cal.set(5, 15);
        } else {
            cal.set(7, 2);
            cal.set(8, 2);
        }
        return cal.getTime();
    }

    protected Date getMarineDay() {
        int switchYear = 2003;
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 6);
        if (this.year < 2003) {
            cal.set(5, 20);
        } else {
            cal.set(7, 2);
            cal.set(8, 3);
        }
        return cal.getTime();
    }

    protected Date getRespectForTheAgedDay() {
        int switchYear = 2003;
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 8);
        if (this.year < 2003) {
            cal.set(5, 15);
        } else {
            cal.set(7, 2);
            cal.set(8, 3);
        }
        return cal.getTime();
    }

    protected Date getSportsDay() {
        int switchYear = 2000;
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 9);
        if (this.year < 2000) {
            cal.set(5, 10);
        } else {
            cal.set(7, 2);
            cal.set(8, 2);
        }
        return cal.getTime();
    }

    protected Date getVernalEquinoxDay() {
        double param1 = 21.4471;
        double param2 = 0.242377;
        double param3 = 1900.0;
        double param4 = 4.0;
        Calendar cal = this.getCalendar();
        double date = 21.4471 + 0.242377 * ((double)this.year - 1900.0) - Math.floor(((double)this.year - 1900.0) / 4.0);
        int dd = (int)Math.floor(date);
        cal.set(1, this.year);
        cal.set(2, 2);
        cal.set(5, dd);
        return cal.getTime();
    }

    protected Date getAutumnalEquinoxDay() {
        double param1 = 23.8896;
        double param2 = 0.242032;
        double param3 = 1900.0;
        double param4 = 4.0;
        Calendar cal = this.getCalendar();
        double date = 23.8896 + 0.242032 * ((double)this.year - 1900.0) - Math.floor(((double)this.year - 1900.0) / 4.0);
        int dd = (int)Math.floor(date);
        cal.set(1, this.year);
        cal.set(2, 8);
        cal.set(5, dd);
        return cal.getTime();
    }

    protected Date getNewYearsDay() {
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 0);
        cal.set(5, 1);
        return cal.getTime();
    }

    protected Date getNationalFoundationDay() {
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 1);
        cal.set(5, 11);
        return cal.getTime();
    }

    protected Date getConstitutionDay() {
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 4);
        cal.set(5, 3);
        return cal.getTime();
    }

    protected Date getChildrensDay() {
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 4);
        cal.set(5, 5);
        return cal.getTime();
    }

    protected Date getCultureDay() {
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 10);
        cal.set(5, 3);
        return cal.getTime();
    }

    protected Date getLaborThanksgivingDay() {
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 10);
        cal.set(5, 23);
        return cal.getTime();
    }

    protected Date getEmperorsBirthday() {
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 11);
        cal.set(5, 23);
        return cal.getTime();
    }

    protected Date getShowaDay() {
        int dayOfMonth = 29;
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 3);
        cal.set(5, 29);
        return cal.getTime();
    }

    protected Date getGreeneryDay() {
        Calendar cal = this.getCalendar();
        cal.set(1, this.year);
        cal.set(2, 4);
        cal.set(5, 4);
        return cal.getTime();
    }
}

