/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.bean.human.SuspensionRegistBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.SuspensionDaoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanSuspensionDto;

public class SuspensionRegistBean
extends PlatformHumanBean
implements SuspensionRegistBeanInterface {
    SuspensionDaoInterface dao;

    public SuspensionRegistBean() {
    }

    public SuspensionRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (SuspensionDaoInterface)this.createDao(SuspensionDaoInterface.class);
    }

    public SuspensionDtoInterface getInitDto() {
        return new PfaHumanSuspensionDto();
    }

    public List<SuspensionDtoInterface> getInitDtoList(int size) {
        ArrayList<SuspensionDtoInterface> list = new ArrayList<SuspensionDtoInterface>();
        for (int i = 0; i < size; ++i) {
            list.add(this.getInitDto());
        }
        return list;
    }

    public void regist(List<SuspensionDtoInterface> list) throws MospException {
        this.checkRegist(list);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (SuspensionDtoInterface dto : list) {
            if (dto.getPfaHumanSuspensionId() == 0L) {
                this.insert(dto);
                continue;
            }
            this.update(dto);
        }
    }

    public void delete(long[] idArray) throws MospException {
        this.validateAryId(idArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (long id : idArray) {
            this.checkExclusive((BaseDaoInterface)this.dao, id);
            if (this.mospParams.hasErrorMessage()) continue;
            this.logicalDelete((BaseDaoInterface)this.dao, id);
        }
    }

    protected void insert(SuspensionDtoInterface dto) throws MospException {
        dto.setPfaHumanSuspensionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(SuspensionDtoInterface dto) throws MospException {
        SuspensionDtoInterface currentDto = (SuspensionDtoInterface)this.findForKey((BaseDaoInterface)this.dao, dto.getPfaHumanSuspensionId(), true);
        this.checkExclusive((BaseDtoInterface)currentDto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        if (this.isSameDto(dto, currentDto)) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanSuspensionId());
        dto.setPfaHumanSuspensionId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkRegist(List<SuspensionDtoInterface> list) throws MospException {
        String personalId = list.get(0).getPersonalId();
        Date entranceDate = this.getEntranceDate(personalId);
        if (entranceDate == null) {
            this.addEmployeeNotEnteredMessage();
            return;
        }
        Date retirementDate = this.getRetirementDate(personalId);
        for (SuspensionDtoInterface dto : list) {
            if (!this.checkDateOrder(entranceDate, dto.getStartDate(), true)) {
                this.addInvalidOrderMessage(this.getNameEntranceDate(), this.getNameSuspensionStartDate());
            }
            if (!this.checkDateOrder(dto.getEndDate(), retirementDate, true)) {
                this.addInvalidOrderMessage(this.getNameSuspensionEndDate(), this.getNameRetirementDate());
            }
            if (!this.checkDateOrder(dto.getScheduleEndDate(), retirementDate, true)) {
                this.addInvalidOrderMessage(this.getNameSuspensionScheduledEndDate(), this.getNameRetirementDate());
            }
            if (!this.checkDateOrder(dto.getStartDate(), dto.getEndDate(), true)) {
                this.addInvalidOrderMessage(this.getNameSuspensionStartDate(), this.getNameSuspensionEndDate());
            }
            if (this.checkDateOrder(dto.getStartDate(), dto.getScheduleEndDate(), true)) continue;
            this.addInvalidOrderMessage(this.getNameSuspensionStartDate(), this.getNameSuspensionScheduledEndDate());
        }
        for (int i = 0; i < list.size(); ++i) {
            SuspensionDtoInterface dto1 = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                SuspensionDtoInterface dto2 = list.get(j);
                if (this.checkTermDuplicate(dto1.getStartDate(), dto1.getEndDate(), dto2.getStartDate(), dto2.getEndDate())) continue;
                this.addDuplicateTermMessage(this.getNameSuspension());
            }
        }
    }

    protected boolean isSameDto(SuspensionDtoInterface dto1, SuspensionDtoInterface dto2) {
        if (!dto1.getPersonalId().equals(dto2.getPersonalId())) {
            return false;
        }
        if (!this.isSameDate(dto1.getStartDate(), dto2.getStartDate())) {
            return false;
        }
        if (!this.isSameDate(dto1.getScheduleEndDate(), dto2.getScheduleEndDate())) {
            return false;
        }
        if (!this.isSameDate(dto1.getEndDate(), dto2.getEndDate())) {
            return false;
        }
        if (!dto1.getSuspensionReason().equals(dto2.getSuspensionReason())) {
            return false;
        }
        return dto1.getAllowanceType().equals(dto2.getAllowanceType());
    }
}

