/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.HumanRegistBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.impl.PfmHumanDto;

public class HumanRegistBean
extends PlatformHumanBean
implements HumanRegistBeanInterface {
    protected static final int LEN_EMPLOYEE_CODE = 10;
    protected static final int LEN_EMPLOYEE_NAME = 10;
    protected HumanDaoInterface dao;
    protected static final String FORMAT_PERSONAL_ID = "P000000000";
    protected HumanReferenceBeanInterface humanReference;

    public HumanRegistBean() {
    }

    public HumanRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
    }

    public HumanDtoInterface getInitDto() {
        return new PfmHumanDto();
    }

    public void insert(HumanDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPersonalId(this.getPersonalId());
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmHumanId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void add(HumanDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkAdd(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfmHumanId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void update(HumanDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmHumanId());
        dto.setPfmHumanId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(HumanDtoInterface dto) throws MospException {
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfmHumanId());
    }

    protected void checkInsert(HumanDtoInterface dto) throws MospException {
        this.checkDuplicateInsert(this.dao.findForHistory(dto.getPersonalId()));
        this.checkEmployeeCodeDuplicate(dto.getPersonalId(), dto.getEmployeeCode());
    }

    protected void checkAdd(HumanDtoInterface dto) throws MospException {
        this.checkDuplicateAdd((BaseDtoInterface)this.dao.findForKey(dto.getPersonalId(), dto.getActivateDate()));
        this.checkEmployeeCodeDuplicate(dto.getPersonalId(), dto.getEmployeeCode());
    }

    protected void checkUpdate(HumanDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfmHumanId());
        this.checkEmployeeCodeDuplicate(dto.getPersonalId(), dto.getEmployeeCode());
    }

    protected void checkEmployeeCodeDuplicate(String personalId, String employeeCode) throws MospException {
        List list = this.dao.findForEmployeeCode(employeeCode);
        for (HumanDtoInterface dto : list) {
            if (dto.getPersonalId().equals(personalId)) continue;
            this.addEmployeeCodeDuplicateMessage(employeeCode);
            return;
        }
    }

    protected String getPersonalId() throws MospException {
        long seq = this.dao.nextPersonalId();
        return this.issueSequenceNo(seq, FORMAT_PERSONAL_ID);
    }

    protected void validate(HumanDtoInterface dto, Integer row) throws MospException {
        List list = this.humanReference.getHistory(dto.getPersonalId());
        Date startDate = dto.getActivateDate();
        Date endDate = this.getLastDate(dto.getActivateDate(), list);
        this.checkRequired((Object)dto.getEmployeeCode(), this.getNameEmployeeCode(), row);
        this.checkRequired((Object)dto.getActivateDate(), this.getNameActivateDate(), row);
        this.checkRequired((Object)dto.getLastName(), this.getNameLastName(), row);
        this.checkLength(dto.getEmployeeCode(), 10, this.getNameEmployeeCode(), row);
        this.checkLength(dto.getLastName(), 10, this.getNameLastName(), row);
        this.checkLength(dto.getFirstName(), 10, this.getNameFirstName(), row);
        this.checkLength(dto.getLastKana(), 10, this.getNameLastKana(), row);
        this.checkLength(dto.getFirstKana(), 10, this.getNameFirstKana(), row);
        this.checkTypeCode(dto.getEmployeeCode(), this.getNameEmployeeCode(), row);
        this.checkTypeKana(dto.getLastKana(), this.getNameLastKana(), row);
        this.checkTypeKana(dto.getFirstKana(), this.getNameFirstKana(), row);
        this.checkWorkPlace(dto.getWorkPlaceCode(), startDate, endDate, row);
        this.checkEmploymentContract(dto.getEmploymentContractCode(), startDate, endDate, row);
        this.checkSection(dto.getSectionCode(), startDate, endDate, row);
        this.checkPosition(dto.getPositionCode(), startDate, endDate, row);
    }

    protected Date getLastDate(Date targetDate, List<HumanDtoInterface> list) throws MospException {
        Date lastDate = null;
        for (HumanDtoInterface dto : list) {
            if (targetDate.compareTo(dto.getActivateDate()) >= 0 || dto.getActivateDate() == null) continue;
            lastDate = DateUtility.addDay((Date)dto.getActivateDate(), (int)-1);
            break;
        }
        return lastDate;
    }

    protected void addEmployeeCodeDuplicateMessage(String employeeCode) {
        String[] rep = new String[]{this.getNameEmployeeCode(), employeeCode};
        this.mospParams.addErrorMessage("PFW0215", rep);
    }

    protected String getNameLastName() {
        return this.mospParams.getName("LastName");
    }

    protected String getNameFirstName() {
        return this.mospParams.getName("FirstName");
    }

    protected String getNameLastKana() {
        return this.mospParams.getName("LastName") + this.mospParams.getName("FrontParentheses") + this.mospParams.getName("Kana") + this.mospParams.getName("BackParentheses");
    }

    protected String getNameFirstKana() {
        return this.mospParams.getName("FirstName") + this.mospParams.getName("FrontParentheses") + this.mospParams.getName("Kana") + this.mospParams.getName("BackParentheses");
    }
}

