/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanNormalRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.HumanNormalDaoInterface;
import jp.mosp.platform.dto.human.HumanNormalDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanNormalDto;

public class HumanNormalRegistBean
extends PlatformHumanBean
implements HumanNormalRegistBeanInterface {
    HumanNormalDaoInterface dao;
    HumanGeneralBeanInterface humanGeneral;
    HumanReferenceBeanInterface humanReference;

    public HumanNormalRegistBean() {
    }

    public HumanNormalRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanNormalDaoInterface)this.createDao(HumanNormalDaoInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBean(HumanGeneralBeanInterface.class);
        this.humanReference = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
    }

    public HumanNormalDtoInterface getInitDto() {
        return new PfaHumanNormalDto();
    }

    public void regist(String division, String viewKey, String personalId) throws MospException {
        List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                if (itemName.isEmpty()) continue;
                HumanNormalDtoInterface dto = this.dao.findForInfo(itemName, personalId);
                String value = this.mospParams.getRequestParam(itemName);
                if (value == null) {
                    value = "";
                }
                if (dto == null) {
                    dto = this.getInitDto();
                    dto.setPersonalId(personalId);
                    dto.setHumanItemType(itemName);
                    dto.setHumanItemValue(value);
                    this.insert(dto);
                    continue;
                }
                dto.setHumanItemValue(value);
                this.update(dto);
            }
        }
    }

    public void regist(HumanNormalDtoInterface dto) throws MospException {
        HumanNormalDtoInterface normalDto = this.dao.findForInfo(dto.getHumanItemType(), dto.getPersonalId());
        if (normalDto != null) {
            normalDto.setHumanItemValue(dto.getHumanItemValue());
            this.update(normalDto);
        } else {
            this.insert(dto);
        }
    }

    public void insert(HumanNormalDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkInsert(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        dto.setPfaHumanNormalId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    public void delete(HumanNormalDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanNormalId());
    }

    public void delete(String division, String viewKey, String personalId) throws MospException {
        List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                HumanNormalDtoInterface dto;
                if (itemName.isEmpty() || (dto = this.dao.findForInfo(itemName, personalId)) == null) continue;
                this.delete(dto);
            }
        }
    }

    public void deleteDeadInputItem(Set<String> divisions, String viewKey) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (String division : divisions) {
            List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
            for (TableItemProperty tableItem : tableItemList) {
                String[] itemNames;
                for (String itemName : itemNames = tableItem.getItemNames()) {
                    list.add(itemName);
                }
            }
        }
        if (list.isEmpty()) {
            return;
        }
        List listDeleteItem = this.dao.findForInfoNotIn(list);
        for (HumanNormalDtoInterface dto : listDeleteItem) {
            this.delete(dto);
        }
    }

    public void validate(HumanNormalDtoInterface dto, Integer row) throws MospException {
        this.checkRequired((Object)dto.getHumanItemType(), dto.getHumanItemType(), row);
        Date entranceDate = this.getEntranceDate(dto.getPersonalId());
        if (entranceDate == null) {
            this.addEmployeeNotEnteredMessage();
            return;
        }
    }

    public void update(HumanNormalDtoInterface dto) throws MospException {
        this.validate(dto, null);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.checkUpdate(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanNormalId());
        dto.setPfaHumanNormalId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void checkInsert(HumanNormalDtoInterface dto) throws MospException {
        List humanList = this.humanReference.getHistory(dto.getPersonalId());
        if (humanList.isEmpty()) {
            this.humanGeneral.addNotHumanErrorMessage();
        }
    }

    protected void checkUpdate(HumanNormalDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanNormalId());
    }

    protected void checkDelete(HumanNormalDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanNormalId());
    }

    protected void addDeleteEntranceFailedMessage() {
        this.mospParams.addErrorMessage("PFW0216", new String[0]);
    }
}

