/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ConventionProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.xml.ItemProperty;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.HumanHistoryReferenceBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanGeneralBean;
import jp.mosp.platform.dao.human.HumanHistoryDaoInterface;
import jp.mosp.platform.dto.human.HumanHistoryDtoInterface;

public class HumanHistoryReferenceBean
extends HumanGeneralBean
implements HumanHistoryReferenceBeanInterface {
    protected HumanHistoryDaoInterface dao;
    protected HumanGeneralBeanInterface humanGeneral;
    protected ConventionProperty conventionProperty;
    LinkedHashMap<String, Map<String, String>> historyHumanInfoMap;
    Map<String, String> historyMap;
    protected List<TableItemProperty> tableItemList;

    public HumanHistoryReferenceBean() {
    }

    protected HumanHistoryReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanHistoryDaoInterface)this.createDao(HumanHistoryDaoInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBean(HumanGeneralBeanInterface.class);
    }

    public void setCommounInfo(String division, String viewKey) {
        this.conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default");
        this.tableItemList = this.getTableItemList(division, viewKey);
        this.historyHumanInfoMap = new LinkedHashMap();
        this.historyMap = new HashMap();
    }

    public LinkedHashMap<String, Map<String, String>> getHistoryMapInfo(String division, String viewKey, String personalId, Date activeDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                HumanHistoryDtoInterface dto = this.findForKey(personalId, itemName, activeDate);
                if (dto == null) {
                    this.historyMap.put(itemName, "");
                    continue;
                }
                String itemKey = itemKeys[i];
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKey);
                String pulldownValue = this.getPulldownValue(itemProperty, activeDate, dto.getHumanItemValue(), itemName, false);
                if (!pulldownValue.isEmpty()) {
                    this.historyMap.put(itemName, pulldownValue);
                    if (i != itemNames.length - 1) continue;
                    this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dto.getActivateDate()), this.historyMap);
                    continue;
                }
                this.historyMap.put(itemName, dto.getHumanItemValue());
                this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dto.getActivateDate()), this.historyMap);
            }
        }
        return this.historyHumanInfoMap;
    }

    public Map<String, String> getBeforeHumanHistoryMapInfo(String division, String viewKey, String personalId, Date activeDate, Date targetDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                String itemKey;
                ItemProperty itemProperty;
                String pulldownValue;
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                HumanHistoryDtoInterface dto = this.findForInfo(personalId, itemName, activeDate);
                if (dto == null) {
                    List humanList = this.findForHistory(personalId, itemName);
                    if (humanList.isEmpty()) {
                        this.historyMap.put(itemName, "");
                        continue;
                    }
                    dto = (HumanHistoryDtoInterface)humanList.get(0);
                }
                if (!(pulldownValue = this.getPulldownValue(itemProperty = this.conventionProperty.getItem(itemKey = itemKeys[i]), activeDate, dto.getHumanItemValue(), itemName, false)).isEmpty()) {
                    this.historyMap.put(itemName, pulldownValue);
                    continue;
                }
                this.historyMap.put(itemName, dto.getHumanItemValue());
            }
        }
        return this.historyMap;
    }

    public LinkedHashMap<String, Map<String, String>> getHumanHistoryMapInfo(String division, String viewKey, String personalId, Date activeDate, Date targetDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            String[] labelKeys = tableItem.getLabelKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                String itemKey = itemKeys[i];
                String labelKey = labelKeys[i];
                if (itemName.isEmpty()) continue;
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKey);
                String dateTypeValue = this.getSeparateTxtItemHistoryValue(personalId, itemName, itemProperty, activeDate, targetDate, labelKey);
                if (!dateTypeValue.isEmpty()) {
                    HumanHistoryDtoInterface formatTxtDto;
                    this.historyMap.put(itemName, dateTypeValue);
                    HumanHistoryDtoInterface dateDto = this.findForInfo(personalId, itemName + "Year", activeDate);
                    if (dateDto != null) {
                        this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dateDto.getActivateDate()), this.historyMap);
                        continue;
                    }
                    HumanHistoryDtoInterface phoneDto = this.findForInfo(personalId, itemName + "Area", activeDate);
                    if (phoneDto != null) {
                        this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)phoneDto.getActivateDate()), this.historyMap);
                        continue;
                    }
                    String[] aryItemName = MospUtility.split((String)itemName, (String)",");
                    if (aryItemName.length == 0 || (formatTxtDto = this.findForInfo(personalId, aryItemName[0], activeDate)) == null) continue;
                    this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)formatTxtDto.getActivateDate()), this.historyMap);
                    continue;
                }
                HumanHistoryDtoInterface dto = this.findForInfo(personalId, itemName, activeDate);
                if (dto == null) continue;
                String pulldownValue = this.getPulldownValue(itemProperty, activeDate, dto.getHumanItemValue(), itemName, true);
                if (!pulldownValue.isEmpty()) {
                    this.historyMap.put(itemName, pulldownValue);
                    if (i != itemNames.length - 1) continue;
                    this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dto.getActivateDate()), this.historyMap);
                    continue;
                }
                this.historyMap.put(itemName, dto.getHumanItemValue());
                this.historyHumanInfoMap.put(DateUtility.getStringDate((Date)dto.getActivateDate()), this.historyMap);
            }
        }
        return this.historyHumanInfoMap;
    }

    public LinkedHashMap<String, Map<String, String>> getActiveDateHistoryMapInfo(String division, String viewKey, String personalId, Date targetDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        HashSet activeSet = this.getActiveDateList(this.tableItemList, personalId);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemKeys = tableItem.getItemKeys();
            String[] itemNames = tableItem.getItemNames();
            String[] labelKeys = tableItem.getLabelKeys();
            for (Date activeDate : activeSet) {
                for (int i = 0; i < itemNames.length; ++i) {
                    Map<String, String> historyMap;
                    String date = DateUtility.getStringDate((Date)activeDate);
                    ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
                    String dateTypeValue = this.getSeparateTxtItemHistoryValue(personalId, itemNames[i], itemProperty, activeDate, targetDate, labelKeys[i]);
                    if (!dateTypeValue.isEmpty()) {
                        HashMap<String, String> historyMap2 = (HashMap<String, String>)this.historyHumanInfoMap.get(date);
                        if (historyMap2 == null) {
                            historyMap2 = new HashMap<String, String>();
                            this.historyHumanInfoMap.put(date, historyMap2);
                        }
                        historyMap2.put(itemNames[i], dateTypeValue);
                        continue;
                    }
                    HumanHistoryDtoInterface dto = this.findForInfo(personalId, itemNames[i], activeDate);
                    if (dto == null) {
                        this.historyMap.put(itemNames[i], "");
                        continue;
                    }
                    String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemNames[i], true);
                    if (!pulldownValue.isEmpty()) {
                        historyMap = (HashMap<String, String>)this.historyHumanInfoMap.get(date);
                        if (historyMap == null) {
                            historyMap = new HashMap<String, String>();
                            this.historyHumanInfoMap.put(date, historyMap);
                        }
                        historyMap.put(itemNames[i], pulldownValue);
                        continue;
                    }
                    historyMap = (Map)this.historyHumanInfoMap.get(date);
                    if (historyMap == null) {
                        historyMap = new HashMap();
                        this.historyHumanInfoMap.put(date, historyMap);
                    }
                    historyMap.put(dto.getHumanItemType(), dto.getHumanItemValue());
                }
            }
        }
        return this.historyHumanInfoMap;
    }

    public String getHistoryItemValue(String division, String viewKey, String personalId, Date targetDate, String tableItemKey, boolean isPulldownName) throws MospException {
        this.setCommounInfo(division, viewKey);
        HashSet activeSet = this.getActiveDateList(this.tableItemList, personalId);
        for (TableItemProperty tableItem : this.tableItemList) {
            if (!tableItem.getKey().equals(tableItemKey)) continue;
            String[] itemNames = tableItem.getItemNames();
            String[] labelKeys = tableItem.getLabelKeys();
            String[] itemKeys = tableItem.getItemKeys();
            for (Date activeDate : activeSet) {
                int i = 0;
                if (i >= itemKeys.length) continue;
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
                if (itemKeys[i].equals("ActivateDate")) {
                    HumanHistoryDtoInterface dto = this.findForInfo(personalId, itemNames[i], activeDate);
                    if (dto == null) {
                        return "";
                    }
                    return this.getStringDate(dto.getActivateDate());
                }
                String dateTypeValue = this.getSeparateTxtItemHistoryValue(personalId, itemNames[i], itemProperty, activeDate, targetDate, labelKeys[i]);
                if (!dateTypeValue.isEmpty()) {
                    return dateTypeValue;
                }
                HumanHistoryDtoInterface dto = this.findForInfo(personalId, itemNames[i], activeDate);
                if (dto == null) {
                    return "";
                }
                String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemNames[i], isPulldownName);
                if (!pulldownValue.isEmpty()) {
                    return pulldownValue;
                }
                return dto.getHumanItemValue();
            }
        }
        return "";
    }

    public List<HumanHistoryDtoInterface> findForHistory(String personalId, String humanItemType) throws MospException {
        return this.dao.findForHistory(personalId, humanItemType);
    }

    public HumanHistoryDtoInterface findForInfo(String personalId, String humanItemType, Date targetDate) throws MospException {
        return this.dao.findForInfo(personalId, humanItemType, targetDate);
    }

    public HumanHistoryDtoInterface findForKey(String personalId, String humanItemType, Date activateDate) throws MospException {
        return this.dao.findForKey(personalId, humanItemType, activateDate);
    }

    public HashSet<Date> getActiveDateList(List<TableItemProperty> tableItemList, String personalId) throws MospException {
        ArrayList<Date> activeDateList = new ArrayList<Date>();
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                String[] itemNameSplit;
                for (String item : itemNameSplit = MospUtility.split((String)itemName, (String)",")) {
                    List valueList = this.findForHistory(personalId, item);
                    for (HumanHistoryDtoInterface dto : valueList) {
                        activeDateList.add(dto.getActivateDate());
                    }
                }
            }
        }
        HashSet<Date> activeDateSet = new HashSet<Date>();
        activeDateSet.addAll(activeDateList);
        return activeDateSet;
    }

    public String[] getArrayActiveDate(LinkedHashMap<String, Map<String, String>> activeDateHistoryMapInfo) {
        ArrayList<String> activeList = new ArrayList<String>(activeDateHistoryMapInfo.keySet());
        String[] arrayActiveDate = new String[activeList.size()];
        if (activeList.isEmpty()) {
            return arrayActiveDate;
        }
        Collections.sort(activeList);
        for (int i = 0; i < activeList.size(); ++i) {
            arrayActiveDate[i] = (String)activeList.get(activeList.size() - i - 1);
        }
        return arrayActiveDate;
    }
}

