/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanArrayRegistBeanInterface;
import jp.mosp.platform.bean.human.HumanGeneralBeanInterface;
import jp.mosp.platform.bean.human.base.PlatformHumanBean;
import jp.mosp.platform.dao.human.HumanArrayDaoInterface;
import jp.mosp.platform.dto.human.HumanArrayDtoInterface;
import jp.mosp.platform.dto.human.impl.PfaHumanArrayDto;

public class HumanArrayRegistBean
extends PlatformHumanBean
implements HumanArrayRegistBeanInterface {
    HumanArrayDaoInterface dao;
    HumanGeneralBeanInterface humanGeneral;

    public HumanArrayRegistBean() {
    }

    public HumanArrayRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanArrayDaoInterface)this.createDao(HumanArrayDaoInterface.class);
        this.humanGeneral = (HumanGeneralBeanInterface)this.createBean(HumanGeneralBeanInterface.class);
    }

    public HumanArrayDtoInterface getInitDto() {
        return new PfaHumanArrayDto();
    }

    public void regist(String division, String viewKey, String personalId, Date activeDate, int rowId) throws MospException {
        int newRowId = this.getRowId();
        List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                if (itemName.isEmpty()) continue;
                HumanArrayDtoInterface dto = this.dao.findForKey(personalId, itemName, rowId);
                String value = this.mospParams.getRequestParam(itemName);
                if (value == null) {
                    value = "";
                }
                if (dto == null) {
                    int rowRegistId = rowId;
                    if (rowRegistId == 0) {
                        rowRegistId = newRowId;
                    }
                    dto = this.getInitDto();
                    dto.setPersonalId(personalId);
                    dto.setHumanItemType(itemName);
                    dto.setHumanRowId(rowRegistId);
                    dto.setActivateDate(activeDate);
                    dto.setHumanItemValue(value);
                    this.insert(dto);
                    this.mospParams.addGeneralParam("ArrayRowId", (Object)String.valueOf(newRowId));
                    if (!this.mospParams.hasErrorMessage()) continue;
                    return;
                }
                dto.setHumanItemValue(value);
                this.update(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                return;
            }
        }
    }

    public void delete(String division, String viewKey, String personalId, Date activeDate, int rowId) throws MospException {
        List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                HumanArrayDtoInterface dto;
                if (itemName.isEmpty() || (dto = this.dao.findForKey(personalId, itemName, rowId)) == null) continue;
                this.delete(dto);
                if (!this.mospParams.hasErrorMessage()) continue;
                return;
            }
        }
    }

    public void deleteDeadInputItem(Set<String> divisions, String viewKey) throws MospException {
        ArrayList<String> list = new ArrayList<String>();
        for (String division : divisions) {
            List tableItemList = this.humanGeneral.getTableItemList(division, viewKey);
            for (TableItemProperty tableItem : tableItemList) {
                String[] itemNames;
                for (String itemName : itemNames = tableItem.getItemNames()) {
                    list.add(itemName);
                }
            }
        }
        if (list.isEmpty()) {
            return;
        }
        List listDeleteItem = this.dao.findForInfoNotIn(list);
        for (HumanArrayDtoInterface dto : listDeleteItem) {
            this.delete(dto);
        }
    }

    public void delete(HumanArrayDtoInterface dto) throws MospException {
        this.checkDelete(dto);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId());
    }

    public int getRowId() throws MospException {
        int rowId = this.dao.findForMaxRowId();
        return ++rowId;
    }

    private void checkDelete(HumanArrayDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId());
    }

    public void insert(HumanArrayDtoInterface dto) throws MospException {
        dto.setPfaHumanArrayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }

    protected void update(HumanArrayDtoInterface dto) throws MospException {
        HumanArrayDtoInterface arrayDto = (HumanArrayDtoInterface)this.findForKey((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId(), true);
        this.checkExclusive((BaseDtoInterface)arrayDto);
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId());
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaHumanArrayId());
        dto.setPfaHumanArrayId(this.dao.nextRecordId());
        this.dao.insert((BaseDtoInterface)dto);
    }
}

