/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.human.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.property.ConventionProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.xml.ItemProperty;
import jp.mosp.framework.xml.TableItemProperty;
import jp.mosp.platform.bean.human.HumanArrayReferenceBeanInterface;
import jp.mosp.platform.bean.human.impl.HumanGeneralBean;
import jp.mosp.platform.dao.human.HumanArrayDaoInterface;
import jp.mosp.platform.dto.human.HumanArrayDtoInterface;

public class HumanArrayReferenceBean
extends HumanGeneralBean
implements HumanArrayReferenceBeanInterface {
    private HumanArrayDaoInterface dao;
    protected ConventionProperty conventionProperty;
    protected List<TableItemProperty> tableItemList;
    LinkedHashMap<String, Map<String, String>> arrayHumanInfoMap;
    Map<String, String> arrayMap;

    public HumanArrayReferenceBean() {
    }

    protected HumanArrayReferenceBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.dao = (HumanArrayDaoInterface)this.createDao(HumanArrayDaoInterface.class);
    }

    public List<HumanArrayDtoInterface> findForItemType(String personalId, String humanItemType) throws MospException {
        return this.dao.findForItemType(personalId, humanItemType);
    }

    public HumanArrayDtoInterface findForKey(String personalId, String humanItemType, int rowId) throws MospException {
        return this.dao.findForKey(personalId, humanItemType, rowId);
    }

    public void setCommounInfo(String division, String viewKey) {
        this.conventionProperty = (ConventionProperty)this.mospParams.getProperties().getConventionProperties().get("Default");
        this.tableItemList = this.getTableItemList(division, viewKey);
        this.arrayHumanInfoMap = new LinkedHashMap();
        this.arrayMap = new HashMap();
    }

    public LinkedHashMap<String, Map<String, String>> getHumanArrayMapInfo(String division, String viewKey, String personalId, int rowID) throws MospException {
        this.setCommounInfo(division, viewKey);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            for (int i = 0; i < itemNames.length; ++i) {
                String itemName = itemNames[i];
                if (itemName.isEmpty()) continue;
                HumanArrayDtoInterface dto = this.findForKey(personalId, itemName, rowID);
                if (dto == null) {
                    this.arrayMap.put(itemName, "");
                    continue;
                }
                String itemKey = itemKeys[i];
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKey);
                String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemName, false);
                if (!pulldownValue.isEmpty()) {
                    this.arrayMap.put(itemName, pulldownValue);
                }
                this.arrayMap.put(itemName, dto.getHumanItemValue());
                this.arrayMap.put("activeDate", DateUtility.getStringDate((Date)dto.getActivateDate()));
                this.arrayHumanInfoMap.put(String.valueOf(rowID), this.arrayMap);
            }
        }
        return this.arrayHumanInfoMap;
    }

    public LinkedHashMap<String, Map<String, String>> getRowIdArrayMapInfo(String division, String viewKey, String personalId, Date targetDate) throws MospException {
        this.setCommounInfo(division, viewKey);
        List rowIdSet = this.getRowIdList(this.tableItemList, personalId);
        for (TableItemProperty tableItem : this.tableItemList) {
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            String[] labelKeys = tableItem.getLabelKeys();
            for (Integer rowId : rowIdSet) {
                for (int i = 0; i < itemNames.length; ++i) {
                    Map<String, String> arrayMap;
                    String[] arySplitItemName;
                    HumanArrayDtoInterface dto;
                    String labelKey;
                    String mapRowId = String.valueOf(rowId);
                    ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
                    String dateTypeValue = this.getSeparateTxtItemArrayValue(personalId, itemNames[i], itemProperty, mapRowId, targetDate, labelKey = labelKeys[i]);
                    if (!dateTypeValue.isEmpty()) {
                        HashMap<String, String> arrayMap2 = (HashMap<String, String>)this.arrayHumanInfoMap.get(mapRowId);
                        if (arrayMap2 == null) {
                            arrayMap2 = new HashMap<String, String>();
                            this.arrayHumanInfoMap.put(mapRowId, arrayMap2);
                        }
                        arrayMap2.put(itemNames[i], dateTypeValue);
                    }
                    if ((dto = this.findForKey(personalId, itemNames[i], rowId.intValue())) == null) {
                        dto = this.findForKey(personalId, itemNames[i] + "Year", rowId.intValue());
                    }
                    if (dto == null) {
                        dto = this.findForKey(personalId, itemNames[i] + "Area", rowId.intValue());
                    }
                    if (dto == null && (arySplitItemName = MospUtility.split((String)itemNames[i], (String)",")).length != 0) {
                        dto = this.findForKey(personalId, arySplitItemName[0], rowId.intValue());
                    }
                    if (dto == null) continue;
                    String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemNames[i], true);
                    if (!pulldownValue.isEmpty()) {
                        arrayMap = (HashMap<String, String>)this.arrayHumanInfoMap.get(mapRowId);
                        if (arrayMap == null) {
                            arrayMap = new HashMap<String, String>();
                            this.arrayHumanInfoMap.put(mapRowId, arrayMap);
                        }
                        arrayMap.put(itemNames[i], pulldownValue);
                        continue;
                    }
                    arrayMap = (Map)this.arrayHumanInfoMap.get(mapRowId);
                    if (arrayMap == null) {
                        arrayMap = new HashMap();
                        this.arrayHumanInfoMap.put(mapRowId, arrayMap);
                    }
                    arrayMap.put(dto.getHumanItemType(), dto.getHumanItemValue());
                    arrayMap.put("activeDate", DateUtility.getStringDate((Date)dto.getActivateDate()));
                }
            }
        }
        return this.arrayHumanInfoMap;
    }

    public String getArrayItemValue(String division, String viewKey, String personalId, Date targetDate, String tableItemKey, boolean isPulldownName) throws MospException {
        this.setCommounInfo(division, viewKey);
        List rowIdSet = this.getRowIdList(this.tableItemList, personalId);
        for (TableItemProperty tableItem : this.tableItemList) {
            if (!tableItem.getKey().equals(tableItemKey)) continue;
            String[] itemNames = tableItem.getItemNames();
            String[] itemKeys = tableItem.getItemKeys();
            String[] labelKeys = tableItem.getLabelKeys();
            for (Integer rowId : rowIdSet) {
                int i = 0;
                if (i >= itemNames.length) continue;
                String mapRowId = String.valueOf(rowId);
                ItemProperty itemProperty = this.conventionProperty.getItem(itemKeys[i]);
                String labelKey = labelKeys[i];
                if (labelKey.equals("ActivateDate")) {
                    HumanArrayDtoInterface dto = this.findForKey(personalId, itemNames[i], rowId.intValue());
                    if (dto == null) {
                        return "";
                    }
                    return this.getStringDate(dto.getActivateDate());
                }
                String dateTypeValue = this.getSeparateTxtItemArrayValue(personalId, itemNames[i], itemProperty, mapRowId, targetDate, labelKey);
                if (!dateTypeValue.isEmpty()) {
                    return dateTypeValue;
                }
                HumanArrayDtoInterface dto = this.findForKey(personalId, itemNames[i], rowId.intValue());
                if (dto == null) {
                    return "";
                }
                String pulldownValue = this.getPulldownValue(itemProperty, dto.getActivateDate(), dto.getHumanItemValue(), itemNames[i], true);
                if (!pulldownValue.isEmpty()) {
                    return pulldownValue;
                }
                return dto.getHumanItemType();
            }
        }
        return "";
    }

    public List<Integer> getRowIdList(List<TableItemProperty> tableItemList, String personalId) throws MospException {
        ArrayList<Integer> rowIdList = new ArrayList<Integer>();
        for (TableItemProperty tableItem : tableItemList) {
            String[] itemNames;
            for (String itemName : itemNames = tableItem.getItemNames()) {
                String[] aryItemName;
                List valueList = this.dao.findForItemType(personalId, itemName);
                if (valueList.isEmpty()) {
                    valueList = this.findForItemType(personalId, itemName + "Year");
                }
                if (valueList.isEmpty()) {
                    valueList = this.findForItemType(personalId, itemName + "Area");
                }
                if (valueList.isEmpty() && (aryItemName = MospUtility.split((String)itemName, (String)",")).length != 0) {
                    valueList = this.findForItemType(personalId, aryItemName[0]);
                }
                for (int i = 0; i < valueList.size() - 1; ++i) {
                    int j = i + 1;
                    while (j < valueList.size()) {
                        if (((HumanArrayDtoInterface)valueList.get(i)).getHumanRowId() == ((HumanArrayDtoInterface)valueList.get(j)).getHumanRowId()) {
                            valueList.remove(j);
                            continue;
                        }
                        ++j;
                    }
                }
                for (HumanArrayDtoInterface dto : valueList) {
                    rowIdList.add(dto.getHumanRowId());
                }
            }
        }
        return rowIdList;
    }

    public String[] getArrayActiveDate(LinkedHashMap<String, Map<String, String>> rowIdArrayMapInfo) {
        ArrayList<String> rowIdList = new ArrayList<String>(rowIdArrayMapInfo.keySet());
        String[] arrayRowId = new String[rowIdList.size()];
        if (rowIdList.isEmpty()) {
            return arrayRowId;
        }
        Collections.sort(rowIdList);
        for (int i = 0; i < rowIdList.size(); ++i) {
            arrayRowId[i] = (String)rowIdList.get(i);
        }
        return arrayRowId;
    }
}

