/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.utils.SeUtility;
import jp.mosp.platform.bean.file.UserImportBeanInterface;
import jp.mosp.platform.bean.human.HumanReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserMasterReferenceBeanInterface;
import jp.mosp.platform.bean.system.UserPasswordRegistBeanInterface;
import jp.mosp.platform.bean.system.impl.UserMasterRegistBean;
import jp.mosp.platform.dto.file.ImportDtoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.system.UserMasterDtoInterface;
import jp.mosp.platform.dto.system.UserPasswordDtoInterface;

public class UserImportBean
extends UserMasterRegistBean
implements UserImportBeanInterface {
    protected UserMasterReferenceBeanInterface userMasterRefer;
    protected HumanReferenceBeanInterface humanRefer;
    protected UserPasswordRegistBeanInterface userPasswordRegist;
    protected List<UserMasterDtoInterface> userList;

    public UserImportBean() {
    }

    public UserImportBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        super.initBean();
        this.userMasterRefer = (UserMasterReferenceBeanInterface)this.createBean(UserMasterReferenceBeanInterface.class);
        this.humanRefer = (HumanReferenceBeanInterface)this.createBean(HumanReferenceBeanInterface.class);
        this.userPasswordRegist = (UserPasswordRegistBeanInterface)this.createBean(UserPasswordRegistBeanInterface.class);
    }

    public int importFile(ImportDtoInterface importDto, InputStream requestedFile) throws MospException {
        List dataList = this.getDataList(importDto, requestedFile);
        this.getTargetLists(importDto, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return 0;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            this.registUserMasterDto((UserMasterDtoInterface)this.userList.get(i));
        }
        return this.userList.size();
    }

    protected void getTargetLists(ImportDtoInterface importDto, List<String[]> dataList) throws MospException {
        this.userList = new ArrayList();
        List fieldList = this.getImportFieldList(importDto.getImportCode());
        this.checkCsvLength(fieldList, dataList);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        for (int i = 0; i < dataList.size(); ++i) {
            String[] data = dataList.get(i);
            UserMasterDtoInterface userMasterDto = this.getUserMasterDto(fieldList, data, i);
            if (userMasterDto == null) continue;
            this.userList.add(userMasterDto);
        }
    }

    protected UserMasterDtoInterface getUserMasterDto(List<ImportFieldDtoInterface> fieldList, String[] data, int row) throws MospException {
        String userId = this.getFieldValue("user_id", fieldList, data);
        Date activateDate = this.getDateFieldValue("activate_date", fieldList, data);
        String employeeCode = this.getFieldValue("employee_code", fieldList, data);
        String roleCode = this.getFieldValue("role_code", fieldList, data);
        if (userId == null || userId.isEmpty()) {
            this.addRequiredErrorMessage(this.getNameUserId(), Integer.valueOf(row));
            return null;
        }
        if (activateDate == null) {
            this.addRequiredErrorMessage(this.getNameActivateDate(), Integer.valueOf(row));
            return null;
        }
        UserMasterDtoInterface userMaster = this.userMasterRefer.getUserInfo(userId, activateDate);
        if (userMaster == null) {
            userMaster = this.getInitDto();
        }
        userMaster.setUserId(userId);
        userMaster.setActivateDate(activateDate);
        if (roleCode != null) {
            userMaster.setRoleCode(roleCode);
        } else if (userMaster.getRoleCode() == null) {
            userMaster.setRoleCode("");
        }
        if (employeeCode != null) {
            String personalId = this.humanRefer.getPersonalId(employeeCode, activateDate);
            if (userMaster.getPersonalId() != null && !userMaster.getPersonalId().equals(personalId)) {
                this.addUserIdDuplicateMessage(userId);
                return null;
            }
            userMaster.setPersonalId(personalId);
        }
        this.validate(userMaster, Integer.valueOf(row));
        return userMaster;
    }

    protected void registUserMasterDto(UserMasterDtoInterface userMaster) throws MospException {
        if (userMaster == null) {
            return;
        }
        List list = this.userMasterRefer.getUserHistory(userMaster.getUserId());
        if (list.isEmpty()) {
            this.insert(userMaster);
            UserPasswordDtoInterface userPasswordDto = this.userPasswordRegist.getInitDto();
            userPasswordDto.setUserId(userMaster.getUserId());
            userPasswordDto.setPassword(SeUtility.encrypt((String)SeUtility.encrypt((String)userMaster.getUserId())));
            userPasswordDto.setChangeDate(userMaster.getActivateDate());
            this.userPasswordRegist.regist(userPasswordDto);
            return;
        }
        UserMasterDtoInterface dto = this.userMasterRefer.findForKey(userMaster.getUserId(), userMaster.getActivateDate());
        if (dto == null) {
            this.add(userMaster);
            return;
        }
        this.update(userMaster);
    }

    protected void addUserIdDuplicateMessage(String userId) {
        String[] rep = new String[]{this.getNameUserId(), userId};
        this.mospParams.addErrorMessage("PFW0215", rep);
    }
}

