/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.bean.file.impl;

import java.sql.Connection;
import java.util.List;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.platform.base.PlatformBean;
import jp.mosp.platform.bean.file.ImportFieldRegistBeanInterface;
import jp.mosp.platform.dao.file.ImportFieldDaoInterface;
import jp.mosp.platform.dto.file.ImportFieldDtoInterface;
import jp.mosp.platform.dto.file.impl.PfaImportFieldDto;

public class ImportFieldRegistBean
extends PlatformBean
implements ImportFieldRegistBeanInterface {
    ImportFieldDaoInterface dao;

    public ImportFieldRegistBean() {
    }

    public ImportFieldRegistBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    public void initBean() throws MospException {
        this.dao = (ImportFieldDaoInterface)this.createDao(ImportFieldDaoInterface.class);
    }

    public ImportFieldDtoInterface getInitDto() {
        return new PfaImportFieldDto();
    }

    public void insert(String importCode, String inactivateFlag, String[] fieldArray) throws MospException {
        this.validateAryField(fieldArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        ImportFieldDtoInterface dto = this.getInitDto();
        int i = 0;
        for (String fieldName : fieldArray) {
            this.setDtoFields(dto, importCode, inactivateFlag, fieldName, ++i);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkInsert(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setPfaImportFieldId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void update(String importCode, String inactivateFlag, String[] fieldArray) throws MospException {
        this.validateAryField(fieldArray);
        if (this.mospParams.hasErrorMessage()) {
            return;
        }
        List list = this.dao.findForList(importCode);
        for (ImportFieldDtoInterface dto : list) {
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaImportFieldId());
        }
        ImportFieldDtoInterface dto = this.getInitDto();
        int i = 0;
        for (String fieldName : fieldArray) {
            this.setDtoFields(dto, importCode, inactivateFlag, fieldName, ++i);
            this.validate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.checkUpdate(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            dto.setPfaImportFieldId(this.dao.nextRecordId());
            this.dao.insert((BaseDtoInterface)dto);
        }
    }

    public void delete(String importCode) throws MospException {
        List list = this.dao.findForList(importCode);
        for (ImportFieldDtoInterface dto : list) {
            this.checkDelete(dto);
            if (this.mospParams.hasErrorMessage()) {
                return;
            }
            this.logicalDelete((BaseDaoInterface)this.dao, dto.getPfaImportFieldId());
        }
    }

    protected void checkInsert(ImportFieldDtoInterface dto) throws MospException {
        this.checkDuplicateInsert((BaseDtoInterface)this.dao.findForKey(dto.getImportCode(), dto.getFieldName()));
    }

    protected void checkUpdate(ImportFieldDtoInterface dto) {
    }

    protected void checkDelete(ImportFieldDtoInterface dto) throws MospException {
        this.checkExclusive((BaseDaoInterface)this.dao, dto.getPfaImportFieldId());
        if (!this.isDtoActivate((BaseDtoInterface)dto)) {
            return;
        }
    }

    protected void validate(ImportFieldDtoInterface dto) {
    }

    protected void validateAryField(String[] aryField) {
        if (aryField == null || aryField.length == 0) {
            this.mospParams.addErrorMessage("PFW0102", new String[]{this.mospParams.getName("Select", new String[]{"Item"})});
        }
    }

    protected void setDtoFields(ImportFieldDtoInterface dto, String importCode, String inactivateFlag, String fieldName, int i) {
        dto.setImportCode(importCode);
        dto.setFieldName(fieldName);
        dto.setFieldOrder(i);
        dto.setInactivateFlag(Integer.parseInt(inactivateFlag));
    }
}

