/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.platform.base;

import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseBean;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.property.RangeProperty;
import jp.mosp.framework.utils.CapsuleUtility;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.utils.MessageUtility;
import jp.mosp.framework.utils.MospUtility;
import jp.mosp.framework.utils.ValidateUtility;
import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.dao.human.HumanDaoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.utils.PlatformMessageUtility;
import jp.mosp.platform.utils.PlatformUtility;

public abstract class PlatformBean
extends BaseBean {
    protected static final String STR_SB_SAPCE = " ";
    protected static final String STR_DB_SAPCE = "\u3000";
    protected static final String SEPARATOR_DATA = ",";

    public PlatformBean() {
    }

    protected PlatformBean(MospParams mospParams, Connection connection) {
        super(mospParams, connection);
    }

    protected void checkExclusive(BaseDaoInterface dao, long id) throws MospException {
        this.checkExclusive((BaseDtoInterface)this.findForKey(dao, id, false));
    }

    protected void checkExclusive(BaseDtoInterface dto) throws MospException {
        if (dto == null || dto.getDeleteFlag() == 1) {
            this.addExclusiveErrorMessage();
        }
    }

    protected void checkDuplicateInsert(List<?> list) {
        if (!list.isEmpty()) {
            this.mospParams.addErrorMessage("PFW0204", new String[0]);
        }
    }

    protected void checkDuplicateInsert(BaseDtoInterface dto) {
        if (dto != null) {
            this.mospParams.addErrorMessage("PFW0204", new String[0]);
        }
    }

    protected void checkDuplicateAdd(BaseDtoInterface dto) {
        if (dto != null) {
            this.mospParams.addErrorMessage("PFW0205", new String[0]);
        }
    }

    protected String[][] getNoObjectDataPulldown() {
        String[][] aryPulldown = new String[][]{{"", this.mospParams.getProperties().getName("NoObjectData")}};
        return aryPulldown;
    }

    protected Date getDateClone(Date date) {
        return CapsuleUtility.getDateClone((Date)date);
    }

    protected String[] getStringArrayClone(String[] array) {
        return CapsuleUtility.getStringArrayClone((String[])array);
    }

    protected String[][] getStringArrayClone(String[][] array) {
        return CapsuleUtility.getStringArrayClone((String[][])array);
    }

    protected void validateAryId(long[] aryId) {
        if (aryId == null || aryId.length == 0) {
            this.mospParams.addErrorMessage("PFW0103", new String[0]);
        }
    }

    protected List<HumanDtoInterface> getHumanListForCheck(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) throws MospException {
        HumanDaoInterface humanDao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        List humanList = humanDao.findForActivateDate(dto.getActivateDate());
        humanList.addAll(humanDao.findForTerm(dto.getActivateDate(), this.getNextActivateDate(dto.getActivateDate(), list)));
        return humanList;
    }

    protected boolean needCheckTermForAdd(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) {
        int idx;
        for (idx = 0; idx < list.size(); ++idx) {
            PlatformDtoInterface historyDto = list.get(idx);
            if (dto.getActivateDate().compareTo(historyDto.getActivateDate()) <= 0) break;
        }
        if (idx == 0) {
            return true;
        }
        return this.isDtoActivate((BaseDtoInterface)list.get(idx - 1));
    }

    protected boolean needCheckTermForDelete(PlatformDtoInterface dto, List<? extends PlatformDtoInterface> list) {
        for (int idx = 0; idx < list.size(); ++idx) {
            PlatformDtoInterface historyDto = list.get(idx);
            if (dto.getActivateDate().compareTo(historyDto.getActivateDate()) != 0) continue;
            if (idx == 0 || !this.isDtoActivate((BaseDtoInterface)list.get(idx - 1))) break;
            return false;
        }
        return true;
    }

    protected Date getEffectiveLastDate(Date targetDate, List<? extends PlatformDtoInterface> list) throws MospException {
        Date effectiveLastDate = this.getNextActivateDate(targetDate, list);
        if (effectiveLastDate != null) {
            effectiveLastDate = DateUtility.addDay((Date)effectiveLastDate, (int)-1);
        }
        return effectiveLastDate;
    }

    protected Date getNextActivateDate(Date targetDate, List<? extends PlatformDtoInterface> list) {
        Date lastDate = null;
        for (PlatformDtoInterface platformDtoInterface : list) {
            if (targetDate.compareTo(platformDtoInterface.getActivateDate()) >= 0) continue;
            lastDate = platformDtoInterface.getActivateDate();
            break;
        }
        return lastDate;
    }

    protected HumanDtoInterface getHumanInfo(String personalId, Date targetDate) throws MospException {
        HumanDaoInterface dao = (HumanDaoInterface)this.createDao(HumanDaoInterface.class);
        return dao.findForInfo(personalId, targetDate);
    }

    protected HumanDtoInterface getUserHumanInfo(Date targetDate) throws MospException {
        if (targetDate == null) {
            return this.getUserHumanInfo();
        }
        if (this.mospParams.getUser() == null) {
            return null;
        }
        String personalId = this.mospParams.getUser().getPersonalId();
        return this.getHumanInfo(personalId, targetDate);
    }

    protected HumanDtoInterface getUserHumanInfo() throws MospException {
        if (this.mospParams.getUser() == null) {
            return null;
        }
        String personalId = this.mospParams.getUser().getPersonalId();
        return this.getHumanInfo(personalId, this.getSystemDate());
    }

    protected String[] getRangeWorkPlace(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeWorkPlace = range.getWorkPlace();
        if (rangeWorkPlace == null || rangeWorkPlace.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeWorkPlace, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getWorkPlaceCode().isEmpty()) continue;
            array[i] = dto.getWorkPlaceCode();
        }
        return array;
    }

    protected String[] getRangeEmploymentContract(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeEmployment = range.getEmploymentContract();
        if (rangeEmployment == null || rangeEmployment.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeEmployment, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getEmploymentContractCode().isEmpty()) continue;
            array[i] = dto.getEmploymentContractCode();
        }
        return array;
    }

    protected String[] getRangeSection(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeSection = range.getSection();
        if (rangeSection == null || rangeSection.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeSection, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getSectionCode().isEmpty()) continue;
            array[i] = dto.getSectionCode();
        }
        return array;
    }

    protected String[] getRangePosition(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangePosition = range.getPosition();
        if (rangePosition == null || rangePosition.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangePosition, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getPositionCode().isEmpty()) continue;
            array[i] = dto.getPositionCode();
        }
        return array;
    }

    protected String[] getRangeEmployee(String operationType, Date targetDate) throws MospException {
        if (operationType == null) {
            return new String[0];
        }
        RangeProperty range = (RangeProperty)this.mospParams.getStoredInfo().getRangeMap().get(operationType);
        if (range == null) {
            return new String[0];
        }
        String rangeEmployee = range.getEmployee();
        if (rangeEmployee == null || rangeEmployee.isEmpty()) {
            return new String[0];
        }
        String[] array = this.split(rangeEmployee, SEPARATOR_DATA);
        for (int i = 0; i < array.length; ++i) {
            HumanDtoInterface dto;
            if (!array[i].equals("RangeMyself") || (dto = this.getUserHumanInfo(targetDate)) == null || dto.getPersonalId().isEmpty()) continue;
            array[i] = dto.getPersonalId();
        }
        return array;
    }

    protected boolean isDtoActivate(BaseDtoInterface dto) {
        return ((PlatformDtoInterface)dto).getInactivateFlag() == 0;
    }

    protected boolean isDtoDeleted(BaseDtoInterface dto) {
        return dto.getDeleteFlag() == 1;
    }

    protected String getCodeName(String code, String[][] array) {
        return MospUtility.getCodeName((String)code, (String[][])array);
    }

    protected String getCodeName(String code, String codeKey) {
        String[][] array = this.mospParams.getProperties().getCodeArray(codeKey, false);
        return MospUtility.getCodeName((String)code, (String[][])array);
    }

    protected String getCodeName(int code, String codeKey) {
        return this.getCodeName(String.valueOf(code), codeKey);
    }

    protected boolean isSameDate(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 == null) {
            return false;
        }
        return date1.equals(date2);
    }

    protected Date getSystemDate() {
        return DateUtility.getSystemDate();
    }

    protected Date getSystemTime() {
        return DateUtility.getSystemTime();
    }

    protected Date getSystemTimeAndSecond() {
        return DateUtility.getSystemTimeAndSecond();
    }

    protected Date addDay(Date date, int amount) {
        return DateUtility.addDay((Date)date, (int)amount);
    }

    protected String getStringDate(Date date) {
        return DateUtility.getStringDate((Date)date);
    }

    protected boolean checkDateOrder(Date before, Date after, boolean acceptSameDate) {
        if (before == null || after == null) {
            return true;
        }
        if (acceptSameDate && before.equals(after)) {
            return true;
        }
        return before.before(after);
    }

    protected boolean checkTermDuplicate(Date start1, Date end1, Date start2, Date end2) {
        if (end1 == null && end2 == null) {
            return !start1.equals(start2);
        }
        if (end1 == null) {
            return start1.before(start2) || start1.after(end2);
        }
        if (end2 == null) {
            return start2.before(start1) || start2.after(end1);
        }
        return start1.before(end2) || end1.after(start2);
    }

    protected void addNoCodeBeforeActivateDateMessage(String code) {
        this.mospParams.addErrorMessage("PFW0210", new String[]{code});
    }

    protected void addCodeIsUsedMessage(String code, HumanDtoInterface dto) {
        this.mospParams.addErrorMessage("PFW0207", new String[]{code, dto.getEmployeeCode()});
    }

    protected void addInvalidOrderMessage(String before, String after) {
        this.mospParams.addErrorMessage("PFW0217", new String[]{after, before});
    }

    protected boolean isForwardMatch(String condition, String value) {
        return PlatformUtility.isForwardMatch((String)condition, (String)value);
    }

    protected boolean isBroadMatch(String condition, String value) {
        return PlatformUtility.isBroadMatch((String)condition, (String)value);
    }

    protected boolean isExactMatch(String condition, String value) {
        return PlatformUtility.isExactMatch((String)condition, (String)value);
    }

    protected boolean isHumanNameMatch(String condition, String firstName, String lastName) throws MospException {
        if (this.isBroadMatch(condition, firstName)) {
            return true;
        }
        if (this.isBroadMatch(condition, lastName)) {
            return true;
        }
        if (this.isBroadMatch(condition, lastName + firstName)) {
            return true;
        }
        return this.isBroadMatch(condition, MospUtility.getHumansName((String)firstName, (String)lastName));
    }

    public void sortList(List<?> list, Class<?> cls, boolean isReverse) throws MospException {
        this.sortList(list, cls.getName(), isReverse);
    }

    public void sortList(List<?> list, String className, boolean isReverse) throws MospException {
        Comparator comp = InstanceFactory.loadComparator((String)className);
        if (isReverse) {
            comp = Collections.reverseOrder(comp);
        }
        Collections.sort(list, comp);
    }

    protected String[][] prepareSelectArray(int length, boolean needBlank) {
        if (!needBlank) {
            return new String[length][2];
        }
        String[][] array = new String[length + 1][2];
        array[0][0] = "";
        array[0][1] = "";
        return array;
    }

    protected String getCodedName(String code, String name, int length) {
        int i;
        StringBuffer sb = new StringBuffer();
        int doubleBytes = (length - code.length() + 1) / 2;
        int singleBytes = (length - code.length() + 1) % 2;
        sb.append(code);
        for (i = 0; i < doubleBytes; ++i) {
            sb.append(STR_DB_SAPCE);
        }
        for (i = 0; i < singleBytes; ++i) {
            sb.append(STR_SB_SAPCE);
        }
        sb.append(name);
        return sb.toString();
    }

    protected List<String> asList(String target, String regex) {
        return MospUtility.asList((String[])this.split(target, regex));
    }

    protected String[] split(String target, String regex) {
        return MospUtility.split((String)target, (String)regex);
    }

    protected String toSeparatedString(List<String> list, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String str : list) {
            sb.append(str);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    protected String toSeparatedString(String[] array, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String str : array) {
            sb.append(str);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    protected String issueSequenceNo(long sequenceNo, String format) {
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(sequenceNo);
    }

    protected Integer getInteger(String value) {
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected Double getDouble(String value) {
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected void checkRequired(Object value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRequired((Object)value)) {
            this.addRequiredErrorMessage(fieldName, row);
        }
    }

    protected void checkLength(String value, int maxLength, String fieldName, Integer row) {
        if (!ValidateUtility.chkLength((String)value, (int)maxLength)) {
            this.addMaxLengthErrorMessage(fieldName, maxLength, row);
        }
    }

    protected void checkByteLength(String value, int maxLength, String fieldName, Integer row) {
        if (!ValidateUtility.chkByteLength((String)value, (int)maxLength)) {
            this.addByteMaxLengthErrorMessage(fieldName, maxLength, row);
        }
    }

    protected void checkUserId(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[._@A-Za-z0-9-]*", (String)value)) {
            this.addUserIdErrorMessage(fieldName, row);
        }
    }

    protected void checkTypeCode(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[A-Za-z0-9]*", (String)value)) {
            this.addTypeCodeErrorMessage(fieldName, row);
        }
    }

    protected void checkTypeKana(String value, String fieldName, Integer row) {
        if (!ValidateUtility.chkRegex((String)"[\uff61-\uff9f -~]*", (String)value)) {
            this.addTypeKanaErrorMessage(fieldName, row);
        }
    }

    protected void checkInactivateFlag(int value, Integer row) {
        if (value != 0 && value != 1) {
            MessageUtility.addErrorMessageActivateOrInactivateInvalid((MospParams)this.mospParams, (Integer)row);
        }
    }

    protected void checkDeleteFlag(int value, Integer row) {
        if (value != 0 && value != 1) {
            MessageUtility.addErrorMessageDeleteFlagInvalid((MospParams)this.mospParams, (Integer)row);
        }
    }

    protected void checkFlag(int value, String fieldName, Integer row) {
        if (!PlatformUtility.isFlagOff((int)value) && !PlatformUtility.isFlagOn((int)value)) {
            MessageUtility.addErrorMessageFlagInvalid((MospParams)this.mospParams, (String)fieldName, (Integer)row);
        }
    }

    protected void checkUnderLimit(double value, String fieldName, int limit, Integer row) {
        if (value < (double)limit) {
            MessageUtility.addErrorMessageUnderLimit((MospParams)this.mospParams, (String)fieldName, (int)limit, (Integer)row);
        }
    }

    protected void checkOverLimit(double value, String fieldName, int limit, Integer row) {
        if (value > (double)limit) {
            MessageUtility.addErrorMessageOverLimit((MospParams)this.mospParams, (String)fieldName, (int)limit, (Integer)row);
        }
    }

    protected void addInputDataInvalidErrorMessage() {
        this.mospParams.addErrorMessage("PFW0101", new String[0]);
    }

    protected void addRequiredErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0102", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addMaxLengthErrorMessage(String fieldName, int maxLength, Integer row) {
        String[] rep = new String[]{this.getRowedFieldName(fieldName, row), String.valueOf(maxLength)};
        this.mospParams.addErrorMessage("PFW0123", rep);
    }

    protected void addByteMaxLengthErrorMessage(String fieldName, int maxLength, Integer row) {
        int halfLength = maxLength / 2;
        String[] rep = new String[]{this.getRowedFieldName(fieldName, row), String.valueOf(halfLength), String.valueOf(maxLength)};
        this.mospParams.addErrorMessage("PFW0126", rep);
    }

    protected void addUserIdErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0125", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addTypeCodeErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0111", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addTypeKanaErrorMessage(String fieldName, Integer row) {
        this.mospParams.addErrorMessage("PFW0115", new String[]{this.getRowedFieldName(fieldName, row)});
    }

    protected void addExclusiveErrorMessage() {
        this.mospParams.addErrorMessage("PFW0206", new String[0]);
    }

    protected void addNotEntranceErrorMessage() {
        this.mospParams.addErrorMessage("PFW0203", new String[]{this.mospParams.getName("Joined")});
    }

    protected void addEmployeeRetiredMessage() {
        PlatformMessageUtility.addErrorEmployeeRetired((MospParams)this.mospParams, null);
    }

    protected void addEmployeeSuspendedMessage() {
        PlatformMessageUtility.addErrorEmployeeSuspended((MospParams)this.mospParams, null);
    }

    protected String getRowedFieldName(String fieldName, Integer row) {
        if (row == null) {
            return fieldName;
        }
        return this.getRowColonName(row.intValue()) + fieldName;
    }

    protected String getRowColonName(int row) {
        return this.mospParams.getName("Row") + String.valueOf(row + 1) + this.mospParams.getName("Colon");
    }

    protected String getNameEmployeeCode() {
        return this.mospParams.getName("Employee", new String[]{"Code"});
    }

    protected String getNameActivateDate() {
        return this.mospParams.getName("ActivateDate");
    }

    protected String getNameSection() {
        return this.mospParams.getName("Section");
    }

    protected String getNamePosition() {
        return this.mospParams.getName("Position");
    }
}

