/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.jasperreport;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import jp.mosp.framework.base.BaseExporter;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospExporterInterface;
import jp.mosp.framework.base.MospParams;
import jp.mosp.jasperreport.JasperReportIntermediate;
import jp.mosp.jasperreport.JasperReportUtility;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;

public class JasperReportExporter
extends BaseExporter
implements MospExporterInterface {
    public void export(MospParams mospParams, HttpServletResponse response) throws MospException {
        block8: {
            this.setFileContentType(mospParams, response);
            this.setFileName(mospParams, response);
            Object file = mospParams.getFile();
            if (file instanceof JasperReportIntermediate) {
                JasperReportIntermediate intermediate = (JasperReportIntermediate)file;
                String prefix = intermediate.getFilePrefix();
                if (mospParams.getFileName() == null && prefix != null) {
                    response.addHeader("Content-Disposition", mospParams.getApplicationProperty("Content-Disposition") + prefix + ".pdf");
                }
                file = JasperReportUtility.createJasperPrint((String)(mospParams.getApplicationProperty("Docbase") + intermediate.getTemplatePath()), (List)intermediate.getList());
            }
            JRPdfExporter exporter = null;
            if (file instanceof JasperPrint) {
                exporter = new JRPdfExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, file);
            } else if (file instanceof JRExporter) {
                exporter = (JRExporter)file;
            } else {
                throw new MospException("FWE9121");
            }
            try {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)response.getOutputStream());
                exporter.exportReport();
            }
            catch (Exception e) {
                if (this.isClientAbortException(e)) break block8;
                throw new MospException((Throwable)e, "FWE9121", null);
            }
        }
    }
}

