/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.util.Date;
import java.util.Map;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.property.ModelProperty;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.framework.xml.NodeWrapper;
import jp.mosp.framework.xml.TagConverterInterface;
import jp.mosp.framework.xml.TagUtility;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelTagConverter
implements TagConverterInterface {
    private static final String TAG_MODEL_ACTIVATE_DATE = "ModelActivateDate";
    private static final String TAG_MODEL_CLASS = "ModelClass";

    public void put(Map<String, BaseProperty> properties, NodeWrapper wrapper) {
        Node node = wrapper.getNode();
        int index = wrapper.index;
        String path = wrapper.path;
        String key = TagUtility.getKey((Node)node);
        if (key.isEmpty()) {
            TagUtility.noElementKeyMessage((String)path, (Node)node, (int)index);
            return;
        }
        ModelProperty modelProperty = (ModelProperty)properties.get(key);
        if (modelProperty == null) {
            modelProperty = new ModelProperty(key);
            properties.put(key, (BaseProperty)modelProperty);
        }
        Date modelActivateDate = null;
        String modelClass = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            if (!item.hasChildNodes() || !(item instanceof Element)) continue;
            Element lowerElement = (Element)item;
            if (TagUtility.isTag((Node)item, (String)TAG_MODEL_ACTIVATE_DATE)) {
                modelActivateDate = DateUtility.getDate((String)TagUtility.trimText((Node)lowerElement));
                continue;
            }
            if (!TagUtility.isTag((Node)item, (String)TAG_MODEL_CLASS)) continue;
            modelClass = TagUtility.trimText((Node)lowerElement);
        }
        if (modelClass == null) {
            modelClass = TagUtility.trimText((Node)node);
        }
        if (modelClass == null) {
            TagUtility.invalidItemMassage((String)path, (Node)node, (String)TAG_MODEL_CLASS, (int)index);
            return;
        }
        if (modelActivateDate == null) {
            modelProperty.setModelClass(modelClass);
        } else {
            modelProperty.getModelClassMap().put(modelActivateDate, modelClass);
        }
    }
}

