/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.util.Map;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.property.MessageProperty;
import jp.mosp.framework.xml.NodeWrapper;
import jp.mosp.framework.xml.TagConverterInterface;
import jp.mosp.framework.xml.TagUtility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageTagConverter
implements TagConverterInterface {
    private static final String TAG_MESSAGE_BODY = "MessageBody";
    private static final String TAG_CLIENT_AVAILABLE = "ClientAvailable";

    public void put(Map<String, BaseProperty> properties, NodeWrapper wrapper) {
        Node node = wrapper.getNode();
        int index = wrapper.index;
        String path = wrapper.path;
        String key = TagUtility.getKey((Node)node);
        if (key.isEmpty()) {
            TagUtility.noElementKeyMessage((String)path, (Node)node, (int)index);
            return;
        }
        String messageBody = null;
        boolean clientAvailable = false;
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int itemIndex = 0; itemIndex < length; ++itemIndex) {
            Node item = list.item(itemIndex);
            if (TagUtility.isTag((Node)item, (String)TAG_MESSAGE_BODY)) {
                messageBody = TagUtility.trimText((Node)item);
            }
            if (!TagUtility.isTag((Node)item, (String)TAG_CLIENT_AVAILABLE)) continue;
            clientAvailable = Boolean.parseBoolean(TagUtility.trimText((Node)item));
        }
        if (messageBody == null) {
            TagUtility.invalidMassage((String)path, (Node)node);
            return;
        }
        properties.put(key, (BaseProperty)new MessageProperty(key, messageBody, clientAvailable));
    }
}

