/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.xml;

import java.util.Map;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.property.MainMenuProperty;
import jp.mosp.framework.property.MenuProperty;
import jp.mosp.framework.xml.NodeWrapper;
import jp.mosp.framework.xml.TagConverterInterface;
import jp.mosp.framework.xml.TagUtility;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MainMenuTagConverter
implements TagConverterInterface {
    private static final String TAG_MENU = "Menu";
    private static final String TAG_COMMAND = "Command";
    private static final String TAG_VO_CLASS = "VoClass";
    private static final String TAG_MENU_VALID = "MenuValid";

    public void put(Map<String, BaseProperty> properties, NodeWrapper wrapper) {
        Node node = wrapper.getNode();
        int index = wrapper.index;
        String path = wrapper.path;
        String key = TagUtility.getKey((Node)node);
        if (key.isEmpty()) {
            TagUtility.noElementKeyMessage((String)path, (Node)node, (int)index);
            return;
        }
        NodeList menuList = TagUtility.getElements((String)TAG_MENU, (Object)node);
        if (menuList.getLength() == 0) {
            TagUtility.invalidMassage((String)path, (Node)node);
            return;
        }
        BaseProperty baseProperty = properties.get(key);
        if (baseProperty == null) {
            baseProperty = new MainMenuProperty(key);
        }
        MainMenuProperty property = (MainMenuProperty)baseProperty;
        Map menuMap = property.getMenuMap();
        int length = menuList.getLength();
        for (int itemIndex = 0; itemIndex < length; ++itemIndex) {
            Node item = menuList.item(itemIndex);
            MenuProperty menu = this.toMenuProperty(item);
            if (menu == null) {
                TagUtility.invalidItemMassage((String)path, (Node)node, (String)TAG_MENU, (int)itemIndex);
                continue;
            }
            menuMap.put(menu.getKey(), menu);
        }
        properties.put(key, (BaseProperty)property);
    }

    protected MenuProperty toMenuProperty(Node item) {
        String key = TagUtility.getKey((Node)item);
        if (key.isEmpty()) {
            return null;
        }
        String command = null;
        String voClass = null;
        boolean menuValid = true;
        NodeList list = item.getChildNodes();
        int length = list.getLength();
        for (int index = 0; index < length; ++index) {
            Node menuItem = list.item(index);
            if (TagUtility.isTag((Node)menuItem, (String)TAG_COMMAND)) {
                command = TagUtility.trimText((Node)menuItem);
            }
            if (TagUtility.isTag((Node)menuItem, (String)TAG_VO_CLASS)) {
                voClass = TagUtility.trimText((Node)menuItem);
            }
            if (!TagUtility.isTag((Node)menuItem, (String)TAG_MENU_VALID)) continue;
            menuValid = Boolean.parseBoolean(TagUtility.trimText((Node)menuItem));
        }
        if (menuValid && (command == null || voClass == null)) {
            return null;
        }
        return new MenuProperty(key, command, voClass, menuValid);
    }
}

