/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ValidateUtility {
    private ValidateUtility() {
    }

    public static boolean chkRequired(Object value) {
        if (value instanceof String) {
            return !value.equals("");
        }
        return value != null;
    }

    public static boolean chkRegex(String regex, String value) {
        return value.matches(regex);
    }

    public static boolean chkNumeric(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(year, month, day);
        try {
            calendar.getTime();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkTime(int hour, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.set(1970, 0, 1, hour, minute, second);
        try {
            calendar.getTime();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean chkTerm(Date date, Date startDate, Date endDate) {
        return startDate.compareTo(date) <= 0 && endDate.compareTo(date) >= 0;
    }

    public static boolean chkLength(String value, int maxLength) {
        String regex = "(?s).{0," + String.valueOf(maxLength) + "}";
        return ValidateUtility.chkRegex((String)regex, (String)value);
    }

    public static boolean chkByteLength(String value, int maxLength) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        try {
            return value.getBytes("Shift-JIS").length <= maxLength;
        }
        catch (UnsupportedEncodingException e) {
            return value.getBytes().length <= maxLength;
        }
    }
}

