/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserAgentUtility {
    private UserAgentUtility() {
    }

    public static String getUserAgent(MospParams mospParams) {
        Object userAgent = mospParams.getGeneralParam("USER-AGENT");
        if (userAgent == null) {
            return "";
        }
        return String.valueOf(userAgent);
    }

    public static boolean isIE(String userAgent) {
        Pattern pattern = Pattern.compile(".*((MSIE)+ [0-9]+\\.[0-9]+).*");
        Matcher matcher = pattern.matcher(userAgent);
        return matcher.matches();
    }

    public static boolean isFirefox(String userAgent) {
        Pattern pattern = Pattern.compile(".*((Firefox/)+[0-9]+\\.[0-9]+\\.?[0-9]*).*");
        Matcher matcher = pattern.matcher(userAgent);
        return matcher.matches();
    }

    public static boolean isChrome(String userAgent) {
        Pattern pattern = Pattern.compile(".*((Chrome)+/?[0-9]+\\.?[0-9]*).*");
        Matcher matcher = pattern.matcher(userAgent);
        return matcher.matches();
    }

    public static boolean isSafari(String userAgent) {
        Pattern pattern = Pattern.compile(".*((Version/)+[0-9]+\\.?[0-9]*\\.?[0-9]* Safari).*");
        Matcher matcher = pattern.matcher(userAgent);
        return matcher.matches();
    }

    public static boolean isOpera(String userAgent) {
        Pattern pattern = Pattern.compile(".*((Opera)+/? ?[0-9]+\\.[0-9]*).*");
        Matcher matcher = pattern.matcher(userAgent);
        return matcher.matches();
    }

    public static String getExportFileName(MospParams mospParams) throws MospException {
        String userAgent = UserAgentUtility.getUserAgent((MospParams)mospParams);
        String fileName = mospParams.getFileName();
        if (mospParams.getFileName() == null) {
            return "";
        }
        try {
            if (UserAgentUtility.isIE((String)userAgent)) {
                return URLEncoder.encode(fileName, "UTF-8");
            }
            if (UserAgentUtility.isFirefox((String)userAgent) || UserAgentUtility.isChrome((String)userAgent) || UserAgentUtility.isSafari((String)userAgent) || UserAgentUtility.isOpera((String)userAgent)) {
                return new String(fileName.getBytes(), "ISO-8859-1");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MospException((Throwable)e);
        }
        return fileName;
    }
}

