/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.constant.MospConst;
import jp.mosp.framework.property.MessageProperty;
import jp.mosp.framework.property.ModelProperty;
import jp.mosp.framework.property.MospProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MospUtility {
    public static final String[] SUFFIX_ARRAY = new String[]{"BeanInterface", "Bean", "Interface"};
    public static final char CHR_SEPARATOR_SPACE = ' ';
    public static final String WILD_CARD_COMMAND = "*";

    private MospUtility() {
    }

    public static String getModelClass(Class<?> cls, MospProperties mospProperties, Date targetDate) throws MospException {
        String modelKey = MospUtility.getModelKey(cls);
        Map modelProperties = mospProperties.getModelProperties();
        ModelProperty modelProperty = (ModelProperty)modelProperties.get(modelKey);
        if (modelProperty == null) {
            throw new MospException((Throwable)new Exception(), "FWE9104", modelKey);
        }
        if (targetDate == null) {
            return modelProperty.getModelClass();
        }
        Map modelClassMap = modelProperty.getModelClassMap();
        ArrayList keyList = new ArrayList(modelClassMap.keySet());
        Collections.sort(keyList);
        Collections.reverse(keyList);
        for (Date key : keyList) {
            if (key.after(targetDate)) continue;
            return (String)modelClassMap.get(key);
        }
        return modelProperty.getModelClass();
    }

    protected static String getModelKey(Class<?> cls) {
        String key = cls.getSimpleName();
        for (String suffix : SUFFIX_ARRAY) {
            if (key.indexOf(suffix) != key.length() - suffix.length()) continue;
            key = key.replace(suffix, "");
            break;
        }
        return key;
    }

    public static void outputMessageJs(MospProperties mospProperties) throws MospException {
        String path = mospProperties.getApplicationProperty("Docbase") + "/pub/common/js/message.js";
        String name = "messages";
        Map messageProperties = mospProperties.getMessageProperties();
        StringBuffer sb = new StringBuffer();
        sb.append("var ");
        sb.append("messages");
        sb.append(" = new Object();");
        sb.append(MospConst.LINE_SEPARATOR);
        for (Map.Entry entry : messageProperties.entrySet()) {
            MessageProperty messageProperty = (MessageProperty)entry.getValue();
            if (!messageProperty.getClientAvailable()) continue;
            sb.append("messages");
            sb.append("[\"");
            sb.append(messageProperty.getKey());
            sb.append("\"] = \"");
            sb.append(messageProperty.getMessageBody());
            sb.append("\";");
            sb.append(MospConst.LINE_SEPARATOR);
        }
        MospUtility.outputFile((MospProperties)mospProperties, (String)path, (String)sb.toString());
    }

    public static String getCodeItemCode(String code, String[][] array) {
        if (code == null) {
            return "";
        }
        for (String[] element : array) {
            if (!element[0].equals(code)) continue;
            return element[0];
        }
        return code;
    }

    public static String getCodeName(String code, String[][] array) {
        if (code == null) {
            return "";
        }
        for (String[] element : array) {
            if (!element[0].equals(code)) continue;
            return element[1];
        }
        return code;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void outputFile(MospProperties mospProperties, String path, String body) throws MospException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(path, false);
            osw = new OutputStreamWriter((OutputStream)fos, mospProperties.getApplicationProperty("CharacterEncoding"));
            osw.write(body);
            return;
        }
        catch (FileNotFoundException e) {
            throw new MospException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new MospException((Throwable)e);
        }
        catch (IOException e) {
            throw new MospException((Throwable)e);
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e) {
                throw new MospException((Throwable)e);
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    throw new MospException((Throwable)e);
                }
            }
        }
    }

    public static String getHumansName(String firstName, String lastName) {
        return MospUtility.concat((String[])new String[]{lastName, firstName});
    }

    public static String concat(String ... strs) {
        return MospUtility.concat((char)' ', (String[])strs);
    }

    public static String concat(char separator, String ... strs) {
        StringBuffer sb = new StringBuffer();
        if (strs == null) {
            return sb.toString();
        }
        for (String str : strs) {
            if (str == null || str.isEmpty()) continue;
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static String[] split(String target, String regex) {
        if (target.trim().isEmpty()) {
            return new String[0];
        }
        String[] array = target.split(regex);
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }

    public static String getWildCardCommand(String command) {
        String wildCardCommand = command.replaceAll("\\*", "");
        if (wildCardCommand.isEmpty()) {
            return wildCardCommand;
        }
        return wildCardCommand.substring(0, wildCardCommand.length() - 1) + "*";
    }

    public static List<String> asList(String[] array) {
        return Arrays.asList(array);
    }

    public static String[] toArray(List<String> list) {
        return list.toArray(new String[1]);
    }

    public static String toSeparatedString(String[] array, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String str : array) {
            sb.append(str);
            sb.append(separator);
        }
        if (sb.length() > 0) {
            sb.delete(sb.lastIndexOf(separator), sb.length());
        }
        return sb.toString();
    }

    public static String substring(String value, int length) {
        if (value == null || value.isEmpty() || length < 0) {
            return "";
        }
        if (value.length() < length) {
            return value;
        }
        return value.substring(0, length);
    }

    public static String getStackTrace(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String msg = sw.toString();
        msg = msg.replaceAll(MospConst.LINE_SEPARATOR, "");
        return msg;
    }
}

