/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.utils;

import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.log.LoggerInterface;
import jp.mosp.framework.log.MospLogger;
import jp.mosp.framework.utils.MospUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogUtility {
    public static final String APP_LOG_SEPARATOR = "LogSeparator";
    protected static final String APP_LOG_TYPE_CONTROLLER_INIT = "LogTypeControllerInit";
    protected static final String APP_LOG_TYPE_ACCESS = "LogTypeAccess";
    protected static final String APP_LOG_TYPE_ACTION_START = "LogTypeActionStart";
    protected static final String APP_LOG_TYPE_ACTION_END = "LogTypeActionEnd";
    protected static final String APP_LOG_TYPE_DB_CONNECT = "LogTypeDbConnect";
    protected static final String APP_LOG_TYPE_SQL_SELECT = "LogTypeSqlSelect";
    protected static final String APP_LOG_TYPE_SQL_REGIST = "LogTypeSqlRegist";
    protected static final String APP_LOG_TYPE_INTERNAL_CONTROL = "LogTypeInternalControl";
    protected static final String APP_LOG_TYPE_ERROR = "LogTypeError";
    protected static final String APP_LOG_TYPE_APPLICATION = "LogTypeApplication";
    protected static final String APP_LOG_TYPE_DEBUG = "LogTypeDebug";
    protected static final String APP_LOG_TYPE_GENERAL = "LogTypeGeneral";
    protected static final String APP_LOG_LEVEL_CONTROLLER_INIT = "LogLevelControllerInit";
    protected static final String APP_LOG_LEVEL_ACCESS = "LogLevelAccess";
    protected static final String APP_LOG_LEVEL_ACTION_START = "LogLevelActionStart";
    protected static final String APP_LOG_LEVEL_ACTION_END = "LogLevelActionEnd";
    protected static final String APP_LOG_LEVEL_DB_CONNECT = "LogLevelDbConnect";
    protected static final String APP_LOG_LEVEL_SQL_SELECT = "LogLevelSqlSelect";
    protected static final String APP_LOG_LEVEL_SQL_REGIST = "LogLevelSqlRegist";
    protected static final String APP_LOG_LEVEL_INTERNAL_CONTROL = "LogLevelInternalControl";
    protected static final String APP_LOG_LEVEL_ERROR = "LogLevelError";
    protected static final String APP_LOG_LEVEL_APPLICATION = "LogLevelApplication";
    protected static final String APP_LOG_LEVEL_DEBUG = "LogLevelDebug";

    private LogUtility() {
    }

    protected static LoggerInterface loadLogger(String loggerName, MospParams mospParams) {
        LoggerInterface logger = mospParams.getLogger(loggerName);
        if (logger != null) {
            return logger;
        }
        try {
            logger = (LoggerInterface)InstanceFactory.loadInstance((String)loggerName);
            logger.setLogger(mospParams);
        }
        catch (MospException e) {
            e.printStackTrace();
            logger = new MospLogger();
            logger.setLogger(mospParams);
        }
        mospParams.putLogger(loggerName, logger);
        return logger;
    }

    protected static String getLogMessage(MospParams mospParams, String logType, String message) {
        StringBuffer log = new StringBuffer();
        log.append(logType);
        log.append(mospParams.getApplicationProperty("LogSeparator"));
        log.append(mospParams.getUser() == null ? "" : mospParams.getUser().getAspUserId());
        log.append(mospParams.getApplicationProperty("LogSeparator"));
        log.append(mospParams.getUser() == null ? "" : mospParams.getUser().getUserId());
        log.append(mospParams.getApplicationProperty("LogSeparator"));
        log.append(mospParams.getCommand() == null ? "" : mospParams.getCommand());
        log.append(mospParams.getApplicationProperty("LogSeparator"));
        log.append(message);
        return log.toString();
    }

    public static void controllerInit(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeControllerInit", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeControllerInit")) {
            int level = mospParams.getApplicationProperty("LogLevelControllerInit", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void access(MospParams mospParams) {
        StringBuffer sb = new StringBuffer();
        sb.append(mospParams.getGeneralParam("REMOTE-ADDR"));
        sb.append(mospParams.getApplicationProperty("LogSeparator"));
        sb.append(mospParams.getGeneralParam("USER-AGENT"));
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeAccess", (String)sb.toString());
        for (String loggerName : mospParams.getApplicationProperties("LogTypeAccess")) {
            int level = mospParams.getApplicationProperty("LogLevelAccess", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void actionStart(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeActionStart", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeActionStart")) {
            int level = mospParams.getApplicationProperty("LogLevelActionStart", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void actionEnd(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeActionEnd", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeActionEnd")) {
            int level = mospParams.getApplicationProperty("LogLevelActionEnd", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void dbConnect(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeDbConnect", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeDbConnect")) {
            int level = mospParams.getApplicationProperty("LogLevelDbConnect", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void sqlSelect(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeSqlSelect", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeSqlSelect")) {
            int level = mospParams.getApplicationProperty("LogLevelSqlSelect", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void sqlRegist(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeSqlRegist", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeSqlRegist")) {
            int level = mospParams.getApplicationProperty("LogLevelSqlRegist", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void internalControl(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeInternalControl", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeInternalControl")) {
            int level = mospParams.getApplicationProperty("LogLevelInternalControl", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void error(MospParams mospParams, Throwable thrown) {
        String message = MospUtility.getStackTrace((Throwable)thrown);
        message = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeError", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeError")) {
            int level = mospParams.getApplicationProperty("LogLevelError", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, message);
        }
    }

    public static void application(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeApplication", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeApplication")) {
            int level = mospParams.getApplicationProperty("LogLevelApplication", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void debug(MospParams mospParams, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeDebug", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeDebug")) {
            int level = mospParams.getApplicationProperty("LogLevelDebug", 0);
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }

    public static void log(MospParams mospParams, int level, String message) {
        String msg = LogUtility.getLogMessage((MospParams)mospParams, (String)"LogTypeGeneral", (String)message);
        for (String loggerName : mospParams.getApplicationProperties("LogTypeGeneral")) {
            LogUtility.loadLogger((String)loggerName, (MospParams)mospParams).log(level, msg);
        }
    }
}

