/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.mosp.framework.property.BaseProperty;
import jp.mosp.framework.xml.ViewProperty;
import jp.mosp.framework.xml.ViewTableProperty;

public class ViewConfigProperty
implements BaseProperty,
Serializable {
    private static final long serialVersionUID = 1179191540418935336L;
    private String key;
    private String type;
    private Map<String, BaseProperty> view;
    private Map<String, BaseProperty> viewTable;
    private boolean isHumanExist;

    public ViewConfigProperty(String key) {
        this.key = key;
        this.view = new HashMap();
        this.viewTable = new HashMap();
        this.isHumanExist = false;
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void put(BaseProperty property) {
        if (property instanceof ViewProperty) {
            this.view.put(property.getKey(), property);
        }
        if (property instanceof ViewTableProperty) {
            this.viewTable.put(property.getKey(), property);
        }
    }

    public ViewProperty getView(String key) {
        BaseProperty property = (BaseProperty)this.view.get(key);
        return property != null ? (ViewProperty)property : null;
    }

    public ViewTableProperty getViewTable(String key) {
        BaseProperty property = (BaseProperty)this.viewTable.get(key);
        return property != null ? (ViewTableProperty)property : null;
    }

    public List<ViewTableProperty> getViewTableList(String key) {
        ArrayList<ViewTableProperty> list = new ArrayList<ViewTableProperty>();
        ViewProperty property = this.getView(key);
        if (property == null) {
            return list;
        }
        for (String viewTableKey : property.getViewTableKeys()) {
            ViewTableProperty tableProperty = this.getViewTable(viewTableKey);
            if (tableProperty == null) continue;
            list.add(tableProperty);
        }
        return list;
    }

    public boolean isHumanExist() {
        return this.isHumanExist;
    }

    public void setHumanExist(boolean isHumanExist) {
        this.isHumanExist = isHumanExist;
    }
}

