/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import jp.mosp.framework.comparator.IndexComparator;
import jp.mosp.framework.property.AddonProperty;
import jp.mosp.framework.property.ApplicationProperty;
import jp.mosp.framework.property.CodeItemProperty;
import jp.mosp.framework.property.CodeProperty;
import jp.mosp.framework.property.CommandProperty;
import jp.mosp.framework.property.ConventionProperty;
import jp.mosp.framework.property.MainMenuProperty;
import jp.mosp.framework.property.MessageProperty;
import jp.mosp.framework.property.ModelProperty;
import jp.mosp.framework.property.NamingProperty;
import jp.mosp.framework.property.RoleProperty;
import jp.mosp.framework.property.ViewConfigProperty;
import jp.mosp.framework.utils.MospUtility;

public class MospProperties {
    private Map<String, ApplicationProperty> applicationProperties;
    private Map<String, CommandProperty> commandProperties;
    private Map<String, ModelProperty> modelProperties;
    private Map<String, MessageProperty> messageProperties;
    private Map<String, NamingProperty> namingProperties;
    private Map<String, CodeProperty> codeProperties;
    private Map<String, AddonProperty> addonProperties;
    private Map<String, MainMenuProperty> mainMenuProperties;
    private Map<String, RoleProperty> roleProperties;
    private Map<String, ConventionProperty> conventionProperties;
    private Map<String, ViewConfigProperty> viewConfigProperties;

    public CommandProperty getCommandProperty(String command) {
        CommandProperty property = (CommandProperty)this.commandProperties.get(command);
        if (property != null) {
            return property;
        }
        if (command == null || command.isEmpty()) {
            return property;
        }
        property = (CommandProperty)this.commandProperties.get(MospUtility.getWildCardCommand((String)command));
        if (property != null) {
            return property;
        }
        return property;
    }

    public String getApplicationProperty(String key) {
        ApplicationProperty property = (ApplicationProperty)this.applicationProperties.get(key);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public int getApplicationProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getApplicationProperty(key));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getApplicationPropertyBool(String key) {
        return Boolean.parseBoolean(this.getApplicationProperty(key));
    }

    public String[] getApplicationProperties(String key) {
        String property = this.getApplicationProperty(key);
        if (property == null || property.isEmpty()) {
            return new String[0];
        }
        String value = property.replaceAll("\r\n", "\n").replaceAll("[\n|\r|\t]", "");
        return value.split(",");
    }

    public void setApplicationProperty(String key, String value) {
        this.applicationProperties.put(key, new ApplicationProperty(key, value));
    }

    public Map<String, ModelProperty> getModelProperties() {
        return this.modelProperties;
    }

    public Map<String, MessageProperty> getMessageProperties() {
        return this.messageProperties;
    }

    public Map<String, MainMenuProperty> getMainMenuProperties() {
        return this.mainMenuProperties;
    }

    public Map<String, RoleProperty> getRoleProperties() {
        return this.roleProperties;
    }

    public Map<String, AddonProperty> getAddonProperties() {
        return this.addonProperties;
    }

    public Map<String, ConventionProperty> getConventionProperties() {
        return this.conventionProperties;
    }

    public Map<String, ViewConfigProperty> getViewConfigProperties() {
        return this.viewConfigProperties;
    }

    public String getName(String key) {
        NamingProperty property = (NamingProperty)this.namingProperties.get(key);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public String getMessage(String key, String[] rep) {
        MessageProperty messageProperty = (MessageProperty)this.messageProperties.get(key);
        if (messageProperty == null) {
            return "";
        }
        String message = messageProperty.getMessageBody();
        if (message == null) {
            return "";
        }
        if (rep == null) {
            return message;
        }
        for (int i = 0; i < rep.length; ++i) {
            message = message.replaceAll("%" + String.valueOf(i + 1) + "%", rep[i]);
        }
        return message;
    }

    public String getCodeItemName(String codeKey, String codeItemKey) {
        CodeProperty codeProperty = (CodeProperty)this.codeProperties.get(codeKey);
        if (codeProperty == null) {
            return codeKey;
        }
        CodeItemProperty codeItemProperty = (CodeItemProperty)codeProperty.getCodeItemMap().get(codeItemKey);
        if (codeItemProperty == null) {
            return codeItemKey;
        }
        return codeItemProperty.getItemName();
    }

    public String[][] getCodeArray(String codeKey, boolean needBlank) {
        String[][] array;
        CodeProperty codeProperty = (CodeProperty)this.codeProperties.get(codeKey);
        if (codeProperty == null) {
            return new String[0][0];
        }
        ArrayList list = new ArrayList(codeProperty.getCodeItemMap().values());
        Collections.sort(list, new IndexComparator());
        for (int i = list.size() - 1; i >= 0; --i) {
            CodeItemProperty codeItemProperty = (CodeItemProperty)list.get(i);
            if (codeItemProperty.getViewFlag() != 1) continue;
            list.remove(i);
        }
        int idx = 0;
        if (needBlank) {
            array = new String[list.size() + 1][2];
            array[0][0] = "";
            array[0][1] = "";
            ++idx;
        } else {
            array = new String[list.size()][2];
        }
        for (CodeItemProperty codeItemProperty : list) {
            array[idx][0] = codeItemProperty.getKey();
            array[idx][1] = codeItemProperty.getItemName();
            ++idx;
        }
        return array;
    }

    public void setApplicationProperties(Map<String, ApplicationProperty> applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public void setCommandProperties(Map<String, CommandProperty> commandProperties) {
        this.commandProperties = commandProperties;
    }

    public void setModelProperties(Map<String, ModelProperty> modelProperties) {
        this.modelProperties = modelProperties;
    }

    public void setMessageProperties(Map<String, MessageProperty> messageProperties) {
        this.messageProperties = messageProperties;
    }

    public void setNamingProperties(Map<String, NamingProperty> namingProperties) {
        this.namingProperties = namingProperties;
    }

    public void setCodeProperties(Map<String, CodeProperty> codeProperties) {
        this.codeProperties = codeProperties;
    }

    public void setAddonProperties(Map<String, AddonProperty> addonProperties) {
        this.addonProperties = addonProperties;
    }

    public void setMainMenuProperties(Map<String, MainMenuProperty> mainMenuProperties) {
        this.mainMenuProperties = mainMenuProperties;
    }

    public void setConventionProperties(Map<String, ConventionProperty> conventionProperties) {
        this.conventionProperties = conventionProperties;
    }

    public void setViewConfigProperties(Map<String, ViewConfigProperty> viewConfigProperties) {
        this.viewConfigProperties = viewConfigProperties;
    }

    public void setRoleProperties(Map<String, RoleProperty> roleProperties) {
        this.roleProperties = roleProperties;
    }
}

