/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * Exception performing whole class analysis ignored.
 */
public class MospRequestParser {
    protected static String encoding;

    private MospRequestParser() {
    }

    public static void parseRequestParams(HttpServletRequest request, MospParams mospParams) throws MospException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            mospParams.setRequestParamsMap(request.getParameterMap());
            return;
        }
        encoding = mospParams.getApplicationProperty("CharacterEncoding");
        List multipartFieldList = MospRequestParser.getMultiPartFieldList((HttpServletRequest)request);
        HashMap parameterMap = new HashMap();
        HashMap fileMap = new HashMap();
        for (FileItem item : multipartFieldList) {
            if (item.isFormField()) {
                MospRequestParser.putMultiPartField((FileItem)item, parameterMap);
                continue;
            }
            MospRequestParser.putMultiPartFile((FileItem)item, parameterMap, fileMap);
        }
        mospParams.setRequestParamsMap(parameterMap);
        mospParams.setRequestFilesMap(fileMap);
    }

    protected static List<FileItem> getMultiPartFieldList(HttpServletRequest request) throws MospException {
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        List multipartFieldList = null;
        try {
            multipartFieldList = sfu.parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new MospException((Throwable)e, "FWE9123", null);
        }
        ArrayList<FileItem> list = new ArrayList<FileItem>();
        for (Object obj : multipartFieldList) {
            list.add((FileItem)obj);
        }
        return list;
    }

    protected static void putMultiPartFile(FileItem item, Map<String, String[]> parameterMap, Map<String, InputStream> fileMap) throws MospException {
        try {
            fileMap.put(item.getFieldName(), item.getInputStream());
            String[] fileName = new String[]{item.getName()};
            parameterMap.put(item.getFieldName(), fileName);
        }
        catch (IOException e) {
            throw new MospException((Throwable)e, "FWE9123", null);
        }
    }

    protected static void putMultiPartField(FileItem item, Map<String, String[]> map) throws MospException {
        String name = item.getFieldName();
        String value = null;
        try {
            value = item.getString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new MospException((Throwable)e, "FWE9124", encoding);
        }
        String[] params = map.get(name);
        if (params == null) {
            String[] values = new String[]{value};
            map.put(name, values);
        } else {
            map.put(name, MospRequestParser.addParams((String[])params, (String)value));
        }
    }

    protected static String[] addParams(String[] params, String value) {
        String[] values = new String[params.length + 1];
        int idx = 0;
        for (String param : params) {
            values[idx++] = param;
        }
        values[idx] = value;
        return values;
    }
}

