/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.lang.reflect.Field;
import java.util.Map;
import jp.mosp.framework.base.MospException;

public class MospParametersMapper {
    protected static final String PREFIX_CHECK_BOX = "ckb";

    private MospParametersMapper() {
    }

    public static void mapParameters(Object obj, Map<String, String[]> parameters) throws MospException {
        try {
            Class<?> cls = obj.getClass();
            while (cls != null) {
                Field[] fields = cls.getDeclaredFields();
                if (fields == null) continue;
                for (Field field : fields) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Class<Object> type = field.getType();
                    String[] values = parameters.get(fieldName);
                    if (type.isAssignableFrom(String[].class)) {
                        if (values == null) continue;
                        field.set(obj, parameters.get(fieldName));
                        continue;
                    }
                    if (!type.isAssignableFrom(String.class)) continue;
                    if (values == null || values.length == 0) {
                        if (!fieldName.startsWith(PREFIX_CHECK_BOX)) continue;
                        field.set(obj, "0");
                        continue;
                    }
                    field.set(obj, values[0]);
                }
                cls = cls.getSuperclass();
            }
        }
        catch (SecurityException e) {
            throw new MospException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new MospException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new MospException((Throwable)e);
        }
    }
}

