/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.mosp.framework.base.BaseBeanInterface;
import jp.mosp.framework.base.BaseDaoInterface;
import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.base.RDBMSType;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.utils.DatabaseUtility;

public abstract class BaseBean
implements BaseBeanInterface {
    protected MospParams mospParams;
    protected Connection connection;
    private List<String[]> lockTableList;

    public BaseBean() {
    }

    protected BaseBean(MospParams mospParams, Connection connection) {
        this.setParams(mospParams, connection);
    }

    public void setParams(MospParams mospParams, Connection connection) {
        this.mospParams = mospParams;
        this.connection = connection;
    }

    protected BaseDaoInterface createDao(Class<?> cls) throws MospException {
        return InstanceFactory.loadDao(cls, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected BaseBeanInterface createBean(Class<?> cls) throws MospException {
        return InstanceFactory.loadBean(cls, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected BaseBeanInterface createBean(Class<?> cls, Date targetDate) throws MospException {
        return InstanceFactory.loadBean(cls, (Date)targetDate, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected BaseBeanInterface createBean(String modelClass) throws MospException {
        return InstanceFactory.loadBean((String)modelClass, (MospParams)this.mospParams, (Connection)this.connection);
    }

    protected void addTargetTable(String tableName, boolean isWrite) {
        if (this.lockTableList == null) {
            this.lockTableList = new ArrayList();
        }
        this.lockTableList.add(new String[]{tableName, String.valueOf(isWrite)});
    }

    protected void lockTables() throws MospException {
        Statement ps = null;
        try {
            ps = this.connection.prepareStatement(DatabaseUtility.getRDBMS((Connection)this.connection).lockTableSQL(this.lockTableList));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            if (e instanceof SQLTransientException) {
                throw new MospException((Throwable)e);
            }
            throw new MospException((Throwable)e);
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new MospException((Throwable)e);
            }
        }
    }

    protected void unlockTable() throws MospException {
        if (RDBMSType.MySQL.equals((Object)DatabaseUtility.getRDBMS((Connection)this.connection))) {
            PreparedStatement ps = null;
            try {
                ps = this.connection.prepareStatement("UNLOCK TABLES ");
                ps.executeUpdate();
            }
            catch (SQLException e) {
                if (e instanceof SQLTransientException) {
                    throw new MospException((Throwable)e);
                }
                throw new MospException((Throwable)e);
            }
            finally {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    throw new MospException((Throwable)e);
                }
            }
        }
    }

    protected BaseDto findForKey(BaseDaoInterface dao, long id, boolean isUpdate) throws MospException {
        return dao.findForKey(id, isUpdate);
    }

    protected boolean checkDuplicate(BaseDaoInterface dao, long id) throws MospException {
        return this.findForKey(dao, id, false) == null;
    }

    protected boolean checkExclusive(BaseDtoInterface formerDto, BaseDtoInterface baseDto) {
        return formerDto != null && baseDto != null && formerDto.getDeleteFlag() == 0 && formerDto.getUpdateDate().compareTo(baseDto.getUpdateDate()) == 0;
    }

    protected void checkInsert(BaseDaoInterface dao, long id) throws MospException {
        if (this.findForKey(dao, id, false) == null) {
            this.mospParams.addErrorMessage("FWE9221", new String[0]);
        }
    }

    protected void checkLogicalDelete(BaseDaoInterface dao, long id) throws MospException {
        BaseDto dto = this.findForKey(dao, id, false);
        if (dto != null && dto.getDeleteFlag() == 0) {
            this.mospParams.addErrorMessage("FWE9222", new String[0]);
        }
    }

    protected void logicalDelete(BaseDaoInterface dao, long id) throws MospException {
        BaseDto baseDto = dao.findForKey(id, true);
        baseDto.setDeleteFlag(1);
        if (this.checkExclusive((BaseDtoInterface)dao.findForKey(id, true), (BaseDtoInterface)baseDto)) {
            dao.update((BaseDtoInterface)baseDto);
            this.checkLogicalDelete(dao, id);
        } else {
            this.mospParams.addErrorMessage("FWE9223", new String[0]);
        }
    }
}

