/*
 * Decompiled with CFR 0.152.
 */
package jp.mosp.framework.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.mosp.framework.base.ActionInterface;
import jp.mosp.framework.base.BaseBeanHandlerInterface;
import jp.mosp.framework.base.DBConnBean;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.base.MospParams;
import jp.mosp.framework.instance.InstanceFactory;
import jp.mosp.framework.utils.LogUtility;

public abstract class BaseAction
implements ActionInterface {
    protected MospParams mospParams;
    protected List<DBConnBean> dbConnBeanList;
    protected Map<String, DBConnBean> dbConnBeanMap;

    public void init(MospParams mospParams) {
        this.mospParams = mospParams;
        this.dbConnBeanMap = new HashMap();
        this.dbConnBeanList = new ArrayList();
    }

    public void doAction() throws MospException {
        try {
            this.preAction();
            LogUtility.actionStart((MospParams)this.mospParams, (String)this.toString());
            this.action();
            LogUtility.actionEnd((MospParams)this.mospParams, (String)this.toString());
        }
        catch (MospException e) {
            throw e;
        }
        finally {
            this.afterAction();
        }
    }

    protected void preAction() throws MospException {
    }

    protected void afterAction() throws MospException {
        for (DBConnBean dbConnBean : this.dbConnBeanList) {
            dbConnBean.releaseConnection();
        }
        Set connectionSet = this.dbConnBeanMap.entrySet();
        for (Map.Entry entry : connectionSet) {
            ((DBConnBean)entry.getValue()).releaseConnection();
        }
    }

    protected BaseBeanHandlerInterface createHandler(Class<?> cls, DBConnBean dbConnBean) throws MospException {
        BaseBeanHandlerInterface beanHandler = InstanceFactory.loadBeanHandler(cls, (MospParams)this.mospParams);
        beanHandler.setConnection(dbConnBean);
        return beanHandler;
    }

    protected BaseBeanHandlerInterface createHandler(Class<?> cls, boolean needAnotherConnection) throws MospException {
        if (!needAnotherConnection && !this.dbConnBeanList.isEmpty()) {
            return this.createHandler(cls, (DBConnBean)this.dbConnBeanList.get(0));
        }
        DBConnBean dbConnBean = new DBConnBean(this.mospParams);
        this.dbConnBeanList.add(dbConnBean);
        return this.createHandler(cls, dbConnBean);
    }

    protected BaseBeanHandlerInterface createHandler(Class<?> cls, String dataSourceKey) throws MospException {
        DBConnBean dbConnBean = (DBConnBean)this.dbConnBeanMap.get(dataSourceKey);
        if (dbConnBean == null) {
            dbConnBean = new DBConnBean(this.mospParams, dataSourceKey);
            this.dbConnBeanMap.put(dataSourceKey, dbConnBean);
        }
        return this.createHandler(cls, dbConnBean);
    }

    protected BaseBeanHandlerInterface createHandler(Class<?> cls) throws MospException {
        return this.createHandler(cls, false);
    }

    protected void commit() throws MospException {
        for (DBConnBean dbConnBean : this.dbConnBeanList) {
            dbConnBean.commit();
        }
    }

    protected void commit(String key) throws MospException {
        DBConnBean dbConnBean = (DBConnBean)this.dbConnBeanMap.get(key);
        if (dbConnBean != null) {
            dbConnBean.commit();
        }
    }
}

