/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.report.dto;

import java.util.Date;

import jp.mosp.framework.base.BaseDto;

/**
 * 出勤簿DTOクラス。
 */
public class AttendanceBookDto extends BaseDto {
	
	private static final long	serialVersionUID	= -8199979603185252376L;
	
	/**
	 * 帳票タイトル(ヘッダ項目)。
	 */
	private String				title;
	
	/**
	 * 対象年月(ヘッダ項目)。
	 */
	private Date				targetYearMonth;
	
	/**
	 * 姓(ヘッダ項目)。
	 */
	private String				lastName;
	
	/**
	 * 名(ヘッダ項目)。
	 */
	private String				firstName;
	
	/**
	 * 所属名称(ヘッダ項目)。
	 */
	private String				sectionName;
	
	/**
	 * 勤務日。
	 */
	private Date				workDate;
	
	/**
	 * 勤務形態略称。
	 */
	private String				workTypeAbbr;
	
	/**
	 * 出勤時刻。
	 */
	private Date				startTime;
	
	/**
	 * 退勤時刻。
	 */
	private Date				endTime;
	
	/**
	 * 勤務時間。
	 */
	private Float				workTime;
	
	/**
	 * 遅刻時間。
	 */
	private Float				lateTime;
	
	/**
	 * 早退時間。
	 */
	private Float				leaveEarlyTime;
	
	/**
	 * 休憩時間。<br>
	 */
	private Float				restTime;
	
	/**
	 * 残業時間。<br>
	 */
	private Float				overtime;
	
	/**
	 * 法定外残業時間。
	 */
	private Float				overtimeOut;
	
	/**
	 * 深夜勤務時間。
	 */
	private Float				lateNightTime;
	
	/**
	 * 休日勤務時間。
	 */
	private Float				holidayWorkTime;
	
	/**
	 * 申請情報。
	 */
	private String				applicationInfo;
	
	/**
	 * 修正情報。<br>
	 * null(修正無し)、本(本人)、他(他人)。
	 */
	private String				correctionInfo;
	

	/**
	 * @return title
	 */
	public String getTitle() {
		return title;
	}
	
	/**
	 * @param title セットする title
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	
	/**
	 * @return targetYearMonth
	 */
	public Date getTargetYearMonth() {
		return getDateClone(targetYearMonth);
	}
	
	/**
	 * @param targetYearMonth セットする targetYearMonth
	 */
	public void setTargetYearMonth(Date targetYearMonth) {
		this.targetYearMonth = getDateClone(targetYearMonth);
	}
	
	/**
	 * @return lastName
	 */
	public String getLastName() {
		return lastName;
	}
	
	/**
	 * @param lastName セットする lastName
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	
	/**
	 * @return firstName
	 */
	public String getFirstName() {
		return firstName;
	}
	
	/**
	 * @param firstName セットする firstName
	 */
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	
	/**
	 * @return sectionName
	 */
	public String getSectionName() {
		return sectionName;
	}
	
	/**
	 * @param sectionName セットする sectionName
	 */
	public void setSectionName(String sectionName) {
		this.sectionName = sectionName;
	}
	
	/**
	 * @return workDate
	 */
	public Date getWorkDate() {
		return getDateClone(workDate);
	}
	
	/**
	 * @param workDate セットする workDate
	 */
	public void setWorkDate(Date workDate) {
		this.workDate = getDateClone(workDate);
	}
	
	/**
	 * @return workTypeAbbr
	 */
	public String getWorkTypeAbbr() {
		return workTypeAbbr;
	}
	
	/**
	 * @param workTypeAbbr セットする workTypeAbbr
	 */
	public void setWorkTypeAbbr(String workTypeAbbr) {
		this.workTypeAbbr = workTypeAbbr;
	}
	
	/**
	 * @return startTime
	 */
	public Date getStartTime() {
		return getDateClone(startTime);
	}
	
	/**
	 * @param startTime セットする startTime
	 */
	public void setStartTime(Date startTime) {
		this.startTime = getDateClone(startTime);
	}
	
	/**
	 * @return endTime
	 */
	public Date getEndTime() {
		return getDateClone(endTime);
	}
	
	/**
	 * @param endTime セットする endTime
	 */
	public void setEndTime(Date endTime) {
		this.endTime = getDateClone(endTime);
	}
	
	/**
	 * @return workTime
	 */
	public Float getWorkTime() {
		return workTime;
	}
	
	/**
	 * @param workTime セットする workTime
	 */
	public void setWorkTime(Float workTime) {
		this.workTime = workTime;
	}
	
	/**
	 * @return lateTime
	 */
	public Float getLateTime() {
		return lateTime;
	}
	
	/**
	 * @param lateTime セットする lateTime
	 */
	public void setLateTime(Float lateTime) {
		this.lateTime = lateTime;
	}
	
	/**
	 * @return leaveEarlyTime
	 */
	public Float getLeaveEarlyTime() {
		return leaveEarlyTime;
	}
	
	/**
	 * @param leaveEarlyTime セットする leaveEarlyTime
	 */
	public void setLeaveEarlyTime(Float leaveEarlyTime) {
		this.leaveEarlyTime = leaveEarlyTime;
	}
	
	/**
	 * @return restTime
	 */
	public Float getRestTime() {
		return restTime;
	}
	
	/**
	 * @param restTime セットする restTime
	 */
	public void setRestTime(Float restTime) {
		this.restTime = restTime;
	}
	
	/**
	 * @return overtime
	 */
	public Float getOvertime() {
		return overtime;
	}
	
	/**
	 * @param overtime セットする overtime
	 */
	public void setOvertime(Float overtime) {
		this.overtime = overtime;
	}
	
	/**
	 * @return overtimeOut
	 */
	public Float getOvertimeOut() {
		return overtimeOut;
	}
	
	/**
	 * @param overtimeOut セットする overtimeOut
	 */
	public void setOvertimeOut(Float overtimeOut) {
		this.overtimeOut = overtimeOut;
	}
	
	/**
	 * @return lateNightTime
	 */
	public Float getLateNightTime() {
		return lateNightTime;
	}
	
	/**
	 * @param lateNightTime セットする lateNightTime
	 */
	public void setLateNightTime(Float lateNightTime) {
		this.lateNightTime = lateNightTime;
	}
	
	/**
	 * @return holidayWorkTime
	 */
	public Float getHolidayWorkTime() {
		return holidayWorkTime;
	}
	
	/**
	 * @param holidayWorkTime セットする holidayWorkTime
	 */
	public void setHolidayWorkTime(Float holidayWorkTime) {
		this.holidayWorkTime = holidayWorkTime;
	}
	
	/**
	 * @return applicationInfo
	 */
	public String getApplicationInfo() {
		return applicationInfo;
	}
	
	/**
	 * @param applicationInfo セットする applicationInfo
	 */
	public void setApplicationInfo(String applicationInfo) {
		this.applicationInfo = applicationInfo;
	}
	
	/**
	 * @return correctionInfo
	 */
	public String getCorrectionInfo() {
		return correctionInfo;
	}
	
	/**
	 * @param correctionInfo セットする correctionInfo
	 */
	public void setCorrectionInfo(String correctionInfo) {
		this.correctionInfo = correctionInfo;
	}
	
}
