/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.dto.settings.impl;

import java.util.Date;

import jp.mosp.framework.base.BaseDto;
import jp.mosp.time.dto.settings.TotalTimeCutoffListDtoInterface;

/**
 * 勤怠集計管理締日情報一覧DTO
 */
public class TotalTimeCutoffListDto extends BaseDto implements TotalTimeCutoffListDtoInterface {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= 1784072235089155364L;
	
	/**
	 * 締状態。
	 */
	private int					cutoffState;
	/**
	 * レコード識別ID。
	 */
	private long				tmmCutoffId;
	/**
	 * 締日コード。
	 */
	private String				cutoffCode;
	/**
	 * 有効日。
	 */
	private Date				activateDate;
	/**
	 * 締日名称。
	 */
	private String				cutoffName;
	/**
	 * 締日略称。
	 */
	private String				cutoffAbbr;
	/**
	 * 締日。
	 */
	private int					cutoffDate;
	/**
	 * 無効フラグ。
	 */
	private int					inactivateFlag;
	

	@Override
	public int getCutoffState() {
		return cutoffState;
	}
	
	@Override
	public void setCutoffState(int cutoffState) {
		this.cutoffState = cutoffState;
	}
	
	@Override
	public Date getActivateDate() {
		return getDateClone(activateDate);
	}
	
	@Override
	public String getCutoffAbbr() {
		return cutoffAbbr;
	}
	
	@Override
	public String getCutoffCode() {
		return cutoffCode;
	}
	
	@Override
	public int getCutoffDate() {
		return cutoffDate;
	}
	
	@Override
	public String getCutoffName() {
		return cutoffName;
	}
	
	@Override
	public int getInactivateFlag() {
		return inactivateFlag;
	}
	
	@Override
	public long getTmmCutoffId() {
		return tmmCutoffId;
	}
	
	@Override
	public void setActivateDate(Date activateDate) {
		this.activateDate = getDateClone(activateDate);
	}
	
	@Override
	public void setCutoffAbbr(String cutoffAbbr) {
		this.cutoffAbbr = cutoffAbbr;
	}
	
	@Override
	public void setCutoffCode(String cutoffCode) {
		this.cutoffCode = cutoffCode;
	}
	
	@Override
	public void setCutoffDate(int cutoffDate) {
		this.cutoffDate = cutoffDate;
	}
	
	@Override
	public void setCutoffName(String cutoffName) {
		this.cutoffName = cutoffName;
	}
	
	@Override
	public void setInactivateFlag(int inactivateFlag) {
		this.inactivateFlag = inactivateFlag;
	}
	
	@Override
	public void setTmmCutoffId(long tmmCutoffId) {
		this.tmmCutoffId = tmmCutoffId;
	}
	
	@Override
	public String getCutoffType() {
		return getCutoffType();
	}
	
	@Override
	public int getNoApproval() {
		return getNoApproval();
	}
	
	@Override
	public void setCutoffType(String cutoffType) {
		setCutoffType(cutoffType);
		
	}
	
	@Override
	public void setNoApproval(int noApproval) {
		setNoApproval(noApproval);
	}
	
}
