/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.dto.settings.impl;

import java.util.Date;

import jp.mosp.framework.base.BaseDto;
import jp.mosp.time.dto.settings.TotalTimeDataDtoInterface;

/**
 * 勤怠集計データDTO
 */
public class TmdTotalTimeDataDto extends BaseDto implements TotalTimeDataDtoInterface {
	
	/**
	 * 
	 */
	private static final long	serialVersionUID	= 7389058681167622376L;
	
	/**
	 * レコード識別ID。
	 */
	private long				tmdTotalTimeId;
	/**
	 * 個人ID。
	 */
	private String				personalId;
	/**
	 * 年。
	 */
	private int					calculationYear;
	/**
	 * 月。
	 */
	private int					calculationMonth;
	/**
	 * 集計日。
	 */
	private Date				calculationDate;
	/**
	 * 勤務時間。
	 */
	private int					workTime;
	/**
	 * 所定勤務時間。
	 */
	private int					specificWorkTime;
	/**
	 * 出勤日数。
	 */
	private double				timesWorkDate;
	/**
	 * 出勤回数。
	 */
	private int					timesWork;
	/**
	 * 法定休日出勤日数。
	 */
	private double				legalWorkOnHoliday;
	/**
	 * 所定休日出勤日数。
	 */
	private double				specificWorkOnHoliday;
	/**
	 * 出勤実績日数。
	 */
	private int					timesAchievement;
	/**
	 * 出勤対象日数。
	 */
	private int					timesTotalWorkDate;
	/**
	 * 直行回数。
	 */
	private int					directStart;
	/**
	 * 直帰回数。
	 */
	private int					directEnd;
	/**
	 * 休憩時間。
	 */
	private int					restTime;
	/**
	 * 深夜休憩時間。
	 */
	private int					restLateNight;
	/**
	 * 所定休出休憩時間。
	 */
	private int					restWorkOnSpecificHoliday;
	/**
	 * 法定休出休憩時間。
	 */
	private int					restWorkOnHoliday;
	/**
	 * 公用外出時間。
	 */
	private int					publicTime;
	/**
	 * 私用外出時間。
	 */
	private int					privateTime;
	/**
	 * 残業時間。
	 */
	private int					overtimeIn;
	/**
	 * 法定外残業時間。
	 */
	private int					overtimeOut;
	/**
	 * 深夜時間。
	 */
	private int					lateNight;
	/**
	 * 所定休出時間。
	 */
	private int					workOnSpecificHoliday;
	/**
	 * 法定休出時間。
	 */
	private int					workOnHoliday;
	/**
	 * 減額対象時間。
	 */
	private int					decreaseTime;
	/**
	 * 45時間超残業時間。
	 */
	private int					fortyFiveHourOvertime;
	/**
	 * 残業回数。
	 */
	private int					timesOvertime;
	/**
	 * 休日出勤回数。
	 */
	private int					timesWorkingHoliday;
	/**
	 * 遅刻日数。
	 */
	private int					lateDays;
	/**
	 * 遅刻控除有り日数。
	 */
	private int					lateDeduction;
	/**
	 * 遅刻控除無し日数。
	 */
	private int					lateNoDeduction;
	/**
	 * 遅刻その他日数。
	 */
	private int					lateOther;
	/**
	 * 遅刻時間。
	 */
	private int					lateTime;
	/**
	 * 遅刻控除有り時間。
	 */
	private int					lateDeductionTime;
	/**
	 * 遅刻控除無し時間。
	 */
	private int					lateNoDeductionTime;
	/**
	 * 遅刻その他時間。
	 */
	private int					lateOtherTime;
	/**
	 * 遅刻回数。
	 */
	private int					timesLate;
	/**
	 * 早退日数。
	 */
	private int					leaveEarlyDays;
	/**
	 * 早退控除有り日数。
	 */
	private int					leaveEarlyDeduction;
	/**
	 * 早退控除無し日数。
	 */
	private int					leaveEarlyNoDeduction;
	/**
	 * 早退その他日数。
	 */
	private int					leaveEarlyOther;
	/**
	 * 早退時間。
	 */
	private int					leaveEarlyTime;
	/**
	 * 早退控除有り時間。
	 */
	private int					leaveEarlyDeductionTime;
	/**
	 * 早退控除無し時間。
	 */
	private int					leaveEarlyNoDeductionTime;
	/**
	 * 早退その他時間。
	 */
	private int					leaveEarlyOtherTime;
	/**
	 * 早退回数。
	 */
	private int					timesLeaveEarly;
	/**
	 * 休日日数。
	 */
	private int					timesHoliday;
	/**
	 * 法定休日日数。
	 */
	private int					timesLegalHoliday;
	/**
	 * 所定休日日数。
	 */
	private int					timesSpecificHoliday;
	/**
	 * 有給休暇日数。
	 */
	private double				timesPaidHoliday;
	/**
	 * 有給休暇時間。
	 */
	private int					paidHolidayHour;
	/**
	 * ストック休暇日数。
	 */
	private double				timesStockHoliday;
	/**
	 * 代休日数。
	 */
	private double				timesCompensation;
	/**
	 * 法定代休日数。
	 */
	private double				timesLegalCompensation;
	/**
	 * 所定代休日数。
	 */
	private double				timesSpecificCompensation;
	/**
	 * 深夜代休日数。
	 */
	private double				timesLateCompensation;
	/**
	 * 振替休日日数。
	 */
	private double				timesHolidaySubstitute;
	/**
	 * 法定振替休日日数。
	 */
	private double				timesLegalHolidaySubstitute;
	/**
	 * 所定振替休日日数。
	 */
	private double				timesSpecificHolidaySubstitute;
	/**
	 * 特別休暇合計日数。
	 */
	private double				totalSpecialHoliday;
	/**
	 * その他休暇合計日数。
	 */
	private double				totalOtherHoliday;
	/**
	 * 欠勤合計日数。
	 */
	private double				totalAbsence;
	/**
	 * 手当合計。
	 */
	private int					totalAllowance;
	/**
	 * 60時間超残業時間。
	 */
	private int					sixtyHourOvertime;
	/**
	 * 平日時間外時間。
	 */
	private int					weekDayOvertime;
	/**
	 * 所定休日時間外時間。
	 */
	private int					specificOvertime;
	/**
	 * 代替休暇日数。
	 */
	private double				timesAlternative;
	

	@Override
	public int getCalculationMonth() {
		return calculationMonth;
	}
	
	@Override
	public int getCalculationYear() {
		return calculationYear;
	}
	
	@Override
	public int getDecreaseTime() {
		return decreaseTime;
	}
	
	@Override
	public String getPersonalId() {
		return personalId;
	}
	
	@Override
	public int getFortyFiveHourOvertime() {
		return fortyFiveHourOvertime;
	}
	
	@Override
	public int getLateDeduction() {
		return lateDeduction;
	}
	
	@Override
	public int getLateDeductionTime() {
		return lateDeductionTime;
	}
	
	@Override
	public int getLateNight() {
		return lateNight;
	}
	
	@Override
	public int getLateNoDeduction() {
		return lateNoDeduction;
	}
	
	@Override
	public int getLateNoDeductionTime() {
		return lateNoDeductionTime;
	}
	
	@Override
	public int getLateOther() {
		return lateOther;
	}
	
	@Override
	public int getLateOtherTime() {
		return lateOtherTime;
	}
	
	@Override
	public int getLateTime() {
		return lateTime;
	}
	
	@Override
	public int getLeaveEarlyDeduction() {
		return leaveEarlyDeduction;
	}
	
	@Override
	public int getLeaveEarlyNoDeduction() {
		return leaveEarlyNoDeduction;
	}
	
	@Override
	public int getLeaveEarlyOther() {
		return leaveEarlyOther;
	}
	
	@Override
	public double getLegalWorkOnHoliday() {
		return legalWorkOnHoliday;
	}
	
	@Override
	public int getOvertimeIn() {
		return overtimeIn;
	}
	
	@Override
	public int getOvertimeOut() {
		return overtimeOut;
	}
	
	@Override
	public int getPaidHolidayHour() {
		return paidHolidayHour;
	}
	
	@Override
	public int getPrivateTime() {
		return privateTime;
	}
	
	@Override
	public int getPublicTime() {
		return publicTime;
	}
	
	@Override
	public int getRestLateNight() {
		return restLateNight;
	}
	
	@Override
	public int getRestTime() {
		return restTime;
	}
	
	@Override
	public int getRestWorkOnHoliday() {
		return restWorkOnHoliday;
	}
	
	@Override
	public int getRestWorkOnSpecificHoliday() {
		return restWorkOnSpecificHoliday;
	}
	
	@Override
	public int getSixtyHourOvertime() {
		return sixtyHourOvertime;
	}
	
	@Override
	public int getSpecificOvertime() {
		return specificOvertime;
	}
	
	@Override
	public double getSpecificWorkOnHoliday() {
		return specificWorkOnHoliday;
	}
	
	@Override
	public int getSpecificWorkTime() {
		return specificWorkTime;
	}
	
	@Override
	public double getTimesWorkDate() {
		return timesWorkDate;
	}
	
	@Override
	public double getTimesAlternative() {
		return timesAlternative;
	}
	
	@Override
	public double getTimesCompensation() {
		return timesCompensation;
	}
	
	@Override
	public int getTimesHoliday() {
		return timesHoliday;
	}
	
	@Override
	public int getTimesLate() {
		return timesLate;
	}
	
	@Override
	public double getTimesLateCompensation() {
		return timesLateCompensation;
	}
	
	@Override
	public int getTimesLeaveEarly() {
		return timesLeaveEarly;
	}
	
	@Override
	public double getTimesLegalCompensation() {
		return timesLegalCompensation;
	}
	
	@Override
	public int getTimesLegalHoliday() {
		return timesLegalHoliday;
	}
	
	@Override
	public double getTimesPaidHoliday() {
		return timesPaidHoliday;
	}
	
	@Override
	public double getTimesSpecificCompensation() {
		return timesSpecificCompensation;
	}
	
	@Override
	public int getTimesSpecificHoliday() {
		return timesSpecificHoliday;
	}
	
	@Override
	public double getTimesSpecificHolidaySubstitute() {
		return timesSpecificHolidaySubstitute;
	}
	
	@Override
	public double getTimesStockHoliday() {
		return timesStockHoliday;
	}
	
	@Override
	public double getTimesHolidaySubstitute() {
		return timesHolidaySubstitute;
	}
	
	@Override
	public int getTimesWork() {
		return timesWork;
	}
	
	@Override
	public long getTmdTotalTimeId() {
		return tmdTotalTimeId;
	}
	
	@Override
	public int getWeekDayOvertime() {
		return weekDayOvertime;
	}
	
	@Override
	public int getWorkOnHoliday() {
		return workOnHoliday;
	}
	
	@Override
	public int getWorkOnSpecificHoliday() {
		return workOnSpecificHoliday;
	}
	
	@Override
	public int getWorkTime() {
		return workTime;
	}
	
	@Override
	public int getTotalAllowance() {
		return totalAllowance;
	}
	
	@Override
	public void setCalculationMonth(int calculationMonth) {
		this.calculationMonth = calculationMonth;
	}
	
	@Override
	public void setCalculationYear(int calculationYear) {
		this.calculationYear = calculationYear;
	}
	
	@Override
	public void setDecreaseTime(int decreaseTime) {
		this.decreaseTime = decreaseTime;
	}
	
	@Override
	public void setPersonalId(String personalId) {
		this.personalId = personalId;
	}
	
	@Override
	public void setFortyFiveHourOvertime(int fortyFiveHourOvertime) {
		this.fortyFiveHourOvertime = fortyFiveHourOvertime;
	}
	
	@Override
	public void setLateDeduction(int lateDeduction) {
		this.lateDeduction = lateDeduction;
	}
	
	@Override
	public void setLateDeductionTime(int lateDeductionTime) {
		this.lateDeductionTime = lateDeductionTime;
	}
	
	@Override
	public void setLateNight(int lateNight) {
		this.lateNight = lateNight;
	}
	
	@Override
	public void setLateNoDeduction(int lateNoDeduction) {
		this.lateNoDeduction = lateNoDeduction;
	}
	
	@Override
	public void setLateNoDeductionTime(int lateNoDeductionTime) {
		this.lateNoDeductionTime = lateNoDeductionTime;
	}
	
	@Override
	public void setLateOther(int lateOther) {
		this.lateOther = lateOther;
	}
	
	@Override
	public void setLateOtherTime(int lateOtherTime) {
		this.lateOtherTime = lateOtherTime;
	}
	
	@Override
	public void setLateTime(int lateTime) {
		this.lateTime = lateTime;
	}
	
	@Override
	public void setLeaveEarlyDeduction(int leaveEarlyDeduction) {
		this.leaveEarlyDeduction = leaveEarlyDeduction;
	}
	
	@Override
	public void setLeaveEarlyNoDeduction(int leaveEarlyNoDeduction) {
		this.leaveEarlyNoDeduction = leaveEarlyNoDeduction;
	}
	
	@Override
	public void setLeaveEarlyOther(int leaveEarlyOther) {
		this.leaveEarlyOther = leaveEarlyOther;
	}
	
	@Override
	public void setLegalWorkOnHoliday(double legalWorkOnHoliday) {
		this.legalWorkOnHoliday = legalWorkOnHoliday;
	}
	
	@Override
	public void setOvertimeIn(int overtimeIn) {
		this.overtimeIn = overtimeIn;
	}
	
	@Override
	public void setOvertimeOut(int overtimeOut) {
		this.overtimeOut = overtimeOut;
	}
	
	@Override
	public void setPaidHolidayHour(int paidHolidayHour) {
		this.paidHolidayHour = paidHolidayHour;
	}
	
	@Override
	public void setPrivateTime(int privateTime) {
		this.privateTime = privateTime;
	}
	
	@Override
	public void setPublicTime(int publicTime) {
		this.publicTime = publicTime;
	}
	
	@Override
	public void setRestLateNight(int restLateNight) {
		this.restLateNight = restLateNight;
	}
	
	@Override
	public void setRestTime(int restTime) {
		this.restTime = restTime;
	}
	
	@Override
	public void setRestWorkOnHoliday(int restWorkOnHoliday) {
		this.restWorkOnHoliday = restWorkOnHoliday;
	}
	
	@Override
	public void setRestWorkOnSpecificHoliday(int restWorkOnSpecificHoliday) {
		this.restWorkOnSpecificHoliday = restWorkOnSpecificHoliday;
	}
	
	@Override
	public void setSixtyHourOvertime(int sixtyHourOvertime) {
		this.sixtyHourOvertime = sixtyHourOvertime;
	}
	
	@Override
	public void setSpecificOvertime(int specificOvertime) {
		this.specificOvertime = specificOvertime;
	}
	
	@Override
	public void setSpecificWorkOnHoliday(double specificWorkOnHoliday) {
		this.specificWorkOnHoliday = specificWorkOnHoliday;
	}
	
	@Override
	public void setSpecificWorkTime(int specificWorkTime) {
		this.specificWorkTime = specificWorkTime;
	}
	
	@Override
	public void setTimesWorkDate(double timesWorkDate) {
		this.timesWorkDate = timesWorkDate;
	}
	
	@Override
	public void setTimesAlternative(double timesAlternative) {
		this.timesAlternative = timesAlternative;
	}
	
	@Override
	public void setTimesCompensation(double timesCompensation) {
		this.timesCompensation = timesCompensation;
	}
	
	@Override
	public void setTimesHoliday(int timesHoliday) {
		this.timesHoliday = timesHoliday;
	}
	
	@Override
	public void setTimesLate(int timesLate) {
		this.timesLate = timesLate;
	}
	
	@Override
	public void setTimesLateCompensation(double timesLateCompensation) {
		this.timesLateCompensation = timesLateCompensation;
	}
	
	@Override
	public void setTimesLeaveEarly(int timesLeaveEarly) {
		this.timesLeaveEarly = timesLeaveEarly;
	}
	
	@Override
	public void setTimesLegalCompensation(double timesLegalCompensation) {
		this.timesLegalCompensation = timesLegalCompensation;
	}
	
	@Override
	public void setTimesLegalHoliday(int timesLegalHoliday) {
		this.timesLegalHoliday = timesLegalHoliday;
	}
	
	@Override
	public void setTimesPaidHoliday(double timesPaidHoliday) {
		this.timesPaidHoliday = timesPaidHoliday;
	}
	
	@Override
	public void setTimesSpecificCompensation(double timesSpecificCompensation) {
		this.timesSpecificCompensation = timesSpecificCompensation;
	}
	
	@Override
	public void setTimesSpecificHoliday(int timesSpecificHoliday) {
		this.timesSpecificHoliday = timesSpecificHoliday;
	}
	
	@Override
	public void setTimesSpecificHolidaySubstitute(double timesSpecificHolidaySubstitute) {
		this.timesSpecificHolidaySubstitute = timesSpecificHolidaySubstitute;
	}
	
	@Override
	public void setTimesStockHoliday(double timesStockHoliday) {
		this.timesStockHoliday = timesStockHoliday;
	}
	
	@Override
	public void setTimesHolidaySubstitute(double timesHolidaySubstitute) {
		this.timesHolidaySubstitute = timesHolidaySubstitute;
	}
	
	@Override
	public void setTimesWork(int timesWork) {
		this.timesWork = timesWork;
	}
	
	@Override
	public void setTmdTotalTimeId(long tmdTotalTimeId) {
		this.tmdTotalTimeId = tmdTotalTimeId;
	}
	
	@Override
	public void setWeekDayOvertime(int weekDayOvertime) {
		this.weekDayOvertime = weekDayOvertime;
	}
	
	@Override
	public void setWorkOnHoliday(int workOnHoliday) {
		this.workOnHoliday = workOnHoliday;
	}
	
	@Override
	public void setWorkOnSpecificHoliday(int workOnSpecificHoliday) {
		this.workOnSpecificHoliday = workOnSpecificHoliday;
	}
	
	@Override
	public void setWorkTime(int workTime) {
		this.workTime = workTime;
	}
	
	@Override
	public int getLeaveEarlyDeductionTime() {
		return leaveEarlyDeductionTime;
	}
	
	@Override
	public int getLeaveEarlyNoDeductionTime() {
		return leaveEarlyNoDeductionTime;
	}
	
	@Override
	public int getLeaveEarlyOtherTime() {
		return leaveEarlyOtherTime;
	}
	
	@Override
	public int getLeaveEarlyTime() {
		return leaveEarlyTime;
	}
	
	@Override
	public void setLeaveEarlyDeductionTime(int leaveEarlyDeductionTime) {
		this.leaveEarlyDeductionTime = leaveEarlyDeductionTime;
	}
	
	@Override
	public void setLeaveEarlyNoDeductionTime(int leaveEarlyNoDeductionTime) {
		this.leaveEarlyNoDeductionTime = leaveEarlyNoDeductionTime;
	}
	
	@Override
	public void setLeaveEarlyOtherTime(int leaveEarlyOtherTime) {
		this.leaveEarlyOtherTime = leaveEarlyOtherTime;
	}
	
	@Override
	public void setLeaveEarlyTime(int leaveEarlyTime) {
		this.leaveEarlyTime = leaveEarlyTime;
	}
	
	@Override
	public double getTotalOtherHoliday() {
		return totalOtherHoliday;
	}
	
	@Override
	public double getTotalSpecialHoliday() {
		return totalSpecialHoliday;
	}
	
	@Override
	public void setTotalOtherHoliday(double totalOtherHoliday) {
		this.totalOtherHoliday = totalOtherHoliday;
	}
	
	@Override
	public void setTotalSpecialHoliday(double totalSpecialHoliday) {
		this.totalSpecialHoliday = totalSpecialHoliday;
	}
	
	@Override
	public double getTotalAbsence() {
		return totalAbsence;
	}
	
	@Override
	public void setTotalAbsence(double totalAbsence) {
		this.totalAbsence = totalAbsence;
	}
	
	@Override
	public int getDirectEnd() {
		return directEnd;
	}
	
	@Override
	public int getDirectStart() {
		return directStart;
	}
	
	@Override
	public void setDirectEnd(int directEnd) {
		this.directEnd = directEnd;
	}
	
	@Override
	public void setDirectStart(int directStart) {
		this.directStart = directStart;
	}
	
	@Override
	public int getTimesOvertime() {
		return timesOvertime;
	}
	
	@Override
	public void setTimesOvertime(int timesOvertime) {
		this.timesOvertime = timesOvertime;
	}
	
	@Override
	public double getTimesLegalHolidaySubstitute() {
		return timesLegalHolidaySubstitute;
	}
	
	@Override
	public void setTimesLegalHolidaySubstitute(double timesLegalHolidaySubstitute) {
		this.timesLegalHolidaySubstitute = timesLegalHolidaySubstitute;
	}
	
	@Override
	public void setTotalAllowance(int totalAllowance) {
		this.totalAllowance = totalAllowance;
	}
	
	@Override
	public int getLateDays() {
		return lateDays;
	}
	
	@Override
	public int getLeaveEarlyDays() {
		return leaveEarlyDays;
	}
	
	@Override
	public int getTimesWorkingHoliday() {
		return timesWorkingHoliday;
	}
	
	@Override
	public void setTimesWorkingHoliday(int timesWorkingHoliday) {
		this.timesWorkingHoliday = timesWorkingHoliday;
	}
	
	@Override
	public void setLateDays(int lateDays) {
		this.lateDays = lateDays;
	}
	
	@Override
	public void setLeaveEarlyDays(int leaveEarlyDays) {
		this.leaveEarlyDays = leaveEarlyDays;
	}
	
	@Override
	public int getTimesAchievement() {
		return timesAchievement;
	}
	
	@Override
	public int getTimesTotalWorkDate() {
		return timesTotalWorkDate;
	}
	
	@Override
	public void setTimesAchievement(int timesAchievement) {
		this.timesAchievement = timesAchievement;
	}
	
	@Override
	public void setTimesTotalWorkDate(int timesTotalWorkDate) {
		this.timesTotalWorkDate = timesTotalWorkDate;
	}
	
	@Override
	public Date getCalculationDate() {
		return calculationDate;
	}
	
	@Override
	public void setCalculationDate(Date calculationDate) {
		this.calculationDate = calculationDate;
	}
	
}
