/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.dto.settings;

import java.util.Date;

import jp.mosp.framework.base.BaseDtoInterface;

/**
 * 社員勤怠集計管理DTOインターフェース。
 */
public interface TotalTimeEmployeeDtoInterface extends BaseDtoInterface {
	
	/**
	 * @return レコード識別ID。
	 */
	public long getTmtTotalTimeEmployeeId();
	
	/**
	 * @param tmtTotalTimeEmployeeId セットする レコード識別ID。
	 */
	public void setTmtTotalTimeEmployeeId(long tmtTotalTimeEmployeeId);
	
	/**
	 * @return 個人ID。
	 */
	public String getPersonalId();
	
	/**
	 * @param personalId セットする 個人ID。
	 */
	public void setPersonalId(String personalId);
	
	/**
	 * @return 集計年。
	 */
	public int getCalculationYear();
	
	/**
	 * @param calculationYear セットする 集計年。
	 */
	public void setCalculationYear(int calculationYear);
	
	/**
	 * @return 集計月。
	 */
	public int getCalculationMonth();
	
	/**
	 * @param calculationMonth セットする 集計月。
	 */
	public void setCalculationMonth(int calculationMonth);
	
	/**
	 * @return 締日コード。
	 */
	public String getCutoffCode();
	
	/**
	 * @param cutoffCode セットする 締日コード。
	 */
	public void setCutoffCode(String cutoffCode);
	
	/**
	 * @return 集計日。
	 */
	public Date getCalculationDate();
	
	/**
	 * @param calculationDate セットする 集計日。
	 */
	public void setCalculationDate(Date calculationDate);
	
	/**
	 * @return 締状態。
	 */
	public int getCutoffState();
	
	/**
	 * @param cutoffState セットする 締状態。
	 */
	public void setCutoffState(int cutoffState);
	
}
