/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.dto.settings;

import java.util.Date;

import jp.mosp.platform.base.PlatformDtoInterface;
import jp.mosp.platform.dto.base.EmployeeCodeDtoInterface;
import jp.mosp.platform.dto.base.EmployeeNameDtoInterface;
import jp.mosp.platform.dto.base.SectionCodeDtoInterface;

/**
 * 有給休暇手動付与一覧DTOインターフェース。
 */
public interface PaidHolidayHistoryListDtoInterface extends PlatformDtoInterface, EmployeeCodeDtoInterface,
		EmployeeNameDtoInterface, SectionCodeDtoInterface {
	
	/**
	 * @return 有効日
	 */
	public Date getActivateDate();
	
	/**
	 * @param activateDate セットする 有効日
	 */
	public void setActivateDate(Date activateDate);
	
	/**
	 * @return 前年日数
	 */
	public double getFormerDate();
	
	/**
	 * @param formerDate セットする 前年日数
	 */
	public void setFormerDate(double formerDate);
	
	/**
	 * @return 前年時間
	 */
	public int getFormerTime();
	
	/**
	 * @param formerTime セットする 前年時間
	 */
	public void setFormerTime(int formerTime);
	
	/**
	 * @return 今年日数
	 */
	public double getDate();
	
	/**
	 * @param date セットする 今年日数
	 */
	public void setDate(double date);
	
	/**
	 * @return 今年時間
	 */
	public int getTime();
	
	/**
	 * @param time セットする 今年時間
	 */
	public void setTime(int time);
	
	/**
	 * @return ストック日数
	 */
	public double getStockDate();
	
	/**
	 * @param stockDate セットする ストック日数
	 */
	public void setStockDate(double stockDate);
	
	/**
	 * @return レコード識別ID。
	 */
	long getTmdPaidHolidayHistoryListId();
	
	/**
	 * @param tmdPaidHolidayHistoryListId セットする レコード識別ID。
	 */
	void setTmdPaidHolidayHistoryListId(long tmdPaidHolidayHistoryListId);
	
}
