/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 * 
 */
package jp.mosp.time.dao.settings.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.mosp.framework.base.BaseDto;
import jp.mosp.framework.base.BaseDtoInterface;
import jp.mosp.framework.base.MospException;
import jp.mosp.framework.utils.DateUtility;
import jp.mosp.platform.base.PlatformDao;
import jp.mosp.time.dao.settings.CutoffDaoInterface;
import jp.mosp.time.dao.settings.TotalTimeCutoffDaoInterface;
import jp.mosp.time.dto.settings.CutoffDtoInterface;
import jp.mosp.time.dto.settings.impl.TmmCutoffDto;

/**
 * 勤怠集計管理DAOクラス。
 */
public class TotalTimeCutoffDao extends PlatformDao implements TotalTimeCutoffDaoInterface {
	
	private CutoffDaoInterface	cutoffDao;
	
	/**
	 * 締日コード。
	 */
	public static final String	COL_CUTOFF_CODE	= TmmCutoffDao.COL_CUTOFF_CODE;
	
	/**
	 * 締日名称。
	 */
	public static final String	COL_CUTOFF_NAME	= TmmCutoffDao.COL_CUTOFF_NAME;
	
	/**
	 * 締日略称。
	 */
	public static final String	COL_CUTOFF_ABBR	= TmmCutoffDao.COL_CUTOFF_ABBR;
	

	/**
	 * コンストラクタ。
	 */
	public TotalTimeCutoffDao() {
		// 処理無し
	}
	
	@Override
	public void initDao() throws MospException {
		// インスタンス生成(サブクエリ等を取得するためのDAOクラス生成)
		cutoffDao = (CutoffDaoInterface)loadInstance(CutoffDaoInterface.class);
	}
	
	@Override
	public BaseDto mapping() throws MospException {
		TmmCutoffDto dto = new TmmCutoffDto();
		dto.setCutoffCode(getString(COL_CUTOFF_CODE));
		dto.setCutoffName(getString(COL_CUTOFF_NAME));
		dto.setCutoffAbbr(getString(COL_CUTOFF_ABBR));
		mappingCommonInfo(dto);
		return dto;
	}
	
	@Override
	public List<CutoffDtoInterface> mappingAll() throws MospException {
		List<CutoffDtoInterface> all = new ArrayList<CutoffDtoInterface>();
		while (next()) {
			all.add((CutoffDtoInterface)mapping());
		}
		return all;
	}
	
	@Override
	public int update(BaseDtoInterface baseDto) throws MospException {
		// TODO 自動生成されたメソッド・スタブ
		return 0;
	}
	
	@Override
	public int delete(BaseDtoInterface baseDto) throws MospException {
		// TODO 自動生成されたメソッド・スタブ
		return 0;
	}
	
	@Override
	public void setParams(BaseDtoInterface baseDto, boolean isInsert) throws MospException {
		// TODO 自動生成されたメソッド・スタブ
	}
	
	@Override
	public List<CutoffDtoInterface> findForSearch(Map<String, Object> param) throws MospException {
		try {
			// 検索条件準備
			int requestYear = ((Integer)param.get("requestYear")).intValue();
			int requestMonth = ((Integer)param.get("requestMonth")).intValue();
			String cutoffDate = String.valueOf(param.get("cutoffDate"));
			String cutoffCode = String.valueOf(param.get("cutoffCode"));
			String cutoffName = String.valueOf(param.get("cutoffName"));
//			String cutoffState = String.valueOf(param.get("cutoffState"));
			Date activateDate = DateUtility.getDate(requestYear, requestMonth, 1);
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append(getSelectStatement(getClass()));
			sb.append(from(TmmCutoffDao.TABLE));
			sb.append(where());
			sb.append(deleteFlagOff());
			sb.append(and());
			sb.append(equal(TmmCutoffDao.COL_INACTIVATE_FLAG, 0));
			sb.append(and());
			sb.append(like(COL_CUTOFF_CODE));
			sb.append(and());
			sb.append(like(COL_CUTOFF_NAME));
			if (!cutoffDate.isEmpty()) {
				sb.append(and());
				sb.append(equal(TmmCutoffDao.COL_CUTOFF_DATE));
			}
			if (activateDate != null) {
				sb.append(and());
				sb.append(cutoffDao.getQueryForMaxActivateDate());
			}
			prepareStatement(sb.toString());
			setParam(index++, startWithParam(cutoffCode));
			setParam(index++, containsParam(cutoffName));
			if (!cutoffDate.isEmpty()) {
				setParam(index++, Integer.parseInt(cutoffDate));
			}
			if (activateDate != null) {
				setParam(index++, activateDate);
			}
			executeQuery();
			return mappingAll();
		} catch (Throwable e) {
			throw new MospException(e);
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	@Override
	public Map<String, Object> getParamsMap() {
		return new HashMap<String, Object>();
	}
	
}
