/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.time.constant;

/**
 * MosPシステムで用いるメッセージキーの定数を宣言する。<br><br>
 */
public final class TimeMessageConst {
	
	// クライアントメッセージコード
	/**
	 * 入力内容エラー時のメッセージコード。<br>
	 */
	public static final String	MSG_NOT_APPROVAL								= "TMW0201";
	
	/**
	 * 時間（時）チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_HOUR_CHECK									= "TMW0202";
	
	/**
	 * 時間（分）チェック範囲外エラーメッセージ。<br>
	 */
	public static final String	MSG_MINUTE_CHECK								= "TMW0203";
	
	/**
	 * データ重複エラーメッセージ。<br>
	 */
	public static final String	MSG_REPETITION_CHECK							= "TMW0204";
	
	/**
	 * ラジオチェック不正エラーメッセージ。<br>
	 */
	public static final String	MSG_RADIO_CHECK									= "TMW0205";
	
	/**
	 * 表示期間日付チェック不正エラーメッセージ。<br>
	 */
	public static final String	MSG_DISPLAYDATE_CHECK							= "TMW0206";
	
	/**
	 * データ有無エラーメッセージ。<br>
	 */
	public static final String	MSG_EXISTENCE_CHECK								= "TMW0207";
	
	/**
	 * 入社日/月データ重複エラーメッセージ。<br>
	 */
	public static final String	MSG_REPETITION_JOIN_CHECK						= "TMW0208";
	
	/**
	 * 入社日/月データ有無エラーメッセージ。<br>
	 */
	public static final String	MSG_EXISTENCE_JOIN_CHECK						= "TMW0209";
	
	/**
	 * 自動付与欄（基準日）相関チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_AUTO_GIVE_CORRELATION						= "TMW0210";
	
	/**
	 * 自動付与欄（入社日/入社月）相関チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_JOIN_CORRELATION							= "TMW0211";
	
	/**
	 * 半休取得時休憩相関チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_HALFDAY_ACQUISITION							= "TMW0212";
	
	/**
	 * 設定情報選択チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_SETUP_INFORMATION							= "TMW0213";
	
	/**
	 * プルダウン存在チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_WORKFORM_EXISTENCE							= "TMW0214";
	
	/**
	 * 出勤率範囲チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_WORK_RATE_CHECK								= "TMW0215";
	
	/**
	 * 振替日重複チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_TRANSFER_REPETITION_CHECK					= "TMW0216";
	
	/**
	 * 付与日数値チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_GIVINGDAY_VALUE_CHECK						= "TMW0219";
	
	/**
	 * 時差出勤変更確認メッセージ。<br>
	 */
	public static final String	MSG_FLEXTIME_CHANGE_CHECK						= "TMW0220";
	
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_APPLICATION_CHECK_1							= "TMW0221";
	
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_APPLICATION_CHECK_2							= "TMW0222";
	
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_APPLICATION_CHECK_3							= "TMW0223";
	/**
	 * 該当締日コードが使用されていた場合の警告メッセージ。<br>
	 */
	public static final String	MSG_CUTOFF_CODE_IS_USED							= "TMW0224";
	/**
	 * 該当勤務形態コードが使用されていた場合の警告メッセージ。<br>
	 */
	public static final String	MSG_WORK_TYPE_CODE_IS_USED						= "TMW0225";
	/**
	 * 該当マスタコードが使用されていた場合の警告メッセージ。<br>
	 */
	public static final String	MSG_SELECTED_CODE_IS_USED						= "TMW0226";
	/**
	 * 休暇種別MAX件数オーバーエラーメッセージ。<br>
	 */
	public static final String	MSG_HOLIDAY_TYPE_MAX_OVER						= "TMW0227";
	/**
	 * カレンダ履歴追加時の該当有効日における重複エラーメッセージ。<br>
	 */
	public static final String	MSG_SCHEDULE_HIST_ALREADY_EXISTED				= "TMW0228";
	/**
	 * 設定適用管理情報の適用範囲が未登録時のエラーメッセージ。<br>
	 */
	public static final String	MSG_APPLICATION_UNSETTING						= "TMW0229";
	/**
	 * 休暇申請時に時差出勤が申請されていた場合のメッセージコード。<br>
	 */
	public static final String	MSG_DIFFERENCE_REQUEST_CHECK					= "TMW0230";
	/**
	 * カレンダ管理詳細画面でのチェックボックスのNULLチェックメッセージコード。<br>
	 */
	public static final String	MSG_SCHEDULE_CHECK								= "TMW0231";
	/**
	 * 時刻のフォーマットエラーメッセージ。<br>
	 */
	public static final String	MSG_TIME_FORMAT_CHECK							= "TMW0233";
	/**
	 * 起算時刻オーバーエラーメッセージ。<br>
	 */
	public static final String	MSG_START_DAY_TIME_CHECK						= "TMW0235";
	/**
	 * 始業/終業時刻エラーメッセージ。<br>
	 */
	public static final String	MSG_START_END_TIME_CHECK						= "TMW0236";
	/**
	 * 勤務時間の範囲チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_WORK_TIME_OUT_CHECK							= "TMW0237";
	/**
	 * 休憩/外出時間重複エラーメッセージ。<br>
	 */
	public static final String	MSG_REST_GOING_OUT_CHECK						= "TMW0238";
	/**
	 * 半休時間重複エラーメッセージ。<br>
	 */
	public static final String	MSG_HARF_REST_CHECK								= "TMW0239";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_1								= "TMW0240";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_2								= "TMW0241";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_3								= "TMW0242";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_4								= "TMW0243";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_5								= "TMW0244";
	/**
	 * 該当する承認者がいない場合のエラーメッセージ。<br>
	 */
	public static final String	MSG_NOT_APPROVER								= "TMW0245";
	/**
	 * 設定適用管理情報の適用範囲に含まれていない、または適用する情報に不備の場合のエラーメッセージ。<br>
	 */
	public static final String	MSG_SETTING_APPLICATION_DEFECT					= "TMW0246";
	/**
	 * 振替可能な期間を超過している場合のエラーメッセージ。<br>
	 */
	public static final String	MSG_TRANSFER_DAY_EXCESS							= "TMW0248";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_6								= "TMW0249";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_7								= "TMW0250";
	/**
	 * 休暇申請のエラーメッセージ。<br>
	 */
	public static final String	MSG_HOLIDAY_ACTIVATIONDATE						= "TMW0251";
	/**
	 * 第九日数のエラーメッセージ。<br>
	 */
	public static final String	MSG_SUBHOLIDAY_DAY_CHECK						= "TMW0252";
	/**
	 * 適用する情報に不備の場合のエラーメッセージ。<br>
	 */
	public static final String	MSG_SETTING_APPLICATION_DEFECT_2				= "TMW0253";
	/**
	 * 休暇申請する際に休暇日数を超過していた場合のエラーメッセージ。<br>
	 */
	public static final String	MSG_HOLIDAY_NUM_DAYS_EXCESS						= "TMW0254";
	/**
	 * 登録できない場合のエラーメッセージ。<br>
	 */
	public static final String	MSG_NOT_REGISTER								= "TMW0255";
	/**
	 * 1年目にストック休暇が付与できない場合エラーメッセージ。<br>
	 */
	public static final String	MSG_NOT_STOCK_VACATION_GRANT					= "TMW0256";
	/**
	 * 入社していない社員が選択されている場合エラーメッセージ。<br>
	 */
	public static final String	MSG_NOT_JOINED_GRANT							= "TMW0257";
	/**
	 * 入社1年目であるため前年度の有給休暇を付与する場合エラーメッセージ。<br>
	 */
	public static final String	MSG_NOT_WITH_PAY_VACATION_GRANT					= "TMW0258";
	/**
	 * 付与日は前月の締日よりも後の場合エラーメッセージ。<br>
	 */
	public static final String	MSG_GRANT_DATE_MORE_PREVIOUS					= "TMW0259";
	/**
	 * 入力されている社員コートが正しくない場合エラーメッセージ。<br>
	 */
	public static final String	MSG_NOT_EXIST_EMPLOYEES							= "TMW0260";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_8								= "TMW0261";
	/**
	 * 未登録時のエラーメッセージ。<br>
	 */
	public static final String	MSG_UNSETTING									= "TMW0262";
	/**
	 * 既に手動付与が行われている日付に同じ社員へ手動付与を行う場合エラーメッセージ。<br>
	 */
	public static final String	MSG_NOT_EXIST_WITH_PAY_VACATION_GRANT			= "TMW0263";
	/**
	 * 遅刻、早退時間が限度時間を超えた場合エラーメッセージ。<br>
	 */
	public static final String	MSG_TARDINESS_LEAVE_EARLY_LIMIT_OVER			= "TMW0264";
	/**
	 * プルダウン存在チェックエラーメッセージ。<br>
	 */
	public static final String	MSG_WORKFORM_EXISTENCE2							= "TMW0265";
	/**
	 * カレンダ管理で使用するエラーメッセージ。<br>
	 */
	public static final String	MSG_CALENDAR_ERROR_MESSAGE						= "TMW0266";
	/**
	 * 申請状態が完了で無い場合でその申請状態を変更するように表示するメッセージ。<br>
	 */
	public static final String	MSG_NOT_REQUEST_STATE_COMPLETE					= "TMW0267";
	/**
	 * 下書時の始業時刻、終業時刻の未入力メッセージ<br>
	 */
	public static final String	MSG_DRAFT_TIME_NOT_INPUT						= "TMW0268";
	/**
	 * 休暇種別管理の削除、無効時に対象コード使われている場合のメッセージ<br>
	 */
	public static final String	MSG_WARNING_TARGET_CODE_VACATION_GRANT_DELETE	= "TMW0269";
	/**
	 * 休暇種別管理の対象の項目に0が設定されている場合のメッセージ<br>
	 */
	public static final String	MSG_HOLIDAY_ITEM_ZERO							= "TMW0270";
	/**
	 * 休暇種別管理の対象の項目に0が設定されている場合のメッセージ<br>
	 */
	public static final String	MSG_GRANT_PERIOD_LESS							= "TMW0271";
	/**
	 * 月次処理が行われている場合のメッセージ<br>
	 */
	public static final String	MSG_MONTHLY_TREATMENT							= "TMW0272";
	/**
	 * 勤怠管理対象では無いユーザに対するメッセージ<br>
	 */
	public static final String	MSG_NOT_USER_ATTENDANCE_MANAGEMENT_TARGET		= "TMW0273";
	/**
	 * 未締の状態の場合のメッセージ<br>
	 */
	public static final String	MSG_NOT_TIGHTENING								= "TMW0274";
	/**
	 * 申請時のエラーメッセージ。<br>
	 */
	public static final String	MSG_REQUEST_CHECK_9								= "TMW0277";
	
	/**
	 * ファイルパス(MosP勤怠管理共通JSP)。
	 */
	public static final String	PATH_TIME_COMMON_INFO_JSP						= "/jsp/time/base/timeCommonInfo.jsp";
	
	/**
	 * ファイルパス(MosP勤怠管理申請ステータス共通JSP)。
	 */
	public static final String	TIME_COMMON_STATUS_APPLICATION_INFO				= "/jsp/time/base/timeCommonStatusApplicationInfo.jsp";
	
	/**
	 * ファイルパス(MosP勤怠管理申請承認者共通JSP)。
	 */
	public static final String	TIME_COMMON_APPROVER_SETTING_INFO				= "/jsp/time/base/timeCommonApproverSettingInfo.jsp";
	
}
